/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.netty.websocket;

import cn.weforward.common.crypto.Hex;
import cn.weforward.common.execption.BusyException;
import cn.weforward.common.sys.ClockTick;
import cn.weforward.common.util.Bytes;
import cn.weforward.common.util.NumberUtil;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.aio.ClientChannel;
import cn.weforward.protocol.aio.ClientContext;
import cn.weforward.protocol.aio.ClientHandler;
import cn.weforward.protocol.aio.ConnectionListener;
import cn.weforward.protocol.aio.ServerHandlerFactory;
import cn.weforward.protocol.aio.netty.websocket.WebSocketSession;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.OutOfDirectMemoryError;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketContext
extends ChannelInboundHandlerAdapter
implements ClientChannel {
    protected static final Logger _Logger = LoggerFactory.getLogger(WebSocketContext.class);
    protected static final ClockTick _Tick = ClockTick.getInstance((int)1);
    protected static final ByteBuf _PingData = Unpooled.wrappedBuffer((byte[])"weforward".getBytes()).asReadOnly();
    protected static final Map<String, WebSocketSession> _clean = Collections.emptyMap();
    public static final int _MaxRequests = NumberUtil.toInt((String)System.getProperty("cn.weforward.protocol.aio.netty.websocket.MAX_REQUESTS"), (int)1000);
    protected ServerHandlerFactory m_HandlerFactory = ServerHandlerFactory._unassigned;
    protected ChannelHandlerContext m_Ctx;
    protected String m_RemoteAddr;
    protected Map<String, WebSocketSession> m_Multiplex;
    protected AtomicLong m_Sequencer;
    protected long m_LastActivity;
    protected long m_RequestCounter;
    protected ScheduledFuture<?> m_PingTask;
    protected ScheduledFuture<?> m_IdleTask;
    protected ConnectionListener m_ConnectionListener = ConnectionListener._unassigned;

    public WebSocketContext(ServerHandlerFactory factory) {
        this.m_Multiplex = new HashMap<String, WebSocketSession>();
        this.m_Sequencer = new AtomicLong();
        this.m_HandlerFactory = factory;
    }

    public void setServerHandlerFactory(ServerHandlerFactory factory) {
        this.m_HandlerFactory = factory;
    }

    public void setConnectionListener(ConnectionListener listener) {
        this.m_ConnectionListener = listener;
    }

    public ConnectionListener getConnectionListener() {
        return this.m_ConnectionListener;
    }

    public void lost(ChannelHandlerContext ctx) {
        ConnectionListener listener;
        if (ctx != null) {
            this.initRemoteAddr(ctx.channel());
        }
        if (ConnectionListener._unassigned == (listener = this.m_ConnectionListener)) {
            return;
        }
        this.m_ConnectionListener = ConnectionListener._unassigned;
        listener.lost(this);
    }

    public ChannelHandlerContext getChannelContext() {
        return this.m_Ctx;
    }

    protected void initRemoteAddr(Channel channel) {
        if (this.m_RemoteAddr != null) {
            return;
        }
        InetSocketAddress ip = (InetSocketAddress)channel.remoteAddress();
        if (ip != null) {
            this.m_RemoteAddr = String.valueOf(ip.getAddress().getHostAddress()) + ':' + ip.getPort();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof OutOfDirectMemoryError || cause.getCause() instanceof OutOfDirectMemoryError) {
            ctx.close();
        }
        super.exceptionCaught(ctx, cause);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.m_Ctx = ctx;
        if (_Logger.isDebugEnabled()) {
            _Logger.debug(this.formatMessage("handlerAdded"));
        }
        this.initRemoteAddr(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug(this.formatMessage("channelInactive"));
            }
            this.cleanup();
            this.lost(ctx);
        }
        finally {
            super.channelInactive(ctx);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (this.m_Ctx != null && ctx != this.m_Ctx) {
                _Logger.error("\u4e0d\u4e00\u6837\u7684Context\uff1f" + this.m_Ctx + "!=" + ctx);
                ctx.close();
                return;
            }
            if (msg instanceof WebSocketFrame) {
                this.m_LastActivity = _Tick.getTickerLong();
                WebSocketFrame wsframe = (WebSocketFrame)msg;
                if (wsframe instanceof BinaryWebSocketFrame || wsframe instanceof TextWebSocketFrame || wsframe instanceof ContinuationWebSocketFrame) {
                    this.readable(wsframe);
                    return;
                }
                if (wsframe instanceof PingWebSocketFrame) {
                    PongWebSocketFrame pong = new PongWebSocketFrame(wsframe.content().retain());
                    ctx.channel().writeAndFlush((Object)pong);
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug(this.formatMessage("pong"));
                    }
                    return;
                }
                if (wsframe instanceof CloseWebSocketFrame) {
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug(this.formatMessage("closing"));
                    }
                    ctx.close();
                    return;
                }
                if (_Logger.isDebugEnabled() && !(wsframe instanceof PongWebSocketFrame)) {
                    _Logger.debug(this.formatMessage("\u672a\u77e5\u5e27\u7c7b\u578b\uff1f" + msg));
                }
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public synchronized void setKeepalive(int seconds) {
        if (this.m_PingTask != null) {
            this.m_PingTask.cancel(false);
            this.m_PingTask = null;
        }
        if (seconds < 1) {
            return;
        }
        ChannelHandlerContext ctx = this.m_Ctx;
        if (ctx == null) {
            return;
        }
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                ChannelHandlerContext ctx = WebSocketContext.this.m_Ctx;
                if (ctx == null) {
                    return;
                }
                PingWebSocketFrame ping = new PingWebSocketFrame(true, 0, _PingData.retainedDuplicate());
                ChannelFuture future = ctx.channel().writeAndFlush((Object)ping);
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug(WebSocketContext.this.formatMessage("ping"));
                    future.addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

                        public void operationComplete(Future<Void> future) throws Exception {
                            if (!future.isSuccess()) {
                                _Logger.debug(WebSocketContext.this.formatMessage("ping fail"), future.cause());
                            }
                        }
                    });
                }
            }
        };
        this.m_PingTask = ctx.executor().scheduleWithFixedDelay(worker, (long)seconds, (long)seconds, TimeUnit.SECONDS);
    }

    public synchronized void setIdle(final int seconds) {
        if (this.m_IdleTask != null) {
            this.m_IdleTask.cancel(false);
            this.m_IdleTask = null;
        }
        if (seconds < 1) {
            return;
        }
        ChannelHandlerContext ctx = this.m_Ctx;
        if (ctx == null) {
            return;
        }
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                if (_Tick.getTickerLong() > WebSocketContext.this.m_LastActivity + (long)seconds) {
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug(WebSocketContext.this.formatMessage("idle"));
                    }
                    WebSocketContext.this.m_IdleTask.cancel(false);
                    WebSocketContext.this.m_IdleTask = null;
                    WebSocketContext.this.close();
                }
            }
        };
        this.m_IdleTask = ctx.executor().scheduleWithFixedDelay(worker, (long)seconds, (long)seconds, TimeUnit.SECONDS);
    }

    public String getRemoteAddr() {
        return this.m_RemoteAddr;
    }

    protected char getSideMarker() {
        return 'w';
    }

    public String genSequence() {
        StringBuilder builder = StringBuilderPool._128.poll();
        try {
            builder.append(this.getSideMarker());
            Hex.toHex((long)this.m_Sequencer.incrementAndGet(), (StringBuilder)builder);
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(builder);
        }
    }

    private void readable(WebSocketFrame wsframe) throws IOException {
        ByteBuf payload = wsframe.content();
        payload.markReaderIndex();
        String seq = null;
        int packetState = 0;
        byte[] seqBuf = (byte[])Bytes.Pool._512.poll();
        try {
            int i = 0;
            while (i < seqBuf.length && payload.isReadable()) {
                seqBuf[i] = payload.readByte();
                if (i > 3 && 10 == seqBuf[i]) {
                    if (101 == seqBuf[0]) {
                        packetState = 16;
                    } else if (109 != seqBuf[0]) {
                        _Logger.error(Bytes.toString((StringBuilder)new StringBuilder("\u5e27\u683c\u5f0f\u5f02\u5e38\uff0c\u5206\u7247\u6807\u8bc6\u9519\u8bef\uff1a"), (byte[])seqBuf, (int)i).toString());
                        this.close();
                        return;
                    }
                    if (80 == seqBuf[1]) {
                        packetState |= 1;
                    } else if (82 == seqBuf[1]) {
                        packetState |= 2;
                    } else {
                        _Logger.error(Bytes.toString((StringBuilder)new StringBuilder("\u5e27\u683c\u5f0f\u5f02\u5e38\uff0c\u5e8f\u53f7\u6807\u8bc6\u9519\u8bef\uff1a"), (byte[])seqBuf, (int)i).toString());
                        this.close();
                        return;
                    }
                    seq = new String(seqBuf, 2, i - 2, "UTF-8");
                    break;
                }
                ++i;
            }
            if (seq == null) {
                _Logger.error(Bytes.toString((StringBuilder)new StringBuilder("\u5e27\u683c\u5f0f\u5f02\u5e38\uff0c\u5e8f\u53f7\u6ca1\u6709/\u4e0d\u5408\u683c"), (byte[])seqBuf, (int)i).toString());
                this.close();
                return;
            }
        }
        finally {
            Bytes.Pool._512.offer(seqBuf);
        }
        seqBuf = null;
        if (true & packetState) {
            WebSocketSession session = this.openSession(seq);
            session.readable(payload, packetState);
            return;
        }
        WebSocketSession session = this.getSession(seq);
        if (session == null) {
            _Logger.warn("miss request:" + seq + ",frame:" + wsframe);
            return;
        }
        session.readable(payload, packetState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebSocketSession openSession(String seq) throws IOException {
        Map empty = Collections.emptyMap();
        if (empty == this.m_Multiplex) {
            throw new EOFException("closed");
        }
        WebSocketContext webSocketContext = this;
        synchronized (webSocketContext) {
            WebSocketSession session = this.m_Multiplex.get(seq);
            if (session != null) {
                return session;
            }
            if (_MaxRequests < 1 || this.m_Multiplex.size() < _MaxRequests) {
                session = new WebSocketSession(this, seq);
                this.m_Multiplex.put(seq, session);
                ++this.m_RequestCounter;
                return session;
            }
        }
        String msg = "over max requests " + this.m_Multiplex.size() + ">" + _MaxRequests;
        _Logger.warn(this.formatMessage(msg));
        throw new BusyException(msg);
    }

    protected synchronized WebSocketSession removeSession(String seq) {
        WebSocketSession session = this.m_Multiplex.remove(seq);
        return session;
    }

    protected synchronized WebSocketSession getSession(String seq) {
        return this.m_Multiplex.get(seq);
    }

    protected synchronized void cleanup() {
        Map<String, WebSocketSession> multiplex;
        if (this.m_IdleTask != null) {
            this.m_IdleTask.cancel(false);
            this.m_IdleTask = null;
        }
        if (this.m_PingTask != null) {
            this.m_PingTask.cancel(false);
            this.m_PingTask = null;
        }
        if (_clean == (multiplex = this.m_Multiplex)) {
            return;
        }
        this.m_Multiplex = _clean;
        for (Map.Entry<String, WebSocketSession> e : multiplex.entrySet()) {
            WebSocketSession session = e.getValue();
            if (session == null) continue;
            session.abort();
        }
    }

    @Override
    public void close() {
        ChannelHandlerContext ctx = this.m_Ctx;
        if (ctx != null) {
            this.m_Ctx = null;
            ctx.close();
            this.cleanup();
        }
    }

    @Override
    public boolean isValid() {
        return _clean != this.m_Multiplex;
    }

    protected ByteBufAllocator getAllocator() {
        ByteBufAllocator allocator = this.m_Ctx != null ? this.m_Ctx.alloc() : ByteBufAllocator.DEFAULT;
        return allocator;
    }

    private String formatMessage(String caption) {
        StringBuilder builder = StringBuilderPool._128.poll();
        try {
            if (caption != null) {
                builder.append(caption);
            }
            this.toString(builder);
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(builder);
        }
    }

    @Override
    public ClientContext request(ClientHandler handler, String uri, String verb) throws IOException {
        if (uri != null && uri.length() > 0) {
            int idx = uri.indexOf("://");
            if (idx > 0) {
                uri = (idx = uri.indexOf(47, idx + 3)) > 0 ? uri.substring(idx) : null;
            } else if ('/' != uri.charAt(0)) {
                uri = String.valueOf('/') + uri;
            }
        }
        String seq = this.genSequence();
        WebSocketSession session = this.openSession(seq);
        ClientContext client = session.openRequest(handler, uri);
        if (!StringUtil.isEmpty((String)verb)) {
            client.setRequestHeader("Verb", verb);
        }
        return client;
    }

    public StringBuilder toString(StringBuilder builder) {
        builder.append("{ip:");
        if (this.m_RemoteAddr != null) {
            builder.append(this.m_RemoteAddr);
        }
        builder.append(",seq:").append(this.m_Sequencer.get());
        builder.append(",mul:").append(this.m_Multiplex.size());
        builder.append(",count:").append(this.m_RequestCounter);
        builder.append(",age:").append(_Tick.getTickerLong() - this.m_LastActivity);
        builder.append("}");
        return builder;
    }

    public String toString() {
        StringBuilder builder = StringBuilderPool._128.poll();
        try {
            String string = this.toString(builder).toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(builder);
        }
    }
}

