/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.netty.websocket;

import cn.weforward.common.io.StayException;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.protocol.aio.Headers;
import cn.weforward.protocol.aio.netty.ByteBufInput;
import cn.weforward.protocol.aio.netty.ByteBufStream;
import cn.weforward.protocol.aio.netty.CompositeByteBufStream;
import cn.weforward.protocol.aio.netty.NettyHttpHeaders;
import cn.weforward.protocol.aio.netty.NettyOutputStream;
import cn.weforward.protocol.aio.netty.websocket.WebSocketSession;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;

public abstract class WebSocketMessage {
    public static final int PACKET_REQUEST = 1;
    public static final int PACKET_RESPONSE = 2;
    public static final int PACKET_MARK_FINAL = 16;
    public static final int PACKET_MARK_HEADER = 32;
    public static final int PACKET_MARK_ABORT = Integer.MIN_VALUE;
    public static final int PACKET_PREAMBLE_MORE = 109;
    public static final int PACKET_PREAMBLE_END = 101;
    public static final int PACKET_PREAMBLE_REQUEST = 80;
    public static final int PACKET_PREAMBLE_RESPONSE = 82;
    public static final char PACKET_LF = '\n';
    public static final int PACKET_ID_LENGTH = 128;
    public static final String HEADER_URI = "URI";
    public static final String HEADER_WS_RPC_ID = "WS-RPC-ID";
    public static final String HEADER_STATUS = "Status";
    public static final String HEADER_VERB = "Verb";
    public static final String STATUS_NOT_IMPLEMENTED = "501 Not Implemented";
    static final byte[] HEADER_DELIMITER = new byte[]{58, 32};
    final WebSocketSession m_Session;
    final ByteBufAllocator m_Allocator;
    NettyHttpHeaders m_Headers;
    ByteBufStream m_Body;
    NettyOutputStream m_TransferTo;
    Output m_Output;
    static final int STATE_INIT = 1;
    static final int STATE_HEADER = 2;
    static final int STATE_PENDING = 6;
    static final int STATE_CLOSED = 16;
    static final int MAX_FRAME_PAYLOAD_LENGTH = 57343;

    public WebSocketMessage(WebSocketSession session, NettyHttpHeaders headers) {
        this.m_Headers = headers;
        this.m_Session = session;
        this.m_Allocator = session.getAllocator();
    }

    protected abstract int getPacketPreamble();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readable(ByteBuf payload) throws IOException {
        ByteBufStream body;
        WebSocketMessage webSocketMessage = this;
        synchronized (webSocketMessage) {
            block5: {
                if (!this.forward(payload)) break block5;
                return -1;
            }
            body = this.m_Body;
            if (body == null) {
                this.m_Body = body = new CompositeByteBufStream(this.m_Allocator.compositeBuffer());
            }
            body.readable(payload);
        }
        return body.available();
    }

    public synchronized void complete() throws IOException {
        ByteBufStream body = this.m_Body;
        if (body == null) {
            this.m_Body = ByteBufInput._completed;
        } else {
            body.completed();
        }
    }

    public synchronized InputStream getStream() throws IOException {
        ByteBufInput stream;
        if (this.m_Body instanceof ByteBufInput) {
            return (ByteBufInput)this.m_Body;
        }
        if (this.m_Body == null) {
            stream = new ByteBufInput((ByteBuf)this.m_Allocator.compositeBuffer(), false);
        } else {
            CompositeByteBufStream buffers = (CompositeByteBufStream)this.m_Body;
            stream = new ByteBufInput(buffers.detach(), buffers.isCompleted());
        }
        this.m_Body = stream;
        return stream;
    }

    public synchronized InputStream duplicateStream() throws IOException {
        ByteBufStream body = this.m_Body;
        if (!(body instanceof CompositeByteBufStream)) {
            throw new IOException("\u53ea\u80fd\u5728getStream\u524d\u4f7f\u7528");
        }
        return ((CompositeByteBufStream)body).snapshot();
    }

    synchronized void cleanup() {
        Output out = this.m_Output;
        if (out != null) {
            this.m_Output = null;
            out.cleanup();
        }
        if (this.m_Body != null) {
            this.m_Body.abort();
            this.m_Body = null;
        }
        if (this.m_TransferTo != null) {
            try {
                this.m_TransferTo.cancel();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_TransferTo = null;
        }
        this.m_Headers = null;
    }

    public boolean abort() {
        boolean ret = this.m_Headers != null;
        this.cleanup();
        return ret;
    }

    public boolean isInvalid() {
        return this.m_Headers == null;
    }

    public synchronized void setHeader(String name, String value) throws IOException {
        if (this.m_Headers == null) {
            throw new EOFException("closed");
        }
        this.m_Headers.setHeader(name, value);
    }

    public synchronized Output openWriter() throws IOException {
        if (this.m_Headers == null) {
            throw new EOFException("closed");
        }
        if (this.m_Output == null) {
            if (this.m_Body != null || this.m_TransferTo != null) {
                throw new IOException("\u8f93\u5165\u72b6\u6001");
            }
            this.m_Output = new Output();
        }
        return this.m_Output;
    }

    public void flush(ByteBuf body) throws IOException {
        Output out = this.openWriter();
        if (body != null) {
            out.write(body);
        }
        out.close();
    }

    public Headers getHeaders() throws IllegalStateException {
        if (this.m_Headers == null) {
            throw new IllegalStateException("closed");
        }
        return this.m_Headers;
    }

    public synchronized void transferTo(OutputStream writer, int skipBytes) throws IOException {
        if (!(this.m_Body instanceof CompositeByteBufStream)) {
            if (ByteBufInput._completed == this.m_Body) {
                return;
            }
            if (this.m_Body == null) {
                if (this.isInvalid()) {
                    throw new EOFException("invalid");
                }
                this.m_TransferTo = NettyOutputStream.wrap(writer);
                return;
            }
            throw new IOException("\u53ea\u80fd\u5728getStream\u524d\u8c03\u7528");
        }
        CompositeByteBufStream bufStream = (CompositeByteBufStream)this.m_Body;
        int readableBytes = bufStream.available();
        if (skipBytes > 0) {
            if (skipBytes > readableBytes) {
                throw new IOException("\u8d85\u8fc7\u8303\u56f4" + skipBytes + ">" + readableBytes);
            }
            bufStream.skipBytes(skipBytes);
        }
        this.m_TransferTo = NettyOutputStream.wrap(writer);
        ByteBuf buf = bufStream.detach();
        if (buf != null) {
            try {
                this.m_Body = null;
                this.forward(buf);
            }
            finally {
                buf.release();
            }
        }
        if (bufStream.isCompleted()) {
            this.m_Body = ByteBufInput._completed;
        }
    }

    public boolean isCompleted() {
        Output out = this.m_Output;
        if (out != null) {
            return !out.isOpen();
        }
        return this.m_Body == null ? false : this.m_Body.isCompleted();
    }

    boolean forward(ByteBuf data) {
        NettyOutputStream out = this.m_TransferTo;
        if (out == null) {
            return false;
        }
        try {
            out.write(data);
            return true;
        }
        catch (IOException e) {
            this.m_Session.errorTransferTo(this, e, data, out);
            return false;
        }
    }

    public void disconnect() {
        this.m_Session.disconnect();
    }

    public StringBuilder toString(StringBuilder builder) {
        builder.append("{state:");
        if (this.isCompleted()) {
            builder.append("completed");
        } else if (this.m_TransferTo != null) {
            builder.append("trans");
        } else if (this.m_Body != null) {
            builder.append("body,len:");
            try {
                builder.append(this.m_Body.available());
            }
            catch (IOException iOException) {}
        } else if (this.m_Output != null) {
            builder.append("output");
        } else if (this.m_Headers != null) {
            builder.append("headed");
        }
        builder.append("}");
        return builder;
    }

    public String toString() {
        StringBuilder builder = StringBuilderPool._8k.poll();
        try {
            String string = this.toString(builder).toString();
            return string;
        }
        finally {
            StringBuilderPool._8k.offer(builder);
        }
    }

    class Output
    extends NettyOutputStream.Stay {
        int m_State = 1;

        Output() {
        }

        private boolean isHeaderSended() {
            return 2 == this.m_State;
        }

        private ChannelFuture sendFrame(ByteBuf content, boolean isFinal) throws IOException {
            ByteBuf buf = null;
            CompositeByteBuf bufs = null;
            if (content != null && content.readableBytes() > 57343) {
                do {
                    int idx = content.readerIndex();
                    this.sendFrame(content.slice(idx, 57343), false);
                    content.readerIndex(idx + 57343);
                } while (content.readableBytes() > 57343);
            }
            try {
                if (!this.isHeaderSended()) {
                    buf = this.allocBuffer(8192);
                    this.putId(buf, isFinal);
                    this.putHeaders(buf);
                } else {
                    buf = this.allocBuffer(130);
                    this.putId(buf, isFinal);
                }
                if (content != null) {
                    bufs = WebSocketMessage.this.m_Allocator.compositeBuffer();
                    bufs.addComponent(true, buf);
                    bufs.addComponent(true, content.retain());
                    buf = bufs;
                    bufs = null;
                }
                BinaryWebSocketFrame frame = new BinaryWebSocketFrame(true, 0, buf);
                this.m_State = 2;
                ChannelFuture future = WebSocketMessage.this.m_Session.writeAndFlush(frame);
                buf = null;
                ChannelFuture channelFuture = future;
                return channelFuture;
            }
            finally {
                if (buf != null) {
                    buf.release();
                }
                if (bufs != null) {
                    bufs.release();
                }
            }
        }

        private void putHeaders(ByteBuf buf) {
            HttpHeaders hs = WebSocketMessage.this.m_Headers.getHeaders();
            Iterator it = hs.iteratorCharSequence();
            while (it.hasNext()) {
                Map.Entry h = (Map.Entry)it.next();
                CharSequence v = (CharSequence)h.getValue();
                if (v == null || v.length() <= 0) continue;
                buf.writeCharSequence((CharSequence)h.getKey(), CharsetUtil.UTF_8);
                buf.writeBytes(HEADER_DELIMITER);
                buf.writeCharSequence((CharSequence)h.getValue(), CharsetUtil.UTF_8);
                buf.writeByte(10);
            }
            buf.writeByte(10);
        }

        private void putId(ByteBuf buf, boolean isFinal) {
            buf.writeByte(isFinal ? 101 : 109);
            buf.writeByte(WebSocketMessage.this.getPacketPreamble());
            buf.writeCharSequence((CharSequence)WebSocketMessage.this.m_Session.getId(), CharsetUtil.UTF_8);
            buf.writeByte(10);
        }

        @Override
        protected synchronized void cleanup() {
            super.cleanup();
            this.m_State = 16;
        }

        public synchronized void stay() throws StayException {
            if (1 != this.m_State) {
                throw new StayException("\u5df2\u8f93\u51fa\u5934");
            }
            this.m_StayBuffers = WebSocketMessage.this.m_Allocator.compositeBuffer();
        }

        @Override
        public boolean isOpen() {
            return 16 != this.m_State;
        }

        @Override
        protected ByteBuf allocBuffer(int len) {
            return WebSocketMessage.this.m_Allocator.buffer(len);
        }

        @Override
        protected synchronized void flush(ByteBuf buf) throws IOException {
            this.sendFrame(buf, false);
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.isOpen()) {
                this.cleanup();
                throw new EOFException();
            }
            try {
                this.flush();
                ChannelFuture future = this.sendFrame(this.m_Last, true);
                this.m_State = 6;
                future.addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

                    public void operationComplete(Future<Void> future) throws Exception {
                        Output.this.m_State = 16;
                        if (future.isSuccess()) {
                            Output.this.success();
                        } else {
                            Output.this.fail();
                        }
                    }
                });
            }
            finally {
                this.cleanup();
            }
        }

        public synchronized void cancel() throws IOException {
            if (16 == this.m_State) {
                this.cleanup();
                return;
            }
            this.cleanup();
            WebSocketMessage.this.disconnect();
        }

        protected void success() throws IOException {
            WebSocketMessage.this.complete();
            WebSocketMessage.this.m_Session.outputCompleted(WebSocketMessage.this);
        }

        protected void fail() {
            WebSocketMessage.this.abort();
            WebSocketMessage.this.m_Session.outputAbort(WebSocketMessage.this);
        }
    }
}

