/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.netty.websocket;

import cn.weforward.common.DictionaryExt;
import cn.weforward.common.util.NumberUtil;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.aio.ClientChannel;
import cn.weforward.protocol.aio.ClientContext;
import cn.weforward.protocol.aio.ClientHandler;
import cn.weforward.protocol.aio.Headers;
import cn.weforward.protocol.aio.ServerBackwardChannel;
import cn.weforward.protocol.aio.ServerContext;
import cn.weforward.protocol.aio.ServerHandler;
import cn.weforward.protocol.aio.http.QueryStringParser;
import cn.weforward.protocol.aio.netty.HeadersParser;
import cn.weforward.protocol.aio.netty.NettyHttpHeaders;
import cn.weforward.protocol.aio.netty.NettyOutputStream;
import cn.weforward.protocol.aio.netty.websocket.WebSocketContext;
import cn.weforward.protocol.aio.netty.websocket.WebSocketMessage;
import cn.weforward.protocol.aio.netty.websocket.WebSocketRequest;
import cn.weforward.protocol.aio.netty.websocket.WebSocketResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketSession {
    protected static final Logger _Logger = LoggerFactory.getLogger(WebSocketSession.class);
    protected final String m_Id;
    protected final WebSocketContext m_Websocket;
    protected WebSocketRequest m_Request;
    protected WebSocketResponse m_Response;
    protected ServerHandler m_ServerHandler = ServerHandler._init;
    protected ClientHandler m_ClientHandler = ClientHandler._init;
    protected long m_RequestTimepoint;
    protected ServerSide m_ServerSide;
    protected ClientSide m_ClientSide;

    public WebSocketSession(WebSocketContext ctx, String id) {
        this.m_Websocket = ctx;
        this.m_Id = id;
    }

    public String getId() {
        return this.m_Id;
    }

    protected int readable(ByteBuf payload, int packetState) throws IOException {
        int type = packetState & 0xFFFFFFEF;
        int available = payload.readableBytes();
        if (1 == type) {
            if (this.m_Request == null) {
                this.m_Request = new WebSocketRequest(this, this.analyseHead(payload));
                packetState |= 0x20;
                ServerHandler handler = null;
                try {
                    this.m_ServerSide = new ServerSide();
                    handler = this.m_Websocket.m_HandlerFactory.handle(this.m_ServerSide);
                }
                finally {
                    if (handler == null) {
                        if (this.isRespond()) {
                            return Integer.MIN_VALUE;
                        }
                        this.responseAndClose("501 Not Implemented");
                        return Integer.MIN_VALUE;
                    }
                }
                this.m_ServerHandler = handler;
                handler.requestHeader();
            }
            this.m_Request.readable(payload);
            this.m_ServerHandler.prepared(available);
            if (16 == (0x10 & packetState)) {
                this.m_RequestTimepoint = System.currentTimeMillis();
                this.m_Request.complete();
                this.m_ServerHandler.requestCompleted();
            }
            return packetState;
        }
        if (2 == type) {
            if (this.m_Response == null) {
                this.m_Response = new WebSocketResponse(this, this.analyseHead(payload));
                packetState |= 0x20;
                this.m_ClientHandler.responseHeader();
            }
            this.m_Response.readable(payload);
            this.m_ClientHandler.prepared(available);
            if (16 == (0x10 & packetState)) {
                this.m_Response.complete();
                this.m_Websocket.removeSession(this.getId());
                if (this.m_ClientSide != null) {
                    this.m_ClientSide.cancelTask();
                }
                this.m_ClientHandler.responseCompleted();
            }
            return packetState;
        }
        throw new IOException("\u5305\u7c7b\u578b\u5f02\u5e38:" + packetState);
    }

    private NettyHttpHeaders analyseHead(ByteBuf payload) throws IOException {
        HttpHeaders headers;
        HeadersParser parser = (HeadersParser)HeadersParser._Pool.poll();
        try {
            headers = parser.parseRaw(payload);
            headers = parser.openHeaders(headers);
        }
        finally {
            HeadersParser._Pool.offer((Object)parser);
        }
        headers.add("WS-RPC-ID", (Object)this.getId());
        return new NettyHttpHeaders(headers);
    }

    public void abort() {
        WebSocketRequest req = this.m_Request;
        WebSocketResponse rsp = this.m_Response;
        boolean abort = false;
        boolean bl = abort = req != null && req.abort();
        if (rsp != null) {
            if (rsp.isCompleted()) {
                abort = false;
            }
            rsp.abort();
        }
        if (abort) {
            this.m_ClientHandler.requestAbort();
            this.m_ServerHandler.requestAbort();
        }
        if (this.m_ServerSide != null) {
            this.m_ServerSide.cancelTask();
        }
        if (this.m_ClientSide != null) {
            this.m_ClientSide.cancelTask();
        }
    }

    public ByteBufAllocator getAllocator() {
        return this.m_Websocket.getAllocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientContext openRequest(ClientHandler handler, String uri) throws IOException {
        WebSocketSession webSocketSession = this;
        synchronized (webSocketSession) {
            if (this.m_Request != null) {
                throw new IOException("\u8bf7\u6c42\u5df2\u6253\u5f00");
            }
            this.m_ClientHandler = handler;
            DefaultHttpHeaders headers = new DefaultHttpHeaders();
            if (!StringUtil.isEmpty((String)uri)) {
                headers.set("URI", (Object)uri);
            }
            this.m_Request = new WebSocketRequest(this, new NettyHttpHeaders((HttpHeaders)headers));
        }
        this.m_RequestTimepoint = System.currentTimeMillis();
        this.m_ClientSide = new ClientSide();
        handler.established(this.m_ClientSide);
        return this.m_ClientSide;
    }

    synchronized WebSocketResponse openResponse() throws IOException {
        if (this.m_Request == null || this.m_Request.isInvalid()) {
            throw new EOFException("invalid");
        }
        if (this.m_Response == null) {
            DefaultHttpHeaders headers = new DefaultHttpHeaders();
            this.m_Response = new WebSocketResponse(this, new NettyHttpHeaders((HttpHeaders)headers));
        } else if (this.m_Response.isCompleted()) {
            throw new EOFException("\u5df2\u54cd\u5e94");
        }
        return this.m_Response;
    }

    public boolean isRespond() {
        WebSocketResponse rsp = this.m_Response;
        return rsp != null && rsp.isCompleted();
    }

    public void responseAndClose(String status) throws IOException {
        WebSocketResponse rsp = this.openResponse();
        if (status != null) {
            rsp.setHeader("Status", status);
        }
        rsp.flush(null);
        this.m_Websocket.close();
    }

    protected void errorTransferTo(WebSocketMessage message, IOException e, ByteBuf data, NettyOutputStream out) {
        if (message == this.m_Request) {
            this.m_ClientHandler.errorResponseTransferTo(e, data, out);
            return;
        }
        if (message == this.m_Response) {
            this.m_ServerHandler.errorRequestTransferTo(e, data, out);
        }
    }

    void outputCompleted(WebSocketMessage message) {
        if (message == this.m_Request) {
            this.m_ClientHandler.requestCompleted();
            return;
        }
        if (message == this.m_Response) {
            this.m_Websocket.removeSession(this.getId());
            if (this.m_ServerSide != null) {
                this.m_ServerSide.cancelTask();
            }
            this.m_ServerHandler.responseCompleted();
            return;
        }
    }

    void outputAbort(WebSocketMessage message) {
        if (message == this.m_Request) {
            if (this.m_ClientSide != null) {
                this.m_ClientSide.cancelTask();
            }
            this.m_ClientHandler.requestAbort();
            return;
        }
        if (message == this.m_Response) {
            this.m_Websocket.removeSession(this.getId());
            if (this.m_ServerSide != null) {
                this.m_ServerSide.cancelTask();
            }
            if (!this.isRespond()) {
                this.m_ServerHandler.requestAbort();
            }
            return;
        }
    }

    public ChannelFuture writeAndFlush(Object content) throws IOException {
        ChannelHandlerContext ctx = this.m_Websocket.getChannelContext();
        if (ctx == null) {
            throw new EOFException("closed");
        }
        return ctx.writeAndFlush(content);
    }

    public void disconnect() {
        this.m_Websocket.close();
    }

    public String toString() {
        return this.toString(null);
    }

    protected String toString(String msg) {
        StringBuilder builder = StringBuilderPool._8k.poll();
        try {
            if (msg != null) {
                builder.append(msg);
            }
            builder.append("{id:").append(this.m_Id).append(",ctx:");
            this.m_Websocket.toString(builder);
            if (this.m_Request != null) {
                builder.append(",req:");
                this.m_Request.toString(builder);
            }
            if (this.m_Response != null) {
                builder.append(",rsp:");
                this.m_Response.toString(builder);
            }
            builder.append("}");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderPool._8k.offer(builder);
        }
    }

    class ClientSide
    extends ResponseChecker
    implements ClientContext,
    Runnable {
        ClientSide() {
        }

        @Override
        public void setRequestHeader(String name, String value) throws IOException {
            WebSocketSession.this.m_Request.setHeader(name, value);
        }

        @Override
        public OutputStream openRequestWriter() throws IOException {
            return WebSocketSession.this.m_Request.openWriter();
        }

        @Override
        public Headers getResponseHeaders() throws IOException {
            return WebSocketSession.this.m_Response.getHeaders();
        }

        @Override
        public InputStream getResponseStream() throws IOException {
            return WebSocketSession.this.m_Response.getStream();
        }

        @Override
        public InputStream duplicateResponseStream() throws IOException {
            return WebSocketSession.this.m_Response.duplicateStream();
        }

        @Override
        public void responseTransferTo(OutputStream writer, int skipBytes) throws IOException {
            WebSocketSession.this.m_Response.transferTo(writer, skipBytes);
        }

        @Override
        public boolean isResponseCompleted() {
            return WebSocketSession.this.isRespond();
        }

        @Override
        public void close() {
            if (!WebSocketSession.this.isRespond()) {
                _Logger.warn(WebSocketSession.this.toString("not respond"));
            }
        }

        @Override
        public void disconnect() {
            WebSocketSession.this.disconnect();
        }

        public String toString() {
            return WebSocketSession.this.toString();
        }

        @Override
        protected void onTimeout() {
            WebSocketSession.this.m_ClientHandler.responseTimeout();
        }

        @Override
        public int getResponseCode() throws IOException {
            return NumberUtil.toInt((String)((String)this.getResponseHeaders().get("Status")), (int)0);
        }
    }

    abstract class ResponseChecker
    implements Runnable {
        int m_Timeout;
        AtomicReference<ScheduledFuture<?>> m_Task;

        ResponseChecker() {
        }

        protected abstract void onTimeout();

        public void setTimeout(int millis) {
            this.cancelTask();
            ChannelHandlerContext ctx = WebSocketSession.this.m_Websocket.getChannelContext();
            if (ctx == null || millis < 1) {
                return;
            }
            this.m_Timeout = millis;
            this.checkTimeout();
        }

        protected void checkTimeout() {
            ChannelHandlerContext ctx;
            long remaind;
            AtomicReference<Object> task = this.m_Task;
            if (task == null) {
                task = new AtomicReference();
                this.m_Task = task;
            }
            try {
                int timeout = this.m_Timeout;
                if (timeout <= 0) {
                    return;
                }
                remaind = (long)timeout - (System.currentTimeMillis() - WebSocketSession.this.m_RequestTimepoint);
                if (remaind <= 0L) {
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug(WebSocketSession.this.toString("timeout"));
                    }
                    this.onTimeout();
                    return;
                }
            }
            finally {
                task.set(null);
            }
            if (remaind > 0L && (ctx = WebSocketSession.this.m_Websocket.getChannelContext()) != null) {
                task.set(ctx.executor().schedule((Runnable)this, remaind, TimeUnit.MILLISECONDS));
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug(WebSocketSession.this.toString("timeout after(ms):" + remaind));
                }
            }
        }

        @Override
        public void run() {
            this.checkTimeout();
        }

        public void cancelTask() {
            ScheduledFuture<?> f;
            AtomicReference<ScheduledFuture<?>> task = this.m_Task;
            if (task != null && (f = task.get()) != null) {
                f.cancel(false);
                task.compareAndSet(f, null);
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug(WebSocketSession.this.toString("cancel timeout task"));
                }
            }
        }
    }

    class ServerSide
    extends ResponseChecker
    implements ServerContext,
    ServerBackwardChannel,
    Runnable {
        String m_Uri;
        String m_QueryString;
        DictionaryExt<String, String> m_Params;

        ServerSide() {
        }

        @Override
        public String getUri() {
            String uri = this.m_Uri;
            if (uri == null) {
                int idx;
                uri = (String)WebSocketSession.this.m_Request.getHeaders().get("URI");
                if (uri == null) {
                    uri = "";
                }
                if ((idx = uri.indexOf(63)) >= 0) {
                    this.m_QueryString = uri.substring(idx + 1);
                    uri = uri.substring(0, idx);
                } else {
                    this.m_QueryString = "";
                }
                this.m_Uri = uri;
            }
            return uri;
        }

        @Override
        public String getRemoteAddr() {
            return WebSocketSession.this.m_Websocket.getRemoteAddr();
        }

        @Override
        public String getVerb() {
            String verb = (String)WebSocketSession.this.m_Request.getHeaders().get("Verb");
            if (verb == null) {
                verb = "POST";
            }
            return verb;
        }

        @Override
        public DictionaryExt<String, String> getParams() {
            if (this.m_Params != null) {
                return this.m_Params;
            }
            this.getUri();
            this.m_Params = QueryStringParser.toParams(this.m_QueryString);
            return this.m_Params;
        }

        @Override
        public Headers getRequestHeaders() {
            return WebSocketSession.this.m_Request.getHeaders();
        }

        @Override
        public void requestTransferTo(OutputStream writer, int skipBytes) throws IOException {
            WebSocketSession.this.m_Request.transferTo(writer, skipBytes);
        }

        @Override
        public InputStream getRequestStream() throws IOException {
            return WebSocketSession.this.m_Request.getStream();
        }

        @Override
        public boolean isRequestCompleted() {
            return WebSocketSession.this.m_Request != null && WebSocketSession.this.m_Request.isCompleted();
        }

        @Override
        public void setResponseTimeout(int millis) {
            this.setTimeout(millis);
        }

        @Override
        public void setResponseHeader(String name, String value) throws IOException {
            WebSocketSession.this.openResponse().setHeader(name, value);
        }

        @Override
        public OutputStream openResponseWriter(int statusCode, String reasonPhrase) throws IOException {
            WebSocketResponse rsp = WebSocketSession.this.openResponse();
            if (statusCode > 0) {
                String status;
                StringBuilder builder = StringBuilderPool._128.poll();
                try {
                    builder.append(statusCode);
                    if (!StringUtil.isEmpty((String)reasonPhrase)) {
                        builder.append(' ').append(reasonPhrase);
                    }
                    status = builder.toString();
                }
                finally {
                    StringBuilderPool._128.offer(builder);
                }
                rsp.setHeader("Status", status);
            }
            return rsp.openWriter();
        }

        @Override
        public void response(int statusCode, byte[] content) throws IOException {
            if (ServerContext.RESPONSE_AND_CLOSE == content) {
                WebSocketSession.this.responseAndClose(String.valueOf(statusCode));
                return;
            }
            WebSocketResponse rsp = WebSocketSession.this.openResponse();
            rsp.setHeader("Status", String.valueOf(statusCode));
            WebSocketMessage.Output out = rsp.openWriter();
            if (content != null) {
                out.write(content);
            }
            out.close();
        }

        @Override
        public boolean isRespond() {
            return WebSocketSession.this.isRespond();
        }

        @Override
        public void disconnect() {
            WebSocketSession.this.disconnect();
        }

        public String toString() {
            return WebSocketSession.this.toString();
        }

        @Override
        protected void onTimeout() {
            WebSocketSession.this.m_ServerHandler.responseTimeout();
        }

        @Override
        public ClientChannel getClientChannel() {
            return WebSocketSession.this.m_Websocket;
        }
    }
}

