/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.auth;

import cn.weforward.common.io.BytesOutputStream;
import cn.weforward.common.util.Bytes;
import cn.weforward.protocol.Access;
import cn.weforward.protocol.AccessLoader;
import cn.weforward.protocol.auth.AuthEngine;
import cn.weforward.protocol.auth.AuthInput;
import cn.weforward.protocol.auth.AuthOutput;
import cn.weforward.protocol.auth.NoneAuthEngine;
import cn.weforward.protocol.auth.Sha2AuthEngine;
import cn.weforward.protocol.auth.SignAuthEngine;
import cn.weforward.protocol.exception.AuthException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auther {
    static final Logger _Logger = LoggerFactory.getLogger(Auther.class);
    AccessLoader m_Loader;
    Map<String, AuthEngine> m_Engines;

    public Auther(AccessLoader loader) {
        this.m_Loader = loader;
        this.m_Engines = new ConcurrentHashMap<String, AuthEngine>();
    }

    public void setEngines(List<AuthEngine> engines) {
        this.m_Engines.clear();
        if (engines == null || engines.isEmpty()) {
            return;
        }
        for (AuthEngine e : engines) {
            this.putEngine(e);
        }
    }

    public AuthEngine putEngine(AuthEngine engine) {
        return this.m_Engines.put(engine.getType().toLowerCase(), engine);
    }

    public AuthEngine getEngine(String type) {
        if (type == null || type.length() == 0) {
            return null;
        }
        AuthEngine e = this.m_Engines.get(type.toLowerCase());
        if (e == null) {
            if ("WF-None".equals(type) || type.endsWith("-None")) {
                e = new NoneAuthEngine();
            } else if ("WF-SHA2".equals(type) || type.endsWith("-SHA2")) {
                e = new Sha2AuthEngine();
            } else if ("WF-Sign".equals(type) || type.endsWith("-Sign")) {
                e = new SignAuthEngine();
            }
            if (e != null) {
                this.putEngine(e);
            }
        }
        return e;
    }

    public void decode(AuthInput input, AuthOutput output) throws AuthException, IOException {
        this.execute(input, output, false);
    }

    private void execute(AuthInput input, AuthOutput output, boolean encode) throws AuthException, IOException {
        String authType = input.getType();
        AuthEngine engine = this.getEngine(authType);
        if (engine == null) {
            throw new AuthException(1003, "\u65e0\u6548\u7684auth_type:" + authType);
        }
        BytesOutputStream bos = new BytesOutputStream(input.input);
        Bytes bytes = bos.getBytes();
        bos.close();
        bos = null;
        AuthEngine.Input in = new AuthEngine.Input();
        Access acc = this.getAccess(input);
        if (acc != null) {
            in.accessId = acc.getAccessId();
            in.accessKey = acc.getAccessKey();
        }
        in.serviceName = input.getServiceName();
        in.noise = input.getNoise();
        in.sign = input.getSign();
        in.contentSign = input.getContentSign();
        in.channel = input.getChannel();
        in.tag = input.getTag();
        in.data = bytes.getBytes();
        in.dataOffset = bytes.getOffset();
        in.dataLength = bytes.getSize();
        bytes = null;
        AuthEngine.Output out = encode ? engine.encode(in) : engine.decode(in);
        output.setAccess(acc);
        output.setType(authType);
        output.setNoise(out.noise);
        output.setSign(out.sign);
        output.setContentSign(out.contentSign);
        output.output.write(out.data, out.dataOffset, out.dataLength);
    }

    Access getAccess(AuthInput input) throws AuthException {
        if ("WF-None".equals(input.getType()) || input.getType().endsWith("-None")) {
            return null;
        }
        Access acc = null;
        if (input.getAccessId() != null) {
            acc = this.m_Loader.getValidAccess(input.getAccessId());
        }
        if (acc == null) {
            throw new AuthException(1001, "\u65e0\u6548\u7684access_id:" + input.getAccessId());
        }
        return acc;
    }

    public void encode(AuthInput input, AuthOutput output) throws AuthException, IOException {
        this.execute(input, output, true);
    }
}

