/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.auth;

import cn.weforward.common.util.Bytes;
import cn.weforward.protocol.auth.AutherOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;

public class AutherInputStream
extends InputStream {
    InputStream m_InputStream;
    AutherOutputStream m_AutherOutputStream;
    byte[] m_RemainBuf;
    int m_RemainBufReadPos;
    int m_RemainBufWritePos;
    int m_RemainBufReadable;
    byte[] m_InputBuf;
    int m_InputBufStart;
    int m_InputBufEnd;
    OutputStream m_Forward = new OutputStream(){

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int fill = 0;
            if (AutherInputStream.this.m_InputBuf != null && AutherInputStream.this.m_InputBufStart < AutherInputStream.this.m_InputBufEnd) {
                fill = AutherInputStream.this.m_InputBufEnd - AutherInputStream.this.m_InputBufStart;
                if (fill > len) {
                    fill = len;
                }
                System.arraycopy(b, off, AutherInputStream.this.m_InputBuf, AutherInputStream.this.m_InputBufStart, fill);
                AutherInputStream.this.m_InputBufStart += fill;
            }
            if (fill >= len) {
                return;
            }
            AutherInputStream.this.putRemainBuf(b, off + fill, len - fill);
        }

        @Override
        public void write(int b) throws IOException {
            if (AutherInputStream.this.m_InputBuf != null && AutherInputStream.this.m_InputBufStart < AutherInputStream.this.m_InputBufEnd) {
                AutherInputStream.this.m_InputBuf[AutherInputStream.this.m_InputBufStart++] = (byte)b;
                return;
            }
            AutherInputStream.this.putRemainBuf((byte)b);
        }
    };

    public AutherInputStream(InputStream input, AutherOutputStream output) throws IOException {
        this.m_InputStream = input;
        this.m_AutherOutputStream = output;
        this.m_AutherOutputStream.setTransferTo(null, this.m_Forward);
        this.m_RemainBuf = new byte[10240];
        this.m_RemainBufReadPos = 0;
        this.m_RemainBufWritePos = 0;
        this.m_RemainBufReadable = 0;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.readRemainBuf(b, off, len);
        if (-1 != ret || this.m_AutherOutputStream == null) {
            return ret;
        }
        byte[] buf = (byte[])Bytes.Pool._8k.poll();
        this.m_InputBuf = b;
        this.m_InputBufStart = off;
        this.m_InputBufEnd = off + len;
        try {
            ret = this.m_InputStream.read(buf, 0, buf.length);
            if (-1 == ret) {
                this.m_AutherOutputStream.finish();
                this.m_AutherOutputStream = null;
            } else {
                this.m_AutherOutputStream.write(buf, 0, ret);
            }
            int n = this.m_InputBufStart - off;
            return n;
        }
        finally {
            this.m_InputBuf = null;
            this.m_InputBufStart = 0;
            this.m_InputBufEnd = 0;
            Bytes.Pool._8k.offer(buf);
        }
    }

    @Override
    public int read() throws IOException {
        int ret = this.getRemainBuf();
        if (-1 != ret || this.m_AutherOutputStream == null) {
            return ret;
        }
        byte[] buf = (byte[])Bytes.Pool._1k.poll();
        try {
            ret = this.m_InputStream.read(buf, 0, buf.length);
            if (-1 == ret) {
                this.m_AutherOutputStream.finish();
                this.m_AutherOutputStream = null;
            } else {
                this.m_AutherOutputStream.write(buf, 0, ret);
            }
            int n = this.getRemainBuf();
            return n;
        }
        finally {
            Bytes.Pool._1k.offer(buf);
        }
    }

    private int getRemainBuf() {
        if (this.m_RemainBufReadable == 0) {
            return -1;
        }
        int b = this.m_RemainBuf[this.m_RemainBufReadPos++];
        --this.m_RemainBufReadable;
        if (this.m_RemainBufReadPos >= this.m_RemainBuf.length) {
            this.m_RemainBufReadPos = 0;
        }
        return b < 0 ? 256 + b : b;
    }

    private void putRemainBuf(byte b) {
        if (this.m_RemainBufReadable >= this.m_RemainBuf.length) {
            throw new BufferOverflowException();
        }
        this.m_RemainBuf[this.m_RemainBufWritePos++] = b;
        ++this.m_RemainBufReadable;
        if (this.m_RemainBufWritePos >= this.m_RemainBuf.length) {
            this.m_RemainBufWritePos = 0;
        }
    }

    private int readRemainBuf(byte[] b, int off, int len) {
        if (this.m_RemainBufReadable == 0) {
            return -1;
        }
        int count = Math.min(this.m_RemainBufReadable, len);
        if (this.m_RemainBufReadable > this.m_RemainBuf.length - this.m_RemainBufReadPos) {
            int readable = this.m_RemainBuf.length - this.m_RemainBufReadPos;
            if (readable >= len) {
                System.arraycopy(this.m_RemainBuf, this.m_RemainBufReadPos, b, off, len);
                this.m_RemainBufReadable -= len;
                this.m_RemainBufReadPos += len;
            } else {
                System.arraycopy(this.m_RemainBuf, this.m_RemainBufReadPos, b, off, readable);
                this.m_RemainBufReadable -= readable;
                off += readable;
                readable = this.m_RemainBufReadable > (len -= readable) ? len : this.m_RemainBufReadable;
                System.arraycopy(this.m_RemainBuf, 0, b, off, readable);
                this.m_RemainBufReadable -= readable;
                this.m_RemainBufReadPos = readable;
            }
        } else {
            int readable = this.m_RemainBufReadable > len ? len : this.m_RemainBufReadable;
            System.arraycopy(this.m_RemainBuf, 0, b, off, readable);
            this.m_RemainBufReadable -= readable;
            this.m_RemainBufReadPos = readable;
        }
        if (this.m_RemainBufReadPos >= this.m_RemainBuf.length) {
            this.m_RemainBufReadPos = 0;
        }
        return count;
    }

    private void putRemainBuf(byte[] b, int off, int len) {
        if (this.m_RemainBuf.length - this.m_RemainBufReadable < len) {
            throw new BufferOverflowException();
        }
        if (len > this.m_RemainBuf.length - this.m_RemainBufWritePos) {
            int remain = this.m_RemainBuf.length - this.m_RemainBufWritePos;
            System.arraycopy(b, off, this.m_RemainBuf, this.m_RemainBufWritePos, remain);
            System.arraycopy(b, off + remain, this.m_RemainBuf, 0, len - remain);
            this.m_RemainBufWritePos = len - remain;
        } else {
            System.arraycopy(b, off, this.m_RemainBuf, this.m_RemainBufWritePos, len);
            this.m_RemainBufWritePos += len;
        }
        if (this.m_RemainBufWritePos >= this.m_RemainBuf.length) {
            this.m_RemainBufWritePos = 0;
        }
        this.m_RemainBufReadable += len;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.m_RemainBuf = null;
        if (this.m_AutherOutputStream != null) {
            this.m_AutherOutputStream.close();
        }
        this.m_InputStream.close();
    }
}

