/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.auth;

import cn.weforward.common.io.BytesOutputStream;
import cn.weforward.common.io.OutputStreamNio;
import cn.weforward.protocol.AccessLoader;
import cn.weforward.protocol.Header;
import cn.weforward.protocol.auth.AuthExceptionWrap;
import cn.weforward.protocol.auth.NoneOutputStream;
import cn.weforward.protocol.auth.Sha2OutputStream;
import cn.weforward.protocol.auth.SignOutputStream;
import cn.weforward.protocol.exception.AuthException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class AutherOutputStream
extends OutputStream
implements OutputStreamNio {
    public static final int MODE_ENCODE = 1;
    public static final int MODE_DECODE = 2;
    protected int m_Mode;
    protected AccessLoader m_AccessLoader;
    protected boolean m_IgnoreContent;
    protected volatile boolean m_Cancel;
    protected Header m_Header;
    protected Header.HeaderOutput m_HeaderOutput;
    protected OutputStream m_Forward;

    public static final AutherOutputStream getInstance(String authType) {
        if ("WF-None".equals(authType)) {
            return new NoneOutputStream();
        }
        if ("WF-SHA2".equals(authType)) {
            return new Sha2OutputStream();
        }
        if ("WF-Sign".equals(authType)) {
            return new SignOutputStream();
        }
        return null;
    }

    public void init(int mode, AccessLoader loader) {
        this.init(mode, loader, false);
    }

    public void init(int mode, AccessLoader loader, boolean ignoreContent) {
        if (mode != 2 && mode != 1) {
            throw new IllegalArgumentException("\u65e0\u6548\u6a21\u5f0f\uff1a" + mode);
        }
        this.m_Mode = mode;
        this.m_AccessLoader = loader;
        this.m_IgnoreContent = ignoreContent;
        this.onInit();
    }

    protected void onInit() {
    }

    protected boolean isIgnoreContent() {
        return this.m_IgnoreContent;
    }

    public boolean isMode(int mode) {
        return mode == this.m_Mode;
    }

    public void auth(Header header) throws AuthException {
        if (this.m_Mode == 0) {
            throw new IllegalStateException("\u8bf7\u5148\u521d\u59cb\u5316");
        }
        if (1 == this.m_Mode) {
            header.setSign(null);
            header.setContentSign(null);
        }
        this.m_Header = this.authHeader(header);
    }

    protected Header getHeader() {
        return this.m_Header;
    }

    protected abstract Header authHeader(Header var1) throws AuthException;

    public void setTransferTo(Header.HeaderOutput headerOutput, OutputStream forward) throws IOException {
        if (this.isMode(1)) {
            this.m_HeaderOutput = headerOutput;
        }
        this.m_Forward = forward;
    }

    public void finish() throws IOException {
        if (this.m_Cancel) {
            throw new IOException("\u5df2\u7ecf\u53d6\u6d88/\u5173\u95ed\u4e86");
        }
        if (this.isIgnoreContent()) {
            return;
        }
        try {
            this.doFinal();
        }
        catch (AuthException e) {
            throw new AuthExceptionWrap(e);
        }
    }

    protected abstract void doFinal() throws AuthException, IOException;

    public int write(ByteBuffer src) throws IOException {
        if (this.isIgnoreContent()) {
            return this.forward(src);
        }
        try {
            return this.update(src);
        }
        catch (AuthException e) {
            throw new AuthExceptionWrap(e);
        }
    }

    protected abstract int update(ByteBuffer var1) throws IOException, AuthException;

    protected int forward(ByteBuffer src) throws IOException {
        this.writeHeader();
        if (this.m_Forward != null) {
            if (this.m_Forward instanceof OutputStreamNio) {
                return ((OutputStreamNio)this.m_Forward).write(src);
            }
            BytesOutputStream.transfer((ByteBuffer)src, (OutputStream)this.m_Forward, (int)-1);
        }
        return 0;
    }

    protected void writeHeader() throws IOException {
        Header header;
        if (this.m_HeaderOutput != null && (header = this.getHeader()) != null) {
            this.m_HeaderOutput.writeHeader(header);
            this.m_HeaderOutput = null;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.isIgnoreContent()) {
            this.forward(b);
            return;
        }
        try {
            this.update(b);
        }
        catch (AuthException e) {
            throw new AuthExceptionWrap(e);
        }
    }

    protected abstract void update(int var1) throws IOException, AuthException;

    protected void forward(int b) throws IOException {
        this.writeHeader();
        if (this.m_Forward != null) {
            this.m_Forward.write(b);
        }
    }

    @Override
    public void write(byte[] data, int off, int len) throws IOException {
        if (this.isIgnoreContent()) {
            this.forward(data, off, len);
            return;
        }
        try {
            this.update(data, off, len);
        }
        catch (AuthException e) {
            throw new AuthExceptionWrap(e);
        }
    }

    public int write(InputStream src) throws IOException {
        return this.write(src, -1);
    }

    public int write(InputStream src, int count) throws IOException {
        if (this.isIgnoreContent()) {
            return this.forward(src, count);
        }
        try {
            return this.update(src, count);
        }
        catch (AuthException e) {
            throw new AuthExceptionWrap(e);
        }
    }

    protected abstract int update(InputStream var1, int var2) throws IOException, AuthException;

    protected int forward(InputStream src, int count) throws IOException {
        this.writeHeader();
        if (this.m_Forward == null) {
            return 0;
        }
        if (this.m_Forward instanceof OutputStreamNio) {
            return ((OutputStreamNio)this.m_Forward).write(src);
        }
        return BytesOutputStream.transfer((InputStream)src, (OutputStream)this.m_Forward, (int)count);
    }

    protected abstract void update(byte[] var1, int var2, int var3) throws AuthException, IOException;

    protected void forward(byte[] data, int off, int len) throws IOException {
        this.writeHeader();
        if (this.m_Forward != null) {
            this.m_Forward.write(data, off, len);
        }
    }

    public void cancel() throws IOException {
        this.m_Cancel = true;
        if (this.m_Forward != null && this.m_Forward instanceof OutputStreamNio) {
            ((OutputStreamNio)this.m_Forward).cancel();
        }
    }

    @Override
    public void close() throws IOException {
        this.m_Cancel = true;
        if (this.m_Forward != null) {
            this.m_Forward.close();
        }
    }
}

