/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.auth;

import cn.weforward.common.crypto.Base64;
import cn.weforward.common.crypto.Hex;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.auth.AuthEngine;
import cn.weforward.protocol.exception.AuthException;
import java.security.MessageDigest;
import java.util.Random;

public class Sha2AuthEngine
implements AuthEngine {
    protected Random m_Random = new Random();

    @Override
    public String getType() {
        return "WF-SHA2";
    }

    @Override
    public AuthEngine.Output encode(AuthEngine.Input in) throws AuthException {
        String sign;
        String dataSign;
        if (StringUtil.isEmpty((String)in.accessId)) {
            throw new AuthException(1002, "access id\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (in.accessKey == null || in.accessKey.length == 0) {
            throw new AuthException(1002, "access key\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String noise = in.noise;
        if (StringUtil.isEmpty((String)noise)) {
            long n = System.currentTimeMillis() << 20;
            int i = this.m_Random.nextInt();
            noise = Hex.toHex64((long)(n |= (long)(i & 0xFFFFF)));
        }
        try {
            MessageDigest md;
            StringBuilder sb = StringBuilderPool._8k.poll();
            try {
                sb.append(in.serviceName);
                sb.append(in.accessId);
                sb.append(Base64.encode((byte[])in.accessKey));
                sb.append(noise);
                if (!StringUtil.isEmpty((String)in.tag)) {
                    sb.append(in.tag);
                }
                if (!StringUtil.isEmpty((String)in.channel)) {
                    sb.append(in.channel);
                }
                md = MessageDigest.getInstance("SHA-256");
                if (in.dataLength > 0) {
                    md.update(in.data, in.dataOffset, in.dataLength);
                }
                dataSign = Base64.encode((byte[])md.digest());
                sb.append(dataSign);
                md.reset();
                md.update(sb.toString().getBytes("utf-8"));
            }
            finally {
                StringBuilderPool._8k.offer(sb);
            }
            sign = Base64.encode((byte[])md.digest());
        }
        catch (Exception e) {
            throw new AuthException(1002, (Throwable)e);
        }
        AuthEngine.Output out = new AuthEngine.Output();
        out.contentSign = dataSign;
        out.sign = sign;
        out.noise = noise;
        out.data = in.data;
        out.dataOffset = in.dataOffset;
        out.dataLength = in.dataLength;
        return out;
    }

    @Override
    public AuthEngine.Output decode(AuthEngine.Input in) throws AuthException {
        String sign;
        if (StringUtil.isEmpty((String)in.accessId)) {
            throw new AuthException(1002, "access id\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (in.accessKey == null || in.accessKey.length == 0) {
            throw new AuthException(1002, "access key\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)in.noise)) {
            throw new AuthException(1002, "Noise\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)in.sign)) {
            throw new AuthException(1002, "Sign\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (in.sign.length() <= 32 || in.sign.length() > 64) {
            throw new AuthException(1002, "Sign\u503c\u5f02\u5e38:" + StringUtil.limit((String)in.sign, (int)100));
        }
        try {
            MessageDigest md;
            StringBuilder sb = StringBuilderPool._8k.poll();
            try {
                sb.append(in.serviceName);
                sb.append(in.accessId);
                Base64.encode((Appendable)sb, (byte[])in.accessKey, (int)0, (int)in.accessKey.length);
                sb.append(in.noise);
                if (!StringUtil.isEmpty((String)in.tag)) {
                    sb.append(in.tag);
                }
                if (!StringUtil.isEmpty((String)in.channel)) {
                    sb.append(in.channel);
                }
                if (!StringUtil.isEmpty((String)in.contentSign)) {
                    sb.append(in.contentSign);
                }
                md = MessageDigest.getInstance("SHA-256");
                md.update(sb.toString().getBytes("utf-8"));
            }
            finally {
                StringBuilderPool._8k.offer(sb);
            }
            sign = Base64.encode((byte[])md.digest());
        }
        catch (Exception e) {
            throw new AuthException(1002, (Throwable)e);
        }
        if (!sign.equals(in.sign)) {
            throw new AuthException(1002, "\u7b7e\u540d\u4e0d\u4e00\u81f4\uff1a" + sign + " != " + in.sign);
        }
        String contentSign = null;
        if (!StringUtil.isEmpty((String)in.contentSign)) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                md.update(in.data, in.dataOffset, in.dataLength);
                contentSign = Base64.encode((byte[])md.digest());
            }
            catch (Exception e) {
                throw new AuthException(1002, (Throwable)e);
            }
            if (!contentSign.equals(in.contentSign)) {
                throw new AuthException(1002, "\u5185\u5bb9\u7b7e\u540d\u4e0d\u4e00\u81f4\uff1a" + contentSign + " != " + in.contentSign);
            }
        }
        AuthEngine.Output out = new AuthEngine.Output();
        out.sign = sign;
        out.contentSign = contentSign;
        out.noise = in.noise;
        out.data = in.data;
        out.dataOffset = in.dataOffset;
        out.dataLength = in.dataLength;
        return out;
    }
}

