/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.auth;

import cn.weforward.common.crypto.Base64;
import cn.weforward.common.crypto.Hex;
import cn.weforward.common.io.BytesOutputStream;
import cn.weforward.common.io.OutputStreamStay;
import cn.weforward.common.util.SimpleUtf8Encoder;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.Access;
import cn.weforward.protocol.Header;
import cn.weforward.protocol.auth.AutherOutputStream;
import cn.weforward.protocol.exception.AuthException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class Sha2OutputStream
extends AutherOutputStream {
    protected static final Random RANDOM = new Random();
    protected String m_ContentSign;
    protected MessageDigest m_ContentDigest;

    @Override
    protected Header authHeader(Header header) throws AuthException {
        if (2 == this.m_Mode) {
            this.decodeHeader(header);
        } else {
            this.encodeHeader(header);
        }
        return header;
    }

    void decodeHeader(Header header) throws AuthException {
        String sign2;
        String contentSign = header.getContentSign();
        if (StringUtil.isEmpty((String)contentSign) && !this.m_IgnoreContent) {
            throw new AuthException(1002, "\u7f3a\u5c11'content sign'");
        }
        String service = header.getService();
        if (StringUtil.isEmpty((String)service)) {
            throw new AuthException(1002, "\u7f3a\u5c11'service'");
        }
        String accessId = header.getAccessId();
        if (StringUtil.isEmpty((String)accessId)) {
            throw new AuthException(1002, "\u7f3a\u5c11'access id'");
        }
        String noise = header.getNoise();
        if (StringUtil.isEmpty((String)noise)) {
            throw new AuthException(1002, "\u7f3a\u5c11'noise'");
        }
        String sign = header.getSign();
        if (StringUtil.isEmpty((String)sign)) {
            throw new AuthException(1002, "\u7f3a\u5c11'sign'");
        }
        if (sign.length() <= 32 || sign.length() > 64) {
            throw new AuthException(1002, "'sign'\u503c\u5f02\u5e38:" + StringUtil.limit((String)sign, (int)100));
        }
        Access access = this.m_AccessLoader.getValidAccess(accessId);
        if (access == null) {
            throw new AuthException(1002, "'access id'\u65e0\u6548:" + accessId);
        }
        try {
            final MessageDigest md = MessageDigest.getInstance("SHA-256");
            SimpleUtf8Encoder utf8Encoder = new SimpleUtf8Encoder(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    md.update((byte)b);
                }
            });
            utf8Encoder.encode((CharSequence)service);
            utf8Encoder.encode((CharSequence)accessId);
            utf8Encoder.encode((CharSequence)access.getAccessKeyBase64());
            utf8Encoder.encode((CharSequence)noise);
            if (!StringUtil.isEmpty((String)header.getTag())) {
                utf8Encoder.encode((CharSequence)header.getTag());
            }
            if (!StringUtil.isEmpty((String)header.getChannel())) {
                utf8Encoder.encode((CharSequence)header.getChannel());
            }
            if (!StringUtil.isEmpty((String)contentSign)) {
                utf8Encoder.encode((CharSequence)contentSign);
            }
            sign2 = Base64.encode((byte[])md.digest());
        }
        catch (Exception e) {
            throw new AuthException(1002, (Throwable)e);
        }
        if (!sign2.equals(sign)) {
            throw new AuthException(1002, "\u7b7e\u540d\u4e0d\u4e00\u81f4\uff1a" + sign2 + " != " + sign);
        }
        if (!this.isIgnoreContent()) {
            this.m_ContentSign = contentSign;
            this.m_ContentDigest = this.openMessageDigest();
        }
    }

    MessageDigest openMessageDigest() throws AuthException {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthException(1002, (Throwable)e);
        }
    }

    void encodeHeader(Header header) throws AuthException {
        String service = header.getService();
        if (StringUtil.isEmpty((String)service)) {
            throw new AuthException(1002, "\u7f3a\u5c11'service'");
        }
        String accessId = header.getAccessId();
        if (StringUtil.isEmpty((String)accessId)) {
            throw new AuthException(1002, "\u7f3a\u5c11'access id'");
        }
        String noise = header.getNoise();
        if (StringUtil.isEmpty((String)noise)) {
            long n = System.currentTimeMillis() << 20;
            int i = RANDOM.nextInt();
            noise = Hex.toHex64((long)(n |= (long)(i & 0xFFFFF)));
            header.setNoise(noise);
        }
        if (this.isIgnoreContent()) {
            String sign = this.genSign(header);
            header.setSign(sign);
        } else {
            this.m_ContentDigest = this.openMessageDigest();
        }
    }

    protected String genSign(Header header) throws AuthException {
        Access access = this.m_AccessLoader.getValidAccess(header.getAccessId());
        if (access == null) {
            throw new AuthException(1002, "'access id'\u65e0\u6548");
        }
        try {
            final MessageDigest md = MessageDigest.getInstance("SHA-256");
            SimpleUtf8Encoder utf8Encoder = new SimpleUtf8Encoder(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    md.update((byte)b);
                }
            });
            utf8Encoder.encode((CharSequence)header.getService());
            utf8Encoder.encode((CharSequence)access.getAccessId());
            utf8Encoder.encode((CharSequence)Base64.encode((byte[])access.getAccessKey()));
            utf8Encoder.encode((CharSequence)header.getNoise());
            if (!StringUtil.isEmpty((String)header.getTag())) {
                utf8Encoder.encode((CharSequence)header.getTag());
            }
            if (!StringUtil.isEmpty((String)header.getChannel())) {
                utf8Encoder.encode((CharSequence)header.getChannel());
            }
            if (!StringUtil.isEmpty((String)header.getContentSign())) {
                utf8Encoder.encode((CharSequence)header.getContentSign());
            }
            return Base64.encode((byte[])md.digest());
        }
        catch (Exception e) {
            throw new AuthException(1002, (Throwable)e);
        }
    }

    @Override
    public void setTransferTo(Header.HeaderOutput headerOutput, OutputStream forward) throws IOException {
        if (this.isMode(1)) {
            OutputStream stay = OutputStreamStay.Wrap.wrap((OutputStream)forward);
            ((OutputStreamStay)stay).stay();
            forward = stay;
        }
        super.setTransferTo(headerOutput, forward);
    }

    @Override
    protected void doFinal() throws AuthException, IOException {
        if (this.isMode(2)) {
            String contentSign = Base64.encode((byte[])this.m_ContentDigest.digest());
            if (!contentSign.equals(this.m_ContentSign)) {
                throw new AuthException(1002, "\u5185\u5bb9\u7b7e\u540d\u4e0d\u4e00\u81f4\uff1a" + contentSign + " != " + this.m_ContentSign);
            }
        } else {
            String contentSign = Base64.encode((byte[])this.m_ContentDigest.digest());
            this.m_Header.setContentSign(contentSign);
            String sign = this.genSign(this.m_Header);
            this.m_Header.setSign(sign);
            this.writeHeader();
            if (this.m_Forward != null) {
                this.m_Forward.flush();
            }
        }
    }

    @Override
    protected void writeHeader() throws IOException {
        if (this.isMode(1) && StringUtil.isEmpty((String)this.m_Header.getSign())) {
            return;
        }
        super.writeHeader();
    }

    @Override
    protected int update(ByteBuffer src) throws IOException, AuthException {
        if (this.m_ContentDigest != null) {
            int mark = src.position();
            this.m_ContentDigest.update(src);
            src.position(mark);
        }
        return this.forward(src);
    }

    @Override
    protected void update(int b) throws AuthException, IOException {
        if (this.m_ContentDigest != null) {
            this.m_ContentDigest.update((byte)b);
        }
        this.forward(b);
    }

    @Override
    protected void update(byte[] data, int off, int len) throws AuthException, IOException {
        if (this.m_ContentDigest != null) {
            this.m_ContentDigest.update(data, off, len);
        }
        this.forward(data, off, len);
    }

    @Override
    protected int update(InputStream src, int count) throws IOException, AuthException {
        return BytesOutputStream.transfer((InputStream)src, (OutputStream)this, (int)count);
    }
}

