/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.auth;

import cn.weforward.common.crypto.Base64;
import cn.weforward.common.crypto.Hex;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.auth.AuthEngine;
import cn.weforward.protocol.exception.AuthException;
import java.security.MessageDigest;
import java.util.Random;

public class SignAuthEngine
implements AuthEngine {
    protected Random m_Random = new Random();

    @Override
    public String getType() {
        return "WF-Sign";
    }

    @Override
    public AuthEngine.Output encode(AuthEngine.Input in) throws AuthException {
        String sign;
        String noise = in.noise;
        if (StringUtil.isEmpty((String)noise)) {
            long n = System.currentTimeMillis() << 20;
            int i = this.m_Random.nextInt();
            noise = Hex.toHex64((long)(n |= (long)(i & 0xFFFFF)));
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(in.data, in.dataOffset, in.dataLength);
            md.update(noise.getBytes("utf-8"));
            md.update(in.accessKey);
            sign = Base64.encode((byte[])md.digest());
        }
        catch (Exception e) {
            throw new AuthException(1002, e.toString());
        }
        AuthEngine.Output out = new AuthEngine.Output();
        out.sign = sign;
        out.noise = noise;
        out.data = in.data;
        out.dataOffset = in.dataOffset;
        out.dataLength = in.dataLength;
        return out;
    }

    @Override
    public AuthEngine.Output decode(AuthEngine.Input in) throws AuthException {
        String sign;
        if (StringUtil.isEmpty((String)in.noise)) {
            throw new AuthException(1002, "Noise\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)in.sign)) {
            throw new AuthException(1002, "Sign\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String inputSign = in.sign;
        if (inputSign.length() <= 32 || inputSign.length() > 64) {
            throw new AuthException(1002, "Sign\u503c\u5f02\u5e38:" + StringUtil.limit((String)inputSign, (int)100));
        }
        if (64 == inputSign.length()) {
            try {
                inputSign = Base64.encode((byte[])Hex.decode((String)inputSign));
            }
            catch (Exception e) {
                throw new AuthException(1002, "Sign\u503c\u5f02\u5e38:" + inputSign);
            }
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(in.data, in.dataOffset, in.dataLength);
            md.update(in.noise.getBytes("utf-8"));
            md.update(in.accessKey);
            sign = Base64.encode((byte[])md.digest());
        }
        catch (Exception e) {
            throw new AuthException(1002, (Throwable)e);
        }
        if (!sign.equals(inputSign)) {
            throw new AuthException(1002, "\u7b7e\u540d\u4e0d\u4e00\u81f4\uff1a" + sign + " != " + inputSign);
        }
        AuthEngine.Output out = new AuthEngine.Output();
        out.sign = sign;
        out.noise = in.noise;
        out.data = in.data;
        out.dataOffset = in.dataOffset;
        out.dataLength = in.dataLength;
        return out;
    }
}

