/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.auth;

import cn.weforward.common.crypto.Base64;
import cn.weforward.common.crypto.Hex;
import cn.weforward.common.io.BytesOutputStream;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.Access;
import cn.weforward.protocol.Header;
import cn.weforward.protocol.auth.AutherOutputStream;
import cn.weforward.protocol.exception.AuthException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SignOutputStream
extends AutherOutputStream {
    String m_Noise;
    String m_Sign;
    byte[] m_AccessKey;
    MessageDigest m_MessageDigest;

    @Override
    protected void onInit() {
        if (this.isMode(1)) {
            throw new IllegalArgumentException("WF-Sign\u4e0d\u652f\u6301encode\u6a21\u5f0f");
        }
    }

    @Override
    protected Header authHeader(Header header) throws AuthException {
        this.decodeHeader(header);
        return header;
    }

    void decodeHeader(Header header) throws AuthException {
        String accessId;
        String noise = header.getNoise();
        if (StringUtil.isEmpty((String)noise)) {
            throw new AuthException(1002, "\u7f3a\u5c11'noise'");
        }
        String sign = header.getSign();
        if (StringUtil.isEmpty((String)header.getSign())) {
            throw new AuthException(1002, "\u7f3a\u5c11'sign'");
        }
        if (sign.length() <= 32 || sign.length() > 64) {
            throw new AuthException(1002, "'sign'\u503c\u5f02\u5e38:" + StringUtil.limit((String)sign, (int)100));
        }
        if (64 == sign.length()) {
            try {
                sign = Base64.encode((byte[])Hex.decode((String)sign));
            }
            catch (Exception e) {
                throw new AuthException(1002, "'sign'\u503c\u5f02\u5e38:" + sign);
            }
        }
        if (StringUtil.isEmpty((String)(accessId = header.getAccessId()))) {
            throw new AuthException(1002, "\u7f3a\u5c11'access id'");
        }
        Access access = this.m_AccessLoader.getValidAccess(accessId);
        if (access == null) {
            throw new AuthException(1002, "'access id'\u65e0\u6548");
        }
        this.m_Noise = noise;
        this.m_Sign = sign;
        this.m_AccessKey = access.getAccessKey();
        try {
            this.m_MessageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthException(1002, (Throwable)e);
        }
    }

    @Override
    protected boolean isIgnoreContent() {
        return false;
    }

    @Override
    protected void doFinal() throws AuthException, IOException {
        this.m_MessageDigest.update(this.m_Noise.getBytes("utf-8"));
        this.m_MessageDigest.update(this.m_AccessKey);
        String sign = Base64.encode((byte[])this.m_MessageDigest.digest());
        if (!sign.equals(this.m_Sign)) {
            throw new AuthException(1002, "\u5185\u5bb9\u7b7e\u540d\u4e0d\u4e00\u81f4\uff1a" + sign + " != " + this.m_Sign);
        }
    }

    @Override
    protected int update(ByteBuffer src) throws IOException, AuthException {
        int mark = src.position();
        this.m_MessageDigest.update(src);
        src.position(mark);
        return this.forward(src);
    }

    @Override
    protected void update(int b) throws IOException, AuthException {
        this.m_MessageDigest.update((byte)b);
        this.forward(b);
    }

    @Override
    protected int update(InputStream src, int count) throws IOException, AuthException {
        return BytesOutputStream.transfer((InputStream)src, (OutputStream)this, (int)count);
    }

    @Override
    protected void update(byte[] data, int off, int len) throws AuthException, IOException {
        this.m_MessageDigest.update(data, off, len);
        this.forward(data, off, len);
    }
}

