/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client;

import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.Header;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.client.ServiceInvoker;
import cn.weforward.protocol.client.execption.ServiceInvokeException;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.ops.trace.ServiceTraceToken;
import cn.weforward.protocol.support.SimpleRequest;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.datatype.SimpleDtString;

public abstract class AbstractServiceInvoker
implements ServiceInvoker {
    public abstract String getServiceName();

    public abstract String getCharset();

    public abstract void setAccessId(String var1);

    public abstract String getAccessId();

    @Override
    public Response invoke(DtObject invokeInfo) throws ServiceInvokeException {
        return this.invoke(this.createRequest(invokeInfo));
    }

    @Override
    public Response invoke(String method, DtObject params) throws ServiceInvokeException {
        return this.invoke(this.createRequest(method, params));
    }

    @Override
    public Response invoke(String method) throws ServiceInvokeException {
        return this.invoke(method, null);
    }

    @Override
    public Request createRequest(String method) {
        return this.createRequest(method, null);
    }

    @Override
    public Request createRequest(String method, DtObject params) {
        SimpleDtObject invoke = new SimpleDtObject(false);
        invoke.put("method", SimpleDtString.valueOf(method));
        if (params != null) {
            invoke.put("params", params);
        }
        return this.createRequest(invoke, this.getServiceName());
    }

    @Override
    public Request createRequest(DtObject invokeInfo) {
        return this.createRequest(invokeInfo, this.getServiceName());
    }

    protected Request createRequest(DtObject invokeInfo, String serviceName) {
        Header header = new Header(serviceName);
        header.setContentType(this.getContentType());
        header.setAuthType(this.getAuthType());
        header.setCharset(this.getCharset());
        header.setAccessId(this.getAccessId());
        SimpleRequest request = new SimpleRequest();
        request.setHeader(header);
        String traceToken = ServiceTraceToken.TTT.get();
        if (!StringUtil.isEmpty((String)traceToken)) {
            request.setTraceToken(traceToken);
        }
        request.setServiceInvoke(invokeInfo);
        return request;
    }

    public String toString() {
        return this.getAccessId();
    }
}

