/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client;

import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.client.AbstractServiceInvoker;
import cn.weforward.protocol.client.ServiceInvoker;
import cn.weforward.protocol.client.execption.ServiceInvokeException;
import cn.weforward.protocol.client.execption.TransportException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceInvoker
extends AbstractServiceInvoker {
    static final Logger _Logger = LoggerFactory.getLogger(DefaultServiceInvoker.class);
    protected List<AbstractServiceInvoker> m_Invokers;
    private volatile int m_InvokerOffset;

    public DefaultServiceInvoker(List<AbstractServiceInvoker> invvokers) {
        this.m_Invokers = invvokers;
        this.m_InvokerOffset = 0;
    }

    @Override
    public String getAccessId() {
        return this.m_Invokers.get(0).getAccessId();
    }

    @Override
    public void setAccessId(String id) {
        for (AbstractServiceInvoker invoker : this.m_Invokers) {
            invoker.setAccessId(id);
        }
    }

    @Override
    public String getServiceName() {
        return this.m_Invokers.get(0).getServiceName();
    }

    @Override
    public String getContentType() {
        return this.m_Invokers.get(0).getContentType();
    }

    @Override
    public void setContentType(String type) {
        for (AbstractServiceInvoker invoker : this.m_Invokers) {
            invoker.setContentType(type);
        }
    }

    @Override
    public String getAuthType() {
        return this.m_Invokers.get(0).getAuthType();
    }

    @Override
    public void setAuthType(String type) {
        for (AbstractServiceInvoker invoker : this.m_Invokers) {
            invoker.setAuthType(type);
        }
    }

    @Override
    public String getCharset() {
        return this.m_Invokers.get(0).getCharset();
    }

    @Override
    public int getConnectTimeout() {
        return this.m_Invokers.get(0).getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        for (AbstractServiceInvoker invoker : this.m_Invokers) {
            invoker.setConnectTimeout(timeout);
        }
    }

    @Override
    public int getReadTimeout() {
        return this.m_Invokers.get(0).getReadTimeout();
    }

    @Override
    public void setReadTimeout(int timeout) {
        for (AbstractServiceInvoker invoker : this.m_Invokers) {
            invoker.setReadTimeout(timeout);
        }
    }

    @Override
    public Response invoke(Request request) throws ServiceInvokeException {
        ServiceInvokeException err = null;
        int size = this.m_Invokers.size();
        int offset = this.m_InvokerOffset;
        int i = 0;
        while (i < size) {
            int idx = i + offset;
            idx = idx < size ? idx : idx - size;
            ServiceInvoker invoker = this.m_Invokers.get(idx);
            try {
                Response resp = invoker.invoke(request);
                this.m_InvokerOffset = idx;
                return resp;
            }
            catch (ServiceInvokeException e) {
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug("index" + idx + ",invoker:" + invoker, (Throwable)e);
                }
                err = e;
                Throwable cause = e.getCause();
                if (cause instanceof TransportException && ((TransportException)cause).isType(2)) break;
                ++i;
            }
        }
        throw err;
    }

    @Override
    public String toString() {
        return "{offset:" + this.m_InvokerOffset + " ,invokers:" + this.m_Invokers + "}";
    }
}

