/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client;

import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.AccessLoader;
import cn.weforward.protocol.client.AbstractServiceInvoker;
import cn.weforward.protocol.client.DefaultServiceInvoker;
import cn.weforward.protocol.client.ServiceInvoker;
import cn.weforward.protocol.client.SingleServiceInvoker;
import cn.weforward.protocol.client.netty.NettyServiceInvoker;
import cn.weforward.protocol.ext.Producer;
import cn.weforward.protocol.support.SimpleProducer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ServiceInvokerFactory {
    private static final String INVOKER = System.getProperty("cn.weforward.protocol.client.invoker", "");

    public static ServiceInvoker create(String serviceName, String preUrl, String accessId, String accessKey) {
        List<String> urls = Collections.emptyList();
        if (!StringUtil.isEmpty((String)preUrl)) {
            urls = Arrays.asList(preUrl.split(";"));
        }
        return ServiceInvokerFactory.create(serviceName, urls, accessId, accessKey);
    }

    public static ServiceInvoker create(String serviceName, List<String> preUrls, String accessId, String accessKey) {
        DefaultServiceInvoker invoker = (DefaultServiceInvoker)ServiceInvokerFactory.create(preUrls, serviceName, ServiceInvokerFactory.createProducer(accessId, accessKey));
        invoker.setAccessId(accessId);
        return invoker;
    }

    public static Producer createProducer(String accessId, String accessKey) {
        AccessLoader accessLoader = StringUtil.isEmpty((String)accessId) ? AccessLoader.EMPTY : new AccessLoader.Single(accessId, accessKey);
        SimpleProducer producer = new SimpleProducer(accessLoader);
        return producer;
    }

    public static ServiceInvoker create(List<String> urls, String accessId, String accessKey) {
        String url = urls.get(0);
        int index = url.lastIndexOf(47);
        if (-1 == index || index == url.length() - 1) {
            throw new IllegalArgumentException("\u94fe\u63a5\u672a\u5305\u542b\u670d\u52a1\u540d");
        }
        String serviceName = url.substring(index + 1);
        return ServiceInvokerFactory.create(serviceName, urls, accessId, accessKey);
    }

    public static ServiceInvoker create(List<String> urls, String serviceName, Producer producer) {
        if (urls == null || urls.size() == 0) {
            throw new IllegalArgumentException("Url\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<AbstractServiceInvoker> invokers = new ArrayList<AbstractServiceInvoker>(urls.size());
        for (String url : urls) {
            if (StringUtil.isEmpty((String)url)) continue;
            invokers.add(ServiceInvokerFactory.createInvoker(url, serviceName, producer));
        }
        DefaultServiceInvoker invoker = new DefaultServiceInvoker(invokers);
        return invoker;
    }

    public static AbstractServiceInvoker createInvoker(String url, String serviceName, Producer producer) {
        if ("netty".contentEquals(INVOKER)) {
            return new NettyServiceInvoker(url, serviceName, producer);
        }
        return new SingleServiceInvoker(url, serviceName, producer);
    }
}

