/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client;

import cn.weforward.common.KvPair;
import cn.weforward.common.util.ListUtil;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.client.EventInvoker;
import cn.weforward.protocol.client.ServiceInvoker;
import cn.weforward.protocol.client.ServiceInvokerFactory;
import cn.weforward.protocol.client.execption.GatewayException;
import cn.weforward.protocol.client.execption.MicroserviceException;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.support.NamingConverter;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import cn.weforward.protocol.support.datatype.SimpleDtList;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.datatype.SimpleDtString;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SimpleEventInvoker
implements EventInvoker {
    protected ConcurrentMap<String, ServiceInvoker> m_Invokers = new ConcurrentHashMap<String, ServiceInvoker>();
    protected String m_PreUrl;
    protected String m_AccessId;
    protected String m_AccessKey;

    public SimpleEventInvoker(String preUrl, String accessId, String accessKey) {
        this.m_PreUrl = preUrl;
        this.m_AccessId = accessId;
        this.m_AccessKey = accessKey;
    }

    @Override
    public DtBase invoke(String name, String uri) {
        return this.invoke(name, uri, null);
    }

    @Override
    public DtBase invoke(String name, String uri, DtObject myparams) {
        String serviceName;
        String channel;
        if (uri == null) {
            throw new NullPointerException("uri\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int protocolLength = 0;
        int marks = 0;
        if (uri.startsWith("event://")) {
            protocolLength = "event://".length();
            channel = "rpc";
        } else if (uri.startsWith("notify://")) {
            protocolLength = "notify://".length();
            channel = "notify";
        } else if (uri.startsWith("broadcast://")) {
            protocolLength = "broadcast://".length();
            channel = "notify";
            marks |= 2;
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u534f\u8bae[" + uri + "]");
        }
        int queryIndex = uri.indexOf("?");
        SimpleDtObject params = new SimpleDtObject();
        String group = "";
        if (queryIndex > 0) {
            String[] queryParams;
            serviceName = uri.substring(protocolLength, queryIndex);
            String query = uri.substring(queryIndex + 1);
            String[] stringArray = queryParams = query.split("&");
            int n = queryParams.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                String key;
                String queryParam = stringArray[n2];
                int index = queryParam.indexOf(61);
                if (index > 0) {
                    key = queryParam.substring(0, index);
                    value = queryParam.substring(index + 1);
                } else {
                    key = query;
                    value = "";
                }
                if (StringUtil.eq((String)key, (String)"_group")) {
                    group = value;
                } else {
                    params.put(key, value);
                }
                ++n2;
            }
        } else {
            serviceName = uri.substring(protocolLength);
        }
        if (myparams != null) {
            Enumeration<KvPair<String, DtBase>> e = myparams.getAttributes();
            while (e.hasMoreElements()) {
                KvPair<String, DtBase> param = e.nextElement();
                if (param == null) continue;
                params.put((String)param.getKey(), (DtBase)param.getValue());
            }
        }
        ServiceInvoker invoker = this.getInvoker(serviceName);
        name = String.valueOf(group) + NamingConverter.camelToWf(name);
        Request request = invoker.createRequest(name, params);
        request.getHeader().setChannel(channel);
        request.setMarks(marks);
        Response response = invoker.invoke(request);
        GatewayException.checkException(response);
        FriendlyObject result = FriendlyObject.valueOf(response.getServiceResult());
        MicroserviceException.checkException(result);
        if (StringUtil.eq((String)"notify", (String)channel)) {
            List<String> list = response.getNotifyReceives();
            if (ListUtil.isEmpty(list)) {
                return SimpleDtList.empty();
            }
            ArrayList<DtBase> resultlist = new ArrayList<DtBase>(list.size());
            for (String v : list) {
                resultlist.add(new SimpleDtString(v));
            }
            return SimpleDtList.valueOf(resultlist);
        }
        return result.getBase("content");
    }

    private ServiceInvoker getInvoker(String serviceName) {
        ServiceInvoker old;
        ServiceInvoker invoker = (ServiceInvoker)this.m_Invokers.get(serviceName);
        if (invoker == null && (old = this.m_Invokers.putIfAbsent(serviceName, invoker = ServiceInvokerFactory.create(serviceName, this.m_PreUrl, this.m_AccessId, this.m_AccessKey))) != null) {
            invoker = old;
        }
        return invoker;
    }
}

