/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client;

import cn.weforward.common.ResultPage;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.client.CustomOption;
import cn.weforward.protocol.client.FriendlyServiceInvoker;
import cn.weforward.protocol.client.ResponseAware;
import cn.weforward.protocol.client.ServiceInvoker;
import cn.weforward.protocol.client.execption.GatewayException;
import cn.weforward.protocol.client.execption.MicroserviceException;
import cn.weforward.protocol.client.ext.TransRemoteResultPage;
import cn.weforward.protocol.client.util.MappedUtil;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.ext.ObjectMapperSet;
import cn.weforward.protocol.support.NamingConverter;
import cn.weforward.protocol.support.datatype.FriendlyList;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import java.util.List;

public class SimpleFriendlyServiceInvoker
implements FriendlyServiceInvoker {
    protected ServiceInvoker m_Invoker;
    protected String m_MethodGroup = "";
    protected ObjectMapperSet m_MapperSet;

    public SimpleFriendlyServiceInvoker(ServiceInvoker invoker) {
        this.m_Invoker = invoker;
    }

    public void setMethodGroup(String methodGroup) {
        this.m_MethodGroup = methodGroup == null ? "" : NamingConverter.camelToWf(methodGroup);
    }

    public void setMapperSet(ObjectMapperSet set) {
        this.m_MapperSet = set;
    }

    @Override
    public <E> E invoke(String method, Object params, Class<? extends E> resultClass) {
        return this.invoke(method, params, resultClass, null, null);
    }

    @Override
    public <E> E invoke(String method, Object params, Class<? extends E> resultClass, FriendlyServiceInvoker.Option option) {
        return this.invoke(method, params, resultClass, null, option);
    }

    @Override
    public <E, V> E invoke(String method, Object params, Class<? extends E> resultClass, Class<V> componentClass) {
        return this.invoke(method, params, resultClass, componentClass, null);
    }

    @Override
    public <E, V> E invoke(String method, Object params, Class<? extends E> resultClass, final Class<V> componentClass, FriendlyServiceInvoker.Option option) {
        if (option == null && params instanceof CustomOption) {
            option = ((CustomOption)params).customOption();
        }
        DtObject realParams = this.realParams(params);
        method = this.genMethod(method);
        if (ResultPage.class == resultClass) {
            final FriendlyServiceInvoker.Option myoption = option;
            return (E)((Object)new TransRemoteResultPage<V>(this.m_Invoker, method, realParams){

                @Override
                protected Request createRequest(String method, DtObject params) {
                    Request request = super.createRequest(method, params);
                    return SimpleFriendlyServiceInvoker.this.optionRequest(request, myoption);
                }

                @Override
                protected V trans(DtBase item) {
                    return MappedUtil.fromBase(componentClass, null, item, SimpleFriendlyServiceInvoker.this.m_MapperSet);
                }
            });
        }
        Request request = this.m_Invoker.createRequest(method, realParams);
        request = this.optionRequest(request, option);
        Response response = this.m_Invoker.invoke(request);
        GatewayException.checkException(response);
        DtObject serviceResult = response.getServiceResult();
        MicroserviceException.checkException(serviceResult);
        Object e = resultClass == null || Void.TYPE == resultClass || Void.class == resultClass ? null : (DtObject.class == resultClass ? serviceResult.getObject("content") : (DtList.class == resultClass ? serviceResult.getList("content") : (FriendlyObject.class == resultClass ? FriendlyObject.valueOf(serviceResult.getObject("content")) : (FriendlyList.class == resultClass ? FriendlyList.valueOf(serviceResult.getList("content")) : MappedUtil.fromBase(resultClass, componentClass, serviceResult.getAttribute("content"), this.m_MapperSet)))));
        if (e instanceof ResponseAware) {
            ((ResponseAware)e).onResponse(response);
        }
        if (option != null && option.getResponseAware() != null) {
            option.getResponseAware().onResponse(response);
        }
        return (E)e;
    }

    private Request optionRequest(Request request, FriendlyServiceInvoker.Option option) {
        if (option == null) {
            return request;
        }
        if (option.getWaitTimeout() > 0) {
            request.setWaitTimeout(option.getWaitTimeout());
        }
        if (!StringUtil.isEmpty((String)option.getVersion())) {
            request.setVersion(option.getVersion());
        }
        if (!StringUtil.isEmpty((String)option.getTag())) {
            request.getHeader().setTag(option.getTag());
        }
        return request;
    }

    private String genMethod(String method) {
        return String.valueOf(this.m_MethodGroup) + NamingConverter.camelToWf(method);
    }

    private DtObject realParams(Object params) {
        DtObject realParams;
        if (params == null) {
            realParams = null;
        } else if (params instanceof DtObject) {
            realParams = (DtObject)params;
        } else if (params instanceof FriendlyObject) {
            realParams = ((FriendlyObject)params).dtObjectValue();
        } else {
            DtBase base = MappedUtil.toBase(params, this.m_MapperSet);
            if (base instanceof DtObject) {
                realParams = (DtObject)base;
            } else {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b:" + params.getClass());
            }
        }
        return realParams;
    }

    @Override
    public <E> List<E> invokeList(String method, Object params, Class<? extends E> componentClass) {
        return this.invokeList(method, params, componentClass, null);
    }

    @Override
    public <E> List<E> invokeList(String method, Object params, Class<? extends E> componentClass, FriendlyServiceInvoker.Option option) {
        return this.invoke(method, params, List.class, componentClass);
    }

    @Override
    public <E> ResultPage<E> invokeResultPage(String method, Object params, Class<? extends E> componentClass) {
        return this.invokeResultPage(method, params, componentClass, null);
    }

    @Override
    public <E> ResultPage<E> invokeResultPage(String method, Object params, Class<? extends E> componentClass, FriendlyServiceInvoker.Option option) {
        return this.invoke(method, params, ResultPage.class, componentClass);
    }
}

