/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client;

import cn.weforward.common.Dictionary;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.client.AbstractServiceInvoker;
import cn.weforward.protocol.client.execption.HttpTransportException;
import cn.weforward.protocol.client.execption.ServiceInvokeException;
import cn.weforward.protocol.ext.Producer;
import cn.weforward.protocol.support.SimpleProducer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class SingleServiceInvoker
extends AbstractServiceInvoker {
    protected String m_ServiceName;
    protected String m_Charset = "utf-8";
    protected String m_ContentType = "json";
    protected String m_AuthType = "WF-SHA2";
    protected String m_AccessId;
    protected Producer m_Producer;
    protected String m_UrlStr;
    protected URL m_Url;
    protected int m_ConnectTimeout = 5000;
    protected int m_ReadTimeout = 60000;

    public SingleServiceInvoker(String preUrl, String serviceName, Producer producer) {
        if (StringUtil.isEmpty((String)preUrl) || StringUtil.isEmpty((String)serviceName)) {
            throw new IllegalArgumentException("\u94fe\u63a5\u4e0e\u670d\u52a1\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = preUrl.endsWith(serviceName) ? preUrl : (preUrl.endsWith("/") ? String.valueOf(preUrl) + serviceName : String.valueOf(preUrl) + "/" + serviceName);
        this.m_UrlStr = url;
        try {
            this.m_Url = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Url\u683c\u5f0f\u5f02\u5e38\uff1a" + url, e);
        }
        this.m_ServiceName = serviceName;
        this.m_Producer = producer;
    }

    @Override
    public String getServiceName() {
        return this.m_ServiceName;
    }

    @Override
    public String getContentType() {
        return this.m_ContentType;
    }

    @Override
    public void setContentType(String type) {
        this.m_ContentType = type;
    }

    @Override
    public String getAuthType() {
        return this.m_AuthType;
    }

    @Override
    public void setAuthType(String type) {
        this.m_AuthType = type;
    }

    @Override
    public String getAccessId() {
        return this.m_AccessId;
    }

    @Override
    public void setAccessId(String id) {
        this.m_AccessId = id;
    }

    public void setProducer(Producer producer) {
        this.m_Producer = producer;
    }

    @Override
    public String getCharset() {
        return this.m_Charset;
    }

    @Override
    public int getConnectTimeout() {
        return this.m_ConnectTimeout;
    }

    @Override
    public void setConnectTimeout(int ms) {
        this.m_ConnectTimeout = ms;
    }

    @Override
    public int getReadTimeout() {
        return this.m_ReadTimeout;
    }

    @Override
    public void setReadTimeout(int ms) {
        this.m_ReadTimeout = ms;
    }

    @Override
    public Response invoke(Request request) throws ServiceInvokeException {
        HttpOutput out = null;
        InputStream in = null;
        try {
            HttpURLConnection conn = this.createConnection();
            if (request.getWaitTimeout() > 0) {
                conn.setReadTimeout(request.getWaitTimeout() * 1000);
            }
            out = new HttpOutput(conn);
            this.m_Producer.make(request, (Producer.Output)new SimpleProducer.SimpleProducerOutput(conn, (OutputStream)out));
            ((OutputStream)out).close();
            out = null;
            int responseCode = conn.getResponseCode();
            if (200 != responseCode) {
                in = responseCode >= 400 ? conn.getErrorStream() : conn.getInputStream();
                throw new HttpTransportException(responseCode, conn.getResponseMessage());
            }
            in = conn.getInputStream();
            String service = request.getHeader().getService();
            Response res = this.m_Producer.fetchResponse(new SimpleProducer.SimpleProducerInput(SingleServiceInvoker.toDictionary(conn.getHeaderFields()), in, service));
            in.close();
            Response response = res;
            this.close(out);
            this.close(in);
            return response;
        }
        catch (Exception e) {
            try {
                throw new ServiceInvokeException(e);
            }
            catch (Throwable throwable) {
                this.close(out);
                this.close(in);
                throw throwable;
            }
        }
    }

    protected HttpURLConnection createConnection() throws IOException {
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)this.m_Url.openConnection();
        conn.setRequestMethod("POST");
        conn.setConnectTimeout(this.m_ConnectTimeout);
        conn.setReadTimeout(this.m_ReadTimeout);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        return conn;
    }

    private static Dictionary<String, String> toDictionary(final Map<String, List<String>> map) {
        return new Dictionary<String, String>(){

            public String get(String key) {
                List list = (List)map.get(key);
                if (list != null && list.size() > 0) {
                    return (String)list.get(0);
                }
                return null;
            }
        };
    }

    private void close(Closeable close) {
        if (close == null) {
            return;
        }
        try {
            close.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return "{url:" + this.m_UrlStr + ",acc:" + this.m_AccessId + ",cs:" + this.m_Charset + ",ct:" + this.m_ContentType + ",at:" + this.m_AuthType + "}";
    }

    static class HttpOutput
    extends OutputStream {
        OutputStream m_Original;
        HttpURLConnection m_Connection;

        HttpOutput(HttpURLConnection conn) {
            this.m_Connection = conn;
        }

        private OutputStream open() throws IOException {
            if (this.m_Original == null) {
                this.m_Original = this.m_Connection.getOutputStream();
            }
            return this.m_Original;
        }

        @Override
        public void write(int b) throws IOException {
            this.open().write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.open().write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.open().write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.open().flush();
        }

        @Override
        public void close() throws IOException {
            this.open().close();
        }
    }
}

