/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client.execption;

import cn.weforward.protocol.Response;
import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.support.datatype.FriendlyObject;

public class MicroserviceException
extends RuntimeException {
    protected int m_Code;
    protected String m_Msg;
    public static final int CUSTOM_CODE_START = 100000;
    public static final int CUSTOM_CODE_END = 999999;

    public MicroserviceException(DtObject serviceResult) {
        this(FriendlyObject.valueOf(serviceResult));
    }

    public MicroserviceException(FriendlyObject serviceResult) {
        this(serviceResult.getInt("code"), serviceResult.getString("msg"));
    }

    public MicroserviceException(int code, String msg) {
        super("\u5fae\u670d\u52a1\u54cd\u5e94\u5f02\u5e38:" + code + "/" + msg);
        this.m_Code = code;
        this.m_Msg = msg;
    }

    public MicroserviceException(String exceptionMessage, int code, String msg) {
        super(exceptionMessage);
        this.m_Code = code;
        this.m_Msg = msg;
    }

    public int getCode() {
        return this.m_Code;
    }

    public String getMsg() {
        return this.m_Msg;
    }

    public boolean isCustom() {
        return this.m_Code >= 100000 && this.m_Code < 999999;
    }

    public static void checkException(Response response) throws MicroserviceException {
        MicroserviceException.checkException(response.getServiceResult());
    }

    public static boolean isSuccess(FriendlyObject serviceResult) {
        return serviceResult.getInt("code") == 0;
    }

    public static boolean isSuccess(DtObject serviceResult) {
        DtNumber code = serviceResult.getNumber("code");
        if (code == null) {
            return false;
        }
        return code.valueInt() == 0;
    }

    public static void checkException(DtObject serviceResult) throws MicroserviceException {
        MicroserviceException.checkException(FriendlyObject.valueOf(serviceResult));
    }

    public static void checkException(FriendlyObject serviceResult) throws MicroserviceException {
        if (serviceResult.getInt("code") != 0) {
            throw new MicroserviceException(serviceResult);
        }
    }
}

