/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client.execption;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class TransportException
extends IOException {
    private static final long serialVersionUID = 1L;
    protected int m_Type;
    public static final int TYPE_ERROR_UNDEFINED = 0;
    public static final int TYPE_ERROR_STATUS_ERROR = 1;
    public static final int TYPE_ERROR_READ_TIMEOUT = 2;
    public static final int TYPE_ERROR_CONNECT_TIMEOUT = 4;
    public static final int TYPE_ERROR_CONNECT_ERROR = 8;
    public static final int TYPE_ERROR_UNKNOWN_HOST = 16;

    public TransportException(String message) {
        super(message);
    }

    public TransportException(IOException cause) {
        super(cause);
    }

    public TransportException(int type, String message, IOException cause) {
        super(message, cause);
        this.m_Type = type;
    }

    public static TransportException valueOf(IOException cause, String url) {
        String message;
        int type;
        if (cause instanceof SocketTimeoutException) {
            String str = cause.getMessage();
            if (str != null && str.contains("Read timed out")) {
                type = 2;
                message = "\u8bfb\u53d6\u8d85\u65f6,url:" + url;
            } else {
                type = 4;
                message = "\u8fde\u63a5\u8d85\u65f6,url:" + url;
            }
        } else if (cause instanceof ConnectException) {
            type = 8;
            message = "\u8fde\u63a5\u5f02\u5e38:" + cause.getMessage() + " ,url:" + url;
        } else if (cause instanceof UnknownHostException) {
            type = 16;
            message = "\u89e3\u6790ip\u5730\u5740\u5931\u8d25:" + cause.getMessage();
        } else {
            type = 0;
            message = cause.toString();
        }
        return new TransportException(type, message, cause);
    }

    public int getType() {
        return this.m_Type;
    }

    public boolean isType(int type) {
        return this.m_Type == type;
    }
}

