/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client.ext;

import cn.weforward.common.util.AbstractResultPage;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.client.ServiceInvoker;
import cn.weforward.protocol.client.execption.GatewayException;
import cn.weforward.protocol.client.execption.MicroserviceException;
import cn.weforward.protocol.client.ext.RequestInvokeObject;
import cn.weforward.protocol.client.ext.RequestInvokeParam;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.support.PageData;
import cn.weforward.protocol.support.PageDataMapper;

public class RemoteResultPage<E>
extends AbstractResultPage<E> {
    protected ServiceInvoker m_Invoker;
    protected RequestInvokeObject m_InvokeObj;
    protected PageData m_Data;
    protected PageDataMapper m_DataMapper;
    protected String m_Tag;

    public RemoteResultPage(ServiceInvoker invoker, String method, RequestInvokeParam ... params) {
        this(new PageDataMapper(), invoker, method, params);
    }

    public RemoteResultPage(ServiceInvoker invoker, RequestInvokeObject invokeObj) {
        this(new PageDataMapper(), invoker, invokeObj);
    }

    public RemoteResultPage(Class<? extends E> elementClazz, ServiceInvoker invoker, RequestInvokeObject invokeObj) {
        this(new PageDataMapper(elementClazz), invoker, invokeObj);
    }

    public RemoteResultPage(Class<? extends E> elementClazz, ServiceInvoker invoker, String method, RequestInvokeParam ... params) {
        this(new PageDataMapper(elementClazz), invoker, method, params);
    }

    public RemoteResultPage(PageDataMapper mapper, ServiceInvoker invoker, String method, RequestInvokeParam ... params) {
        this.m_Invoker = invoker;
        this.m_InvokeObj = new RequestInvokeObject(method);
        this.m_InvokeObj.putParams(params);
        this.m_DataMapper = mapper;
    }

    public RemoteResultPage(PageDataMapper mapper, ServiceInvoker invoker, RequestInvokeObject invokeObj) {
        this.m_Invoker = invoker;
        this.m_InvokeObj = new RequestInvokeObject(invokeObj);
        this.m_DataMapper = mapper;
    }

    void loadData() {
        this.loadData(this.m_InvokeObj);
    }

    void loadData(int page, int pageSize) {
        this.m_InvokeObj.putParam("page", page);
        this.m_InvokeObj.putParam("page_size", pageSize);
        this.loadData(this.m_InvokeObj);
    }

    void loadData(RequestInvokeObject invokeObj) {
        Response ret;
        try {
            Request req = this.m_Invoker.createRequest(invokeObj.toDtObject());
            if (!StringUtil.isEmpty((String)this.m_Tag)) {
                req.getHeader().setTag(this.m_Tag);
            }
            ret = this.m_Invoker.invoke(req);
        }
        catch (RuntimeException e) {
            throw this.onInvokeException(e);
        }
        if (ret.getResponseCode() != 0) {
            throw this.onGatewayException(ret.getResponseCode(), ret.getResponseMsg());
        }
        this.m_Tag = ret.getHeader().getTag();
        DtObject result = ret.getServiceResult();
        int code = result.getNumber("code").valueInt();
        if (code != 0) {
            String msg = result.getString("msg").value();
            throw this.onServiceException(code, msg);
        }
        DtObject content = result.getObject("content");
        this.m_Data = this.m_DataMapper.fromDtObject(content);
    }

    protected RuntimeException onInvokeException(RuntimeException e) {
        return e;
    }

    protected RuntimeException onGatewayException(int code, String msg) {
        return new GatewayException("\u52a0\u8f7d\u5931\u8d25\uff0c\u7f51\u5173\u54cd\u5e94\u5f02\u5e38:" + code + "/" + msg, code, msg);
    }

    protected RuntimeException onServiceException(int code, String msg) {
        return new MicroserviceException("\u52a0\u8f7d\u5931\u8d25\uff0c\u5fae\u670d\u52a1\u54cd\u5e94\u5f02\u5e38:" + code + "/" + msg, code, msg);
    }

    public int getCount() {
        if (this.m_Data == null) {
            this.loadData();
        }
        return this.m_Data.getCount();
    }

    protected E get(int idx) {
        if (this.m_Data == null || idx < this.m_Data.getPos() || idx >= this.m_Data.getPos() + this.m_Data.getItemSize()) {
            this.loadData(this.getPage(), this.getPageSize());
        }
        return this.m_Data.getItem(idx - this.m_Data.getPos());
    }
}

