/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client.ext;

import cn.weforward.common.KvPair;
import cn.weforward.protocol.client.ext.RequestInvokeParam;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.ext.ObjectMapperSet;
import cn.weforward.protocol.support.datatype.SimpleDtList;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;

public class RequestInvokeObject {
    SimpleDtObject m_Invoke;
    SimpleDtObject m_Params;
    ObjectMapperSet m_Mappers;

    public RequestInvokeObject(String method) {
        this.m_Invoke = new SimpleDtObject(false);
        this.m_Invoke.put("method", method);
    }

    public RequestInvokeObject(RequestInvokeObject other) {
        this.m_Invoke = other.m_Invoke;
        this.m_Mappers = other.m_Mappers;
        if (other.m_Params != null) {
            Enumeration<KvPair<String, DtBase>> dtObjAtts = other.m_Params.getAttributes();
            while (dtObjAtts.hasMoreElements()) {
                KvPair<String, DtBase> att = dtObjAtts.nextElement();
                this.putParam((String)att.getKey(), (DtBase)att.getValue());
            }
        }
    }

    public RequestInvokeObject(String method, ObjectMapperSet mappers) {
        this(method);
        this.setMappers(mappers);
    }

    public RequestInvokeObject(String method, RequestInvokeParam ... params) {
        this(method);
        this.putParams(params);
    }

    public void setMappers(ObjectMapperSet mappers) {
        this.m_Mappers = mappers;
    }

    public <E> ObjectMapper<E> getMapper(Class<E> clazz) {
        if (this.m_Mappers == null) {
            return null;
        }
        return this.m_Mappers.getObjectMapper(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleDtObject getParams() {
        if (this.m_Params == null) {
            RequestInvokeObject requestInvokeObject = this;
            synchronized (requestInvokeObject) {
                if (this.m_Params == null) {
                    this.m_Params = new SimpleDtObject();
                    this.m_Invoke.put("params", this.m_Params);
                }
            }
        }
        return this.m_Params;
    }

    public void putParam(String name, DtBase value) {
        this.getParams().put(name, value);
    }

    public void putParam(String name, String value) {
        this.getParams().put(name, value);
    }

    public void putParam(String name, int value) {
        this.getParams().put(name, value);
    }

    public void putParam(String name, long value) {
        this.getParams().put(name, value);
    }

    public void putParam(String name, double value) {
        this.getParams().put(name, value);
    }

    public void putParam(String name, Date value) {
        this.getParams().put(name, value);
    }

    public void putParam(String name, boolean value) {
        this.getParams().put(name, value);
    }

    public void putParamStringList(String name, Iterable<String> value) {
        SimpleDtList list = SimpleDtList.stringOf(value);
        this.getParams().put(name, list);
    }

    public void putParamDateList(String name, Iterable<Date> value) {
        SimpleDtList list = SimpleDtList.dateOf(value);
        this.getParams().put(name, list);
    }

    public void putParamNumberList(String name, Iterable<? extends Number> value) {
        SimpleDtList list = SimpleDtList.numberOf(value);
        this.getParams().put(name, list);
    }

    public void putParamBooleanList(String name, Iterable<Boolean> value) {
        SimpleDtList list = SimpleDtList.booleanOf(value);
        this.getParams().put(name, list);
    }

    public <E> void putParam(String name, E obj) {
        DtObject dtObj = null;
        if (obj != null) {
            ObjectMapper<?> mapper = this.getMapper(obj.getClass());
            if (mapper == null) {
                throw new ObjectMappingException("\u4e0d\u652f\u6301\u6620\u5c04\u6b64\u5bf9\u8c61\uff1a" + obj);
            }
            dtObj = mapper.toDtObject(obj);
        }
        this.getParams().put(name, dtObj);
    }

    public <E> void putParam(String name, Iterable<E> it) {
        if (it == null) {
            this.getParams().put(name, (DtBase)null);
            return;
        }
        Iterator<E> iterator = it.iterator();
        if (!iterator.hasNext()) {
            this.getParams().put(name, SimpleDtList.empty());
            return;
        }
        SimpleDtList dtList = new SimpleDtList();
        ObjectMapper<?> mapper = null;
        while (iterator.hasNext()) {
            E obj = iterator.next();
            if (mapper == null && (mapper = this.getMapper(obj.getClass())) == null) {
                throw new ObjectMappingException("\u4e0d\u652f\u6301\u6620\u5c04\u6b64\u5bf9\u8c61\uff1a" + obj);
            }
            DtObject hyObj = mapper.toDtObject(obj);
            dtList.addItem(hyObj);
        }
        this.getParams().put(name, dtList);
    }

    public void putParams(RequestInvokeParam ... params) {
        if (params == null || params.length == 0) {
            return;
        }
        RequestInvokeParam[] requestInvokeParamArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            RequestInvokeParam p = requestInvokeParamArray[n2];
            this.putParam(p.name, p.value);
            ++n2;
        }
    }

    public void asParams(Object obj) {
        DtObject dtObj;
        if (obj == null) {
            return;
        }
        if (obj instanceof DtObject) {
            dtObj = (DtObject)obj;
        } else {
            ObjectMapper<?> mapper = this.getMapper(obj.getClass());
            if (mapper == null) {
                throw new ObjectMappingException("\u4e0d\u652f\u6301\u6620\u5c04\u6b64\u5bf9\u8c61\uff1a" + obj);
            }
            dtObj = mapper.toDtObject(obj);
        }
        this.getParams().putAll(dtObj);
    }

    public DtObject toDtObject() {
        return this.m_Invoke;
    }
}

