/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client.ext;

import cn.weforward.protocol.client.ext.ResponseResultObject;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapperSet;
import cn.weforward.protocol.support.AbstractObjectMapper;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import cn.weforward.protocol.support.datatype.SimpleDtObject;

public class ResponseResultMapper
extends AbstractObjectMapper<ResponseResultObject> {
    public ResponseResultMapper(ObjectMapperSet mappers) {
        this.setMappers(mappers);
    }

    @Override
    public String getName() {
        return ResponseResultObject.class.getSimpleName();
    }

    @Override
    public DtObject toDtObject(ResponseResultObject object) throws ObjectMappingException {
        SimpleDtObject result = new SimpleDtObject(false);
        result.put("code", object.code);
        result.put("msg", object.msg);
        if (object.content == null) {
            return result;
        }
        result.put("content", this.toDtBase(object.content));
        return result;
    }

    @Override
    public ResponseResultObject fromDtObject(DtObject hyObject) throws ObjectMappingException {
        FriendlyObject obj = FriendlyObject.valueOf(hyObject);
        int code = obj.getInt("code", 0);
        String msg = obj.getString("msg");
        DtObject content = obj.getObject("content");
        return new ResponseResultObject(code, msg, content);
    }
}

