/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client.ext;

import cn.weforward.common.util.AbstractResultPage;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.client.ServiceInvoker;
import cn.weforward.protocol.client.execption.GatewayException;
import cn.weforward.protocol.client.execption.MicroserviceException;
import cn.weforward.protocol.client.ext.PageParams;
import cn.weforward.protocol.client.util.TransDtList;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.support.PageData;
import cn.weforward.protocol.support.datatype.FriendlyObject;

public abstract class TransRemoteResultPage<E>
extends AbstractResultPage<E> {
    static final int DEFAULT_PAGE = 0;
    static final int DEFAULT_PAGE_SIZE = 50;
    protected ServiceInvoker m_Invoker;
    protected PageData m_Data;
    protected String m_Method;
    protected DtObject m_Params;

    public TransRemoteResultPage(ServiceInvoker invoker, String method, DtObject params) {
        this.m_Invoker = invoker;
        this.m_Method = method;
        this.m_Params = params;
        this.loadData(0, 50);
    }

    void loadData() {
        this.loadData(this.getPage(), this.getPageSize());
    }

    void loadData(int page, int pageSize) {
        Request request = this.createRequest(this.m_Method, new PageParams(this.m_Params, page, pageSize));
        Response response = this.m_Invoker.invoke(request);
        try {
            GatewayException.checkException(response);
        }
        catch (GatewayException e) {
            this.onGatewayException(e);
        }
        DtObject serviceResult = response.getServiceResult();
        try {
            MicroserviceException.checkException(serviceResult);
        }
        catch (MicroserviceException e) {
            this.onMicroserviceException(e);
        }
        DtObject content = serviceResult.getObject("content");
        FriendlyObject obj = FriendlyObject.valueOf(content);
        TransDtList items = new TransDtList<E>(obj.getList("items")){

            @Override
            protected E trans(DtBase item) {
                return TransRemoteResultPage.this.trans(item);
            }
        };
        this.m_Data = PageData.valueOf(obj.getInt("count", 0), obj.getInt("page", 0), obj.getInt("page_size", 0), obj.getInt("page_count", 0), items);
    }

    protected abstract E trans(DtBase var1);

    protected void onMicroserviceException(MicroserviceException e) {
        throw e;
    }

    protected void onGatewayException(GatewayException e) {
        throw e;
    }

    protected Request createRequest(String method, DtObject params) {
        return this.m_Invoker.createRequest(method, params);
    }

    public int getCount() {
        return this.m_Data.getCount();
    }

    protected E get(int idx) {
        if (this.m_Data == null || idx < this.m_Data.getPos() || idx >= this.m_Data.getPos() + this.m_Data.getItemSize()) {
            this.loadData();
        }
        return this.m_Data.getItem(idx - this.m_Data.getPos());
    }
}

