/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client.netty;

import cn.weforward.common.Dictionary;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.aio.ClientChannel;
import cn.weforward.protocol.aio.ClientContext;
import cn.weforward.protocol.aio.ClientHandler;
import cn.weforward.protocol.client.AbstractServiceInvoker;
import cn.weforward.protocol.client.AioServiceInvoker;
import cn.weforward.protocol.client.execption.ServiceInvokeException;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.exception.AuthException;
import cn.weforward.protocol.exception.SerialException;
import cn.weforward.protocol.ext.Producer;
import cn.weforward.protocol.support.SimpleProducer;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.datatype.SimpleDtString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractNettyServiceInvoker
extends AbstractServiceInvoker
implements AioServiceInvoker {
    protected String m_Charset = "utf-8";
    protected String m_ContentType = "json";
    protected String m_AuthType = "WF-SHA2";
    protected String m_AccessId;
    protected int m_ReadTimeout = 50000;
    protected Producer m_Producer;

    public AbstractNettyServiceInvoker(Producer producer) {
        this.m_Producer = producer;
    }

    public Request createRequest(String serviceName, String method, DtObject params) {
        SimpleDtObject invoke = new SimpleDtObject(false);
        invoke.put("method", SimpleDtString.valueOf(method));
        if (params != null) {
            invoke.put("params", params);
        }
        return this.createRequest(invoke, serviceName);
    }

    protected abstract ClientChannel open() throws IOException;

    protected abstract String getServiceUrl(String var1);

    public void setProducer(Producer producer) {
        this.m_Producer = producer;
    }

    @Override
    public String getContentType() {
        return this.m_ContentType;
    }

    @Override
    public void setContentType(String type) {
        this.m_ContentType = type;
    }

    @Override
    public String getAuthType() {
        return this.m_AuthType;
    }

    @Override
    public void setAuthType(String type) {
        this.m_AuthType = type;
    }

    @Override
    public int getReadTimeout() {
        return this.m_ReadTimeout;
    }

    @Override
    public void setReadTimeout(int ms) {
        this.m_ReadTimeout = ms;
    }

    @Override
    public String getCharset() {
        return this.m_Charset;
    }

    @Override
    public void setAccessId(String accessId) {
        this.m_AccessId = accessId;
    }

    @Override
    public String getAccessId() {
        return this.m_AccessId;
    }

    @Override
    public Response invoke(Request request) throws ServiceInvokeException {
        Sync sync = new Sync();
        this.invoke(request, sync);
        return sync.await(this.getReadTimeout());
    }

    @Override
    public void invoke(Request request, AioServiceInvoker.Listener listener) {
        ClientContext client = null;
        InvokeHandler handler = new InvokeHandler(request, listener);
        try {
            try {
                String serviceName = request.getHeader().getService();
                client = this.open().request(handler, this.getServiceUrl(serviceName), "POST");
                client.setTimeout(this.getReadTimeout());
                client.setRequestHeader("User-Agent", serviceName);
                client = null;
            }
            catch (IOException e) {
                handler.fail(e);
                if (client != null) {
                    client.disconnect();
                }
            }
        }
        finally {
            if (client != null) {
                client.disconnect();
            }
        }
    }

    class InvokeHandler
    implements ClientHandler {
        ClientContext m_Client;
        Request m_Request;
        AioServiceInvoker.Listener m_Listener;

        InvokeHandler(Request request, AioServiceInvoker.Listener listener) {
            this.m_Listener = listener;
            this.m_Request = request;
        }

        @Override
        public void connectFail() {
            this.fail(null);
        }

        @Override
        public void established(ClientContext context) {
            this.m_Client = context;
            OutputStream out = null;
            try {
                try {
                    out = this.m_Client.openRequestWriter();
                    AbstractNettyServiceInvoker.this.m_Producer.make(this.m_Request, (Producer.Output)new SimpleProducer.SimpleProducerOutput(this.m_Client, out));
                    out.close();
                    out = null;
                }
                catch (AuthException | SerialException | IOException e) {
                    this.fail(e);
                    if (out != null) {
                        this.m_Client.disconnect();
                    }
                }
            }
            finally {
                if (out != null) {
                    this.m_Client.disconnect();
                }
            }
        }

        @Override
        public void requestCompleted() {
        }

        @Override
        public void requestAbort() {
            this.fail(null);
        }

        @Override
        public void responseHeader() {
        }

        @Override
        public void prepared(int available) {
        }

        @Override
        public void responseCompleted() {
            Response response;
            try {
                int responseCode = this.m_Client.getResponseCode();
                if (200 != responseCode) {
                    this.fail(new ServiceInvokeException("\u54cd\u5e94\u5f02\u5e38:" + responseCode));
                    return;
                }
                String service = this.m_Request.getHeader().getService();
                InputStream in = this.m_Client.getResponseStream();
                response = AbstractNettyServiceInvoker.this.m_Producer.fetchResponse(new SimpleProducer.SimpleProducerInput((Dictionary<String, String>)this.m_Client.getResponseHeaders(), in, service));
                in.close();
            }
            catch (AuthException | SerialException | IOException e) {
                this.fail(e);
                return;
            }
            AioServiceInvoker.Listener listener = this.m_Listener;
            if (listener == null) {
                return;
            }
            this.m_Listener = null;
            listener.success(this.m_Request, response);
            listener.complete(this.m_Request);
        }

        @Override
        public void responseTimeout() {
            this.fail(null);
        }

        @Override
        public void errorResponseTransferTo(IOException e, Object msg, OutputStream writer) {
        }

        private void fail(Throwable throwable) {
            AioServiceInvoker.Listener listener = this.m_Listener;
            if (listener == null) {
                return;
            }
            this.m_Listener = null;
            if (this.m_Client != null) {
                ServiceInvokeException exception = new ServiceInvokeException(throwable);
                exception.setContext(this.m_Client);
                throwable = exception;
            }
            listener.fail(this.m_Request, throwable);
            listener.complete(this.m_Request);
        }
    }

    static class Sync
    implements AioServiceInvoker.Listener {
        Response m_Response;
        Throwable m_Error;
        boolean m_Completed;

        Sync() {
        }

        @Override
        public void success(Request request, Response response) {
            this.m_Response = response;
        }

        @Override
        public void fail(Request request, Throwable throwable) {
            this.m_Error = throwable;
        }

        @Override
        public synchronized void complete(Request request) {
            this.m_Completed = true;
            this.notifyAll();
        }

        public synchronized Response await(int timeout) throws ServiceInvokeException {
            if (!this.m_Completed) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    new ServiceInvokeException(e);
                }
            }
            if (this.m_Error != null) {
                if (this.m_Error instanceof ServiceInvokeException) {
                    throw (ServiceInvokeException)this.m_Error;
                }
                throw new ServiceInvokeException(this.m_Error);
            }
            if (this.m_Response == null) {
                throw new ServiceInvokeException("resposne timeout");
            }
            return this.m_Response;
        }
    }
}

