/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client.netty;

import cn.weforward.common.DictionaryExt;
import cn.weforward.common.util.NumberUtil;
import cn.weforward.protocol.aio.ClientChannel;
import cn.weforward.protocol.aio.ClientContext;
import cn.weforward.protocol.aio.ClientHandler;
import cn.weforward.protocol.aio.ServerHandlerFactory;
import cn.weforward.protocol.aio.http.QueryStringParser;
import cn.weforward.protocol.aio.netty.NettyWebSocketFactory;
import cn.weforward.protocol.client.netty.AbstractNettyServiceInvoker;
import cn.weforward.protocol.ext.Producer;
import java.io.IOException;

public class NettyWebSocketInvoker
extends AbstractNettyServiceInvoker {
    protected static final NettyWebSocketFactory FACTORY = new NettyWebSocketFactory(true);
    protected String m_Url;
    protected Handler m_Handler;
    protected ServerHandlerFactory m_ServiceHandler;
    protected String m_ServiceName;
    protected int m_RetryDelay;

    public NettyWebSocketInvoker(ServerHandlerFactory serviceHandler, String url, Producer producer) {
        super(producer);
        this.m_Url = url;
        this.m_ServiceHandler = serviceHandler;
        this.m_RetryDelay = 30;
        int idx = url.indexOf(63);
        if (idx > 3) {
            DictionaryExt<String, String> params = QueryStringParser.toParams(url.substring(idx + 1));
            String v = (String)params.get((Object)"retry_delay");
            this.m_RetryDelay = NumberUtil.toInt((String)v, (int)this.m_RetryDelay);
        }
    }

    public void setServiceName(String name) {
        this.m_ServiceName = name;
    }

    @Override
    public String getServiceName() {
        return this.m_ServiceName;
    }

    @Override
    public int getConnectTimeout() {
        return FACTORY.getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int ms) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ClientChannel open() throws IOException {
        Handler handler = this.m_Handler;
        if (handler != null) {
            return handler;
        }
        NettyWebSocketInvoker nettyWebSocketInvoker = this;
        synchronized (nettyWebSocketInvoker) {
            handler = this.m_Handler;
            if (handler != null) {
                return handler;
            }
            handler = new Handler();
            handler.setRetryDelay(this.m_RetryDelay);
            FACTORY.connect(this.m_ServiceHandler, this.m_Url, handler);
            this.m_Handler = handler;
        }
        handler.waitReady(this.getConnectTimeout());
        return handler;
    }

    @Override
    protected String getServiceUrl(String serviceName) {
        return serviceName;
    }

    class Handler
    extends NettyWebSocketFactory.Keepalive
    implements ClientChannel {
        ClientChannel m_Channel;

        Handler() {
        }

        @Override
        public synchronized void establish(ClientChannel channel) {
            this.m_Channel = channel;
            super.establish(channel);
            this.notifyAll();
        }

        public synchronized void waitReady(int connectTimeout) {
            if (this.m_Channel != null) {
                return;
            }
            try {
                this.wait(connectTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public ClientContext request(ClientHandler handler, String uri, String verb) throws IOException {
            if (this.m_Channel == null) {
                throw new IOException("no connect");
            }
            return this.m_Channel.request(handler, uri, verb);
        }

        @Override
        public void close() {
            this.m_Channel.close();
        }

        @Override
        public boolean isValid() {
            return this.m_Channel != null;
        }
    }
}

