/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client.proxy;

import cn.weforward.common.ResultPage;
import cn.weforward.common.util.ClassUtil;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.client.FriendlyServiceInvoker;
import cn.weforward.protocol.client.ServiceInvokerFactory;
import cn.weforward.protocol.client.SimpleFriendlyServiceInvoker;
import cn.weforward.protocol.client.execption.GatewayException;
import cn.weforward.protocol.client.execption.MicroserviceException;
import cn.weforward.protocol.client.proxy.ServiceInvokerProxy;
import cn.weforward.protocol.ext.ObjectMapperSet;
import cn.weforward.protocol.support.NamingConverter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class JdkServiceInvokerProxy
implements ServiceInvokerProxy {
    protected SimpleFriendlyServiceInvoker m_Invoker;
    static final ConcurrentHashMap<String, ValueOf> GATEWAYEXCEPTION_VALUEOF = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, ValueOf> MICROSERVICEEXCEPTION_VALUEOF = new ConcurrentHashMap();
    static final ValueOf EMPTY_VALUEOF = new ValueOf();

    public JdkServiceInvokerProxy(String serviceName, String preUrl, String accessId, String accessKey) {
        this.m_Invoker = new SimpleFriendlyServiceInvoker(ServiceInvokerFactory.create(serviceName, preUrl, accessId, accessKey));
    }

    public void setMethodGroup(String methodGroup) {
        this.m_Invoker.setMethodGroup(methodGroup);
    }

    public void setMapperSet(ObjectMapperSet set) {
        this.m_Invoker.setMapperSet(set);
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = JdkServiceInvokerProxy.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    private Class<?> forName(String myInterface) throws ClassNotFoundException {
        return Class.forName(myInterface, true, JdkServiceInvokerProxy.getDefaultClassLoader());
    }

    @Override
    public <E> E newProxy(String myInterface) {
        try {
            return (E)this.newProxy(this.forName(myInterface));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("\u627e\u4e0d\u5230" + myInterface + "\u7c7b");
        }
    }

    @Override
    public <E> E newProxy(Class<E> myInterface) {
        String clazzName = myInterface.getSimpleName();
        String methodGroup = clazzName.endsWith("Methods") ? String.valueOf(Character.toLowerCase(clazzName.charAt(0))) + clazzName.substring(1, clazzName.length() - 7) : String.valueOf(Character.toLowerCase(clazzName.charAt(0))) + clazzName.substring(1);
        methodGroup = String.valueOf(methodGroup) + "/";
        return this.newProxy(methodGroup, myInterface);
    }

    @Override
    public <E> E newProxy(String methodGroup, String myInterface) {
        try {
            return (E)this.newProxy(methodGroup, this.forName(myInterface));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("\u627e\u4e0d\u5230" + myInterface + "\u7c7b");
        }
    }

    @Override
    public <E> E newProxy(String methodGroup, Class<E> myInterface) {
        return this.newProxy(methodGroup, myInterface, JdkServiceInvokerProxy.getDefaultClassLoader());
    }

    public <E> E newProxy(String methodGroup, Class<E> myInterface, ClassLoader classLoader) {
        if (methodGroup != null) {
            methodGroup = NamingConverter.camelToWf(methodGroup);
        }
        MyInvocationHandler h = new MyInvocationHandler(methodGroup);
        return (E)Proxy.newProxyInstance(classLoader, new Class[]{myInterface}, (InvocationHandler)h);
    }

    private Exception onException(Class<?>[] exceptionTypes, MicroserviceException e) throws Throwable {
        return this.onException(exceptionTypes, e, MICROSERVICEEXCEPTION_VALUEOF);
    }

    private Exception onException(Class<?>[] exceptionTypes, GatewayException e) throws Throwable {
        return this.onException(exceptionTypes, e, GATEWAYEXCEPTION_VALUEOF);
    }

    private Exception onException(Class<?>[] exceptionTypes, Exception e, ConcurrentHashMap<String, ValueOf> map) throws Throwable {
        if (exceptionTypes != null) {
            Class<?>[] classArray = exceptionTypes;
            if (exceptionTypes.length != 0) {
                ValueOf old;
                Class<?> clazz = classArray[0];
                String key = clazz.getName();
                ValueOf value = map.get(key);
                if (value == null && (old = map.putIfAbsent(key, value = this.createValueOf(clazz, e))) != null) {
                    value = old;
                }
                return value.valueOf(e);
            }
        }
        return e;
    }

    private ValueOf createValueOf(Class<?> clazz, Exception exception) {
        try {
            Method m = clazz.getMethod("valueOf", exception.getClass());
            int mod = m.getModifiers();
            if (Modifier.isPublic(mod) && Modifier.isStatic(mod)) {
                return new ValueOf(m);
            }
        }
        catch (NoSuchMethodException | SecurityException exception2) {
            // empty catch block
        }
        return EMPTY_VALUEOF;
    }

    class MyInvocationHandler
    implements InvocationHandler {
        protected String m_MethodGroup;

        public MyInvocationHandler(String methodGroup) {
            this.m_MethodGroup = StringUtil.toString((Object)methodGroup);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            FriendlyServiceInvoker.Option option;
            Object params;
            String name = method.getName();
            String methodName = String.valueOf(this.m_MethodGroup) + NamingConverter.camelToWf(name);
            if (args == null || args.length == 0) {
                if (name.equals("toString")) {
                    return methodName;
                }
                if (name.equals("hashCode")) {
                    return methodName.hashCode();
                }
            } else if (args.length == 1 && name.equals("equals")) {
                if (this == args[0]) {
                    return true;
                }
                return false;
            }
            if (args == null) {
                params = null;
                option = null;
            } else if (args.length == 1) {
                if (args[0] instanceof FriendlyServiceInvoker.Option) {
                    option = (FriendlyServiceInvoker.Option)args[0];
                    params = null;
                } else {
                    option = null;
                    params = args[0];
                }
            } else if (args.length == 2) {
                params = args[0];
                option = (FriendlyServiceInvoker.Option)args[1];
            } else {
                throw new UnsupportedOperationException("\u683c\u5f0f\u5f02\u5e38\uff0c\u65b9\u6cd5\u53ea\u53c2\u6570\u53ea\u5141\u8bb8(params),(option),(params,option)\u4e09\u79cd");
            }
            Class<?> resultClass = method.getReturnType();
            Class componentClass = List.class.isAssignableFrom(resultClass) ? ClassUtil.find((Type)method.getGenericReturnType(), (int)0) : (ResultPage.class.isAssignableFrom(resultClass) ? ClassUtil.find((Type)method.getGenericReturnType(), (int)0) : null);
            try {
                return JdkServiceInvokerProxy.this.m_Invoker.invoke(methodName, params, resultClass, componentClass, option);
            }
            catch (GatewayException e) {
                throw JdkServiceInvokerProxy.this.onException(method.getExceptionTypes(), e);
            }
            catch (MicroserviceException e) {
                throw JdkServiceInvokerProxy.this.onException(method.getExceptionTypes(), e);
            }
        }
    }

    static class ValueOf {
        protected Method m_Method;

        public ValueOf() {
            this.m_Method = null;
        }

        public ValueOf(Method m) {
            this.m_Method = m;
        }

        public Exception valueOf(Exception exception) throws Throwable {
            try {
                return this.m_Method == null ? exception : (Exception)this.m_Method.invoke(null, exception);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

