/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client.proxy;

import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.client.proxy.JdkServiceInvokerProxy;
import cn.weforward.protocol.client.proxy.ServiceInvokerProxy;
import cn.weforward.protocol.ext.ObjectMapperSet;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceInvokerProxyFactory {
    private ConcurrentHashMap<NameAndGroup, ServiceInvokerProxy> m_Services = new ConcurrentHashMap();
    protected String m_PreUrl;
    protected String m_AccessId;
    protected String m_AccessKey;

    public ServiceInvokerProxyFactory(String preUrl, String accessId, String accessKey) {
        this.m_PreUrl = preUrl;
        this.m_AccessId = accessId;
        this.m_AccessKey = accessKey;
    }

    public ServiceInvokerProxy openProxy(String serviceName) {
        return this.openProxy(serviceName, "");
    }

    public ServiceInvokerProxy openProxy(String serviceName, String methodGroup) {
        return this.openProxy(serviceName, methodGroup, null);
    }

    public ServiceInvokerProxy openProxy(String serviceName, String methodGroup, ObjectMapperSet set) {
        NameAndGroup key = new NameAndGroup(serviceName, methodGroup);
        ServiceInvokerProxy proxy = this.m_Services.get(key);
        if (proxy == null) {
            JdkServiceInvokerProxy jdk = new JdkServiceInvokerProxy(serviceName, this.m_PreUrl, this.m_AccessId, this.m_AccessKey);
            jdk.setMethodGroup(methodGroup);
            jdk.setMapperSet(set);
            ServiceInvokerProxy old = this.m_Services.putIfAbsent(key, jdk);
            proxy = old != null ? old : jdk;
        }
        return proxy;
    }

    public <E> E newProxy(String serviceName, String methodGroup, String myInterface) {
        return this.openProxy(serviceName, methodGroup, null).newProxy(myInterface);
    }

    class NameAndGroup {
        public String serviceName;
        public String methodGroup;

        public NameAndGroup(String serviceName, String methodGroup) {
            this.serviceName = serviceName;
            this.methodGroup = StringUtil.toString((Object)methodGroup);
        }

        public int hashCode() {
            return this.serviceName.hashCode() + 31 * this.methodGroup.hashCode();
        }

        public boolean equals(Object v) {
            if (v instanceof NameAndGroup) {
                return StringUtil.eq((String)this.serviceName, (String)((NameAndGroup)v).serviceName) && StringUtil.eq((String)this.methodGroup, (String)((NameAndGroup)v).methodGroup);
            }
            return false;
        }
    }
}

