/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client.proxy;

import cn.weforward.common.sys.ClockTick;
import cn.weforward.common.sys.StackTracer;
import cn.weforward.protocol.client.proxy.VoProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVoProxy<V>
implements VoProxy<V> {
    static final Logger _Logger = LoggerFactory.getLogger(SimpleVoProxy.class);
    protected static final int TIMESTAMP_EXPIRED = -2147483647;
    protected static final int TIMESTAMP_WEAK_EXPIRED = -2147483646;
    private static final ClockTick _Tick = ClockTick.getInstance((double)0.1);
    protected String m_Key;
    protected V m_Vo;
    protected VoProxy.ServiceInfo m_ServiceInfo;
    private int m_Expiry;
    private volatile long m_Timestamp;
    protected VoProxy.VoLoader<V> m_Loader;

    public SimpleVoProxy(String key, int expiry, VoProxy.VoLoader<V> loader) {
        this.m_Key = key;
        this.m_Expiry = expiry;
        this.m_Loader = loader;
    }

    @Override
    public String getKey() {
        return this.m_Key;
    }

    public int getExpiry() {
        return this.m_Expiry;
    }

    public V getVoFast() {
        return this.m_Vo;
    }

    public long getTimestamp() {
        return this.m_Timestamp;
    }

    protected boolean checkExpiry() {
        int expiry = this.getExpiry();
        if (expiry == 0) {
            return false;
        }
        long ts = this.getTimestamp();
        long tk = _Tick.getMills();
        return tk > ts + (long)expiry;
    }

    @Override
    public V getVo() {
        V v = null;
        if (-2147483647L != this.m_Timestamp) {
            v = this.m_Vo;
            if (-2147483646L != this.m_Timestamp && v != null && !this.checkExpiry()) {
                return v;
            }
        }
        V old = this.getVoFast();
        VoProxy.ServiceInfo info = this.m_ServiceInfo;
        try {
            VoProxy.LoadResult<V> res = this.remoteLoad(this.getKey(), old, info);
            if (res == null) {
                this.updateVo(null, null);
            } else {
                this.updateVo(res.vo, res.info);
            }
        }
        catch (Throwable e) {
            if (v == null) {
                _Logger.warn("\u65e0\u6cd5\u83b7\u53d6[" + this.m_Key + "]VO");
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            this.m_Timestamp = _Tick.getMills();
            StringBuilder sb = new StringBuilder(512);
            sb.append("[").append(this.m_Key).append("]\u5237\u65b0\u5931\u8d25\u7ee7\u7eed\u4f7f\u7528\u65e7VO\t");
            StackTracer.printStackTrace((Throwable)e, (Appendable)sb);
            _Logger.warn(sb.toString());
        }
        v = this.m_Vo;
        return v;
    }

    protected VoProxy.LoadResult<V> remoteLoad(String key, V old, VoProxy.ServiceInfo info) {
        return this.m_Loader.loadVo(key, old, info);
    }

    @Override
    public void updateVo(V vo) {
        this.updateVo(vo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateVo(V vo, VoProxy.ServiceInfo info) {
        boolean isChanged = false;
        SimpleVoProxy simpleVoProxy = this;
        synchronized (simpleVoProxy) {
            if (vo != null) {
                boolean bl = isChanged = vo != this.m_Vo;
                if (isChanged) {
                    this.m_Vo = vo;
                }
            }
            this.m_ServiceInfo = info;
            this.m_Timestamp = _Tick.getMills();
            this.notifyAll();
        }
    }

    @Override
    public synchronized void expirePersistent() {
        this.m_Timestamp = -2147483647L;
    }

    @Override
    public synchronized void weakExpirePersistent() {
        this.m_Timestamp = -2147483646L;
    }

    public String toString() {
        return "{key:" + this.m_Key + ",v:" + this.getVoFast() + ",ts:" + this.getTimestamp() + "}";
    }
}

