/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client.proxy;

import cn.weforward.common.GcCleanable;
import cn.weforward.common.sys.GcCleaner;
import cn.weforward.common.util.LruCache;
import cn.weforward.protocol.client.proxy.VoProxy;
import cn.weforward.protocol.client.proxy.VoProxyFactory;
import cn.weforward.protocol.client.proxy.VoProxyHolder;

public abstract class VoProxyContainer<E, V>
implements LruCache.Loader<String, E>,
VoProxy.VoLoader<V>,
GcCleanable {
    protected LruCache<String, E> m_Cache;
    protected int m_Expiry;

    public VoProxyContainer(String name) {
        this.m_Cache = new LruCache(name);
        GcCleaner.register((GcCleanable)this);
        this.setExpiry(5000);
    }

    public void setNullTimeout(int seconds) {
        this.m_Cache.setNullTimeout(seconds);
    }

    public void setExpiry(int mills) {
        this.m_Expiry = mills;
        if (mills < 0) {
            mills = -mills;
        }
        if (mills > 0) {
            int ss = mills / 200;
            if (ss < 60) {
                ss = 60;
            }
            this.m_Cache.setTimeout(ss);
        }
    }

    public void setMaxCapacity(int maxCapacity) {
        this.m_Cache.setMaxCapacity(maxCapacity);
    }

    public E get(String key) {
        return (E)this.m_Cache.getHintLoad((Object)key, (LruCache.Loader)this);
    }

    public E get(String key, V vo) {
        return (E)this.m_Cache.getHintLoad((Object)key, (LruCache.Loader)new FastLoader(vo));
    }

    @Override
    public VoProxy.LoadResult<V> loadVo(String key, V old, VoProxy.ServiceInfo info) {
        return this.load(key, old, info);
    }

    public boolean expirePersistent(String id) {
        VoProxy proxy;
        Object e = this.m_Cache.get((Object)id);
        if (e instanceof VoProxyHolder && (proxy = ((VoProxyHolder)e).getProxy()) != null) {
            proxy.expirePersistent();
            return true;
        }
        return false;
    }

    public boolean weakExpirePersistent(String id) {
        VoProxy proxy;
        Object e = this.m_Cache.get((Object)id);
        if (e instanceof VoProxyHolder && (proxy = ((VoProxyHolder)e).getProxy()) != null) {
            proxy.weakExpirePersistent();
            return true;
        }
        return false;
    }

    public E load(String key, LruCache.CacheNode<String, E> node) {
        VoProxy proxyVo = VoProxyFactory.create(key, this.m_Expiry, this);
        Object vo = proxyVo.getVo();
        if (vo == null) {
            return null;
        }
        return this.create(key, proxyVo);
    }

    public void onGcCleanup(int policy) {
        this.m_Cache.onGcCleanup(policy);
    }

    public String toString() {
        return this.m_Cache.toString();
    }

    protected abstract E create(String var1, VoProxy<V> var2);

    protected abstract V load(String var1, V var2);

    protected VoProxy.LoadResult<V> load(String key, V old, VoProxy.ServiceInfo info) {
        V vo = this.load(key, old);
        return new VoProxy.LoadResult<V>(vo);
    }

    protected VoProxy<V> createVoProxy(String key) {
        return VoProxyFactory.create(key, this.m_Expiry, this);
    }

    class FastLoader
    implements LruCache.Loader<String, E> {
        V m_Vo;

        public FastLoader(V vo) {
            this.m_Vo = vo;
        }

        public E load(String key, LruCache.CacheNode<String, E> node) {
            VoProxy proxyVo = VoProxyContainer.this.createVoProxy(key);
            proxyVo.updateVo(this.m_Vo, null);
            if (proxyVo.getVo() == null) {
                return null;
            }
            return VoProxyContainer.this.create(key, proxyVo);
        }
    }
}

