/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.client.util;

import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtBoolean;
import cn.weforward.protocol.datatype.DtDate;
import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.ext.ObjectMapperSet;
import cn.weforward.protocol.support.BeanObjectMapper;
import cn.weforward.protocol.support.PageData;
import cn.weforward.protocol.support.datatype.SimpleDtBoolean;
import cn.weforward.protocol.support.datatype.SimpleDtDate;
import cn.weforward.protocol.support.datatype.SimpleDtList;
import cn.weforward.protocol.support.datatype.SimpleDtNumber;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.datatype.SimpleDtString;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MappedUtil {
    public static <E> E fromBase(Class<?> clazz, DtBase params) {
        return (E)MappedUtil.fromBase(clazz, null, params, null);
    }

    public static <E> E fromBase(Class<?> clazz, Class<?> component, DtBase params) {
        return (E)MappedUtil.fromBase(clazz, component, params, null);
    }

    public static Object fromBase(Class<?> clazz, Class<?> component, DtBase params, ObjectMapperSet set) {
        ObjectMapper<?> mapper;
        if (params == null) {
            if (Integer.TYPE.isAssignableFrom(clazz)) {
                return 0;
            }
            if (Double.TYPE.isAssignableFrom(clazz)) {
                return 0.0;
            }
            if (Long.TYPE.isAssignableFrom(clazz)) {
                return 0L;
            }
            if (Boolean.TYPE.isAssignableFrom(clazz)) {
                return false;
            }
            return null;
        }
        if (DtBase.class.isAssignableFrom(clazz)) {
            return params;
        }
        if (String.class.isAssignableFrom(clazz)) {
            if (params instanceof DtString) {
                return ((DtString)params).value();
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362:" + params + "=>" + clazz);
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            if (params instanceof DtNumber) {
                return (short)((DtNumber)params).valueInt();
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362:" + params + "=>" + clazz);
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            if (params instanceof DtNumber) {
                return ((DtNumber)params).valueInt();
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362:" + params + "=>" + clazz);
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            if (params instanceof DtNumber) {
                return ((DtNumber)params).valueDouble();
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362:" + params + "=>" + clazz);
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            if (params instanceof DtNumber) {
                return ((DtNumber)params).valueLong();
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362:" + params + "=>" + clazz);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            if (params instanceof DtDate) {
                return ((DtDate)params).valueDate();
            }
            if (params instanceof DtString) {
                try {
                    return DtDate.Formater.parse(((DtString)params).value());
                }
                catch (ParseException e) {
                    throw new UnsupportedOperationException("\u89e3\u6790\u6570\u636e\u5f02\u5e38:" + params);
                }
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362:" + params + "=>" + clazz);
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            if (params instanceof DtBoolean) {
                return ((DtBoolean)params).value();
            }
            if (params instanceof DtString) {
                String str = ((DtString)params).value();
                if ("true".equalsIgnoreCase(str)) {
                    return Boolean.TRUE;
                }
                if ("false".equalsIgnoreCase(str)) {
                    return Boolean.FALSE;
                }
                throw new UnsupportedOperationException("\u65e0\u6cd5\u5c06[" + params + "]\u8f6c\u4e3aBoolean/boolean\uff0c\u5fc5\u987b\u662f'false'\u6216'true'");
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362:" + params + "=>" + clazz);
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            if (params instanceof DtString) {
                return new BigInteger(((DtString)params).value());
            }
            if (params instanceof DtNumber) {
                return BigInteger.valueOf(((DtNumber)params).valueLong());
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362:" + params + "=>" + clazz);
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            if (params instanceof DtString) {
                return new BigDecimal(((DtString)params).value());
            }
            if (params instanceof DtNumber) {
                return BigDecimal.valueOf(((DtNumber)params).valueDouble());
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362:" + params + "=>" + clazz);
        }
        if (List.class.isAssignableFrom(clazz)) {
            if (params instanceof DtList) {
                if (component == null) {
                    throw new UnsupportedOperationException("\u8bf7\u4f7f\u7528@ResourceExt(component=xxx)\u6307\u5b9a");
                }
                DtList items = (DtList)params;
                Object[] elements = new Object[items.size()];
                int i = 0;
                while (i < items.size()) {
                    elements[i] = MappedUtil.fromBase(component, null, items.getItem(i), set);
                    ++i;
                }
                return Arrays.asList(elements);
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362:" + params + "=>" + clazz);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (params instanceof DtObject) {
                if (component == null) {
                    throw new UnsupportedOperationException("\u8bf7\u4f7f\u7528@ResourceExt(component=xxx)\u6307\u5b9a");
                }
                DtObject object = (DtObject)params;
                HashMap<String, Object> map = new HashMap<String, Object>();
                Enumeration<String> e = object.getAttributeNames();
                while (e.hasMoreElements()) {
                    String name = e.nextElement();
                    map.put(name, MappedUtil.fromBase(component, null, object.getAttribute(name), set));
                }
                return map;
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362:" + params + "=>" + clazz);
        }
        if (!(params instanceof DtObject)) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362:" + params + "=>" + clazz);
        }
        if (set != null && (mapper = set.getObjectMapper(clazz)) != null) {
            if (params instanceof DtObject) {
                return mapper.fromDtObject((DtObject)params);
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362:" + params + "=>" + clazz);
        }
        mapper = BeanObjectMapper.getInstance(clazz);
        return ((BeanObjectMapper)mapper).fromDtObject((DtObject)params);
    }

    public static DtBase toBase(Object val) {
        return MappedUtil.toBase(val, null);
    }

    public static DtBase toBase(Object val, ObjectMapperSet set) {
        ObjectMapper<?> mapper;
        if (val == null) {
            return null;
        }
        if (val instanceof DtBase) {
            return (DtBase)val;
        }
        if (val instanceof Boolean) {
            return SimpleDtBoolean.valueOf((Boolean)val);
        }
        if (val instanceof String) {
            return SimpleDtString.valueOf(StringUtil.toString((Object)val));
        }
        if (val instanceof Short) {
            return SimpleDtNumber.valueOf(((Short)val).shortValue());
        }
        if (val instanceof Integer) {
            return SimpleDtNumber.valueOf((Integer)val);
        }
        if (val instanceof Long) {
            return SimpleDtNumber.valueOf((Long)val);
        }
        if (val instanceof Float) {
            return SimpleDtNumber.valueOf(((Float)val).floatValue());
        }
        if (val instanceof Double) {
            return SimpleDtNumber.valueOf((Double)val);
        }
        if (val instanceof Date) {
            return SimpleDtDate.valueOf((Date)val);
        }
        if (val instanceof BigInteger) {
            return SimpleDtString.valueOf(val.toString());
        }
        if (val instanceof BigDecimal) {
            return SimpleDtString.valueOf(val.toString());
        }
        if (val instanceof Iterable) {
            ArrayList<DtBase> list = new ArrayList<DtBase>();
            for (Object v : (Iterable)val) {
                list.add(MappedUtil.toBase(v, set));
            }
            return SimpleDtList.valueOf(list);
        }
        if (val instanceof Iterator) {
            ArrayList<DtBase> list = new ArrayList<DtBase>();
            Iterator it = (Iterator)val;
            while (it.hasNext()) {
                list.add(MappedUtil.toBase(it.next(), set));
            }
            return SimpleDtList.valueOf(list);
        }
        if (val instanceof Collection) {
            ArrayList<DtBase> list = new ArrayList<DtBase>();
            for (Object v : (Collection)val) {
                list.add(MappedUtil.toBase(v, set));
            }
            return SimpleDtList.valueOf(list);
        }
        if (val instanceof Map) {
            SimpleDtObject map = new SimpleDtObject();
            for (Map.Entry e : ((Map)val).entrySet()) {
                Object v = e.getKey();
                String key = null;
                if (v != null) {
                    key = v.toString();
                }
                map.put(key, MappedUtil.toBase(e.getValue(), set));
            }
            return map;
        }
        if (val instanceof PageData) {
            PageData data = (PageData)val;
            SimpleDtObject object = new SimpleDtObject();
            object.put("count", data.getCount());
            object.put("page", data.getPage());
            object.put("page_size", data.getPageSize());
            object.put("page_count", data.getPageCount());
            object.put("pos", data.getPos());
            object.put("items", MappedUtil.toBase(data.getItems(), set));
            return object;
        }
        if (set != null && (mapper = set.getObjectMapper(val.getClass())) != null) {
            return mapper.toDtObject(val);
        }
        mapper = BeanObjectMapper.getInstance(val.getClass());
        return ((BeanObjectMapper)mapper).toDtObject(val);
    }

    protected static Object boxing(Object sourceObject, Class<?> sourceType, Class<?> targetType) {
        Object object;
        Method method;
        if (sourceObject == null) {
            return null;
        }
        String methodName = "valueOf";
        try {
            method = targetType.getMethod(methodName, sourceType);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ObjectMappingException(sourceType + "\u65e0" + methodName + "(" + sourceType + ")\u65b9\u6cd5");
        }
        try {
            object = method.invoke(null, sourceObject);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            throw new ObjectMappingException("\u8c03\u7528" + targetType + "." + method + "\u65b9\u6cd5\u5f02\u5e38", target);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ObjectMappingException("\u8c03\u7528" + targetType + "." + method + "\u65b9\u6cd5\u5f02\u5e38", e);
        }
        return object;
    }

    protected static Object unboxing(Object sourceObject, Class<?> sourceType, Class<?> targetType) {
        Object object;
        Method method;
        if (sourceObject == null) {
            return null;
        }
        String name = targetType.getSimpleName();
        String methodName = String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1) + "Value";
        try {
            method = sourceType.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ObjectMappingException(sourceType + "\u65e0" + methodName + "\u65b9\u6cd5");
        }
        try {
            object = method.invoke(sourceObject, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            throw new ObjectMappingException("\u8c03\u7528" + sourceType + "." + method + "\u65b9\u6cd5\u5f02\u5e38", target);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ObjectMappingException("\u8c03\u7528" + sourceType + "." + method + "\u65b9\u6cd5\u5f02\u5e38", e);
        }
        return object;
    }
}

