/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.gateway.http;

import cn.weforward.common.ResultPage;
import cn.weforward.common.crypto.Hex;
import cn.weforward.common.util.ListUtil;
import cn.weforward.common.util.StringUtil;
import cn.weforward.common.util.TransList;
import cn.weforward.common.util.TransResultPage;
import cn.weforward.protocol.Access;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.ServiceName;
import cn.weforward.protocol.client.ServiceInvoker;
import cn.weforward.protocol.client.ServiceInvokerFactory;
import cn.weforward.protocol.client.ext.RemoteResultPage;
import cn.weforward.protocol.client.ext.RequestInvokeObject;
import cn.weforward.protocol.client.ext.RequestInvokeParam;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.ext.ObjectMapperSet;
import cn.weforward.protocol.gateway.Keeper;
import cn.weforward.protocol.gateway.SearchServiceParams;
import cn.weforward.protocol.gateway.ServiceSummary;
import cn.weforward.protocol.gateway.exception.KeeperException;
import cn.weforward.protocol.gateway.vo.AccessExtVo;
import cn.weforward.protocol.gateway.vo.AccessExtWrap;
import cn.weforward.protocol.gateway.vo.AclTableItemVo;
import cn.weforward.protocol.gateway.vo.AclTableResourceVo;
import cn.weforward.protocol.gateway.vo.AclTableVo;
import cn.weforward.protocol.gateway.vo.AclTableWrap;
import cn.weforward.protocol.gateway.vo.RightTableItemVo;
import cn.weforward.protocol.gateway.vo.RightTableVo;
import cn.weforward.protocol.gateway.vo.RightTableWrap;
import cn.weforward.protocol.gateway.vo.ServiceExtVo;
import cn.weforward.protocol.gateway.vo.ServiceExtWrap;
import cn.weforward.protocol.gateway.vo.TrafficTableItemVo;
import cn.weforward.protocol.gateway.vo.TrafficTableVo;
import cn.weforward.protocol.gateway.vo.TrafficTableWrap;
import cn.weforward.protocol.ops.AccessExt;
import cn.weforward.protocol.ops.ServiceExt;
import cn.weforward.protocol.ops.secure.AclTable;
import cn.weforward.protocol.ops.secure.AclTableItem;
import cn.weforward.protocol.ops.secure.RightTable;
import cn.weforward.protocol.ops.secure.RightTableItem;
import cn.weforward.protocol.ops.traffic.TrafficTable;
import cn.weforward.protocol.ops.traffic.TrafficTableItem;
import cn.weforward.protocol.support.BeanObjectMapper;
import cn.weforward.protocol.support.SimpleObjectMapperSet;
import cn.weforward.protocol.support.datatype.FriendlyList;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;

public class HttpKeeper
implements Keeper {
    protected String m_AccessId;
    protected ServiceInvoker m_Invoker;
    protected ObjectMapperSet m_Mappers;

    public HttpKeeper(String preUrl, String secret) throws NoSuchAlgorithmException {
        this(preUrl, "GW-gateway-internal", Hex.encode((byte[])Access.Helper.secretToAccessKey(secret)));
    }

    public HttpKeeper(String preUrl, String accessId, String accessKey) {
        if (!StringUtil.isEmpty((String)accessId)) {
            accessId = accessId.trim();
        }
        if (!StringUtil.isEmpty((String)accessKey)) {
            accessKey = accessKey.trim();
        }
        this.m_AccessId = accessId;
        this.m_Invoker = ServiceInvokerFactory.create(ServiceName.KEEPER.name, preUrl, accessId, accessKey);
        SimpleObjectMapperSet mappers = new SimpleObjectMapperSet();
        mappers.register(BeanObjectMapper.getInstance(AccessExtVo.class));
        mappers.register(BeanObjectMapper.getInstance(RightTableVo.class));
        mappers.register(BeanObjectMapper.getInstance(RightTableItemVo.class));
        mappers.register(BeanObjectMapper.getInstance(TrafficTableVo.class));
        mappers.register(BeanObjectMapper.getInstance(TrafficTableItemVo.class));
        mappers.register(BeanObjectMapper.getInstance(AclTableVo.class));
        mappers.register(BeanObjectMapper.getInstance(AclTableItemVo.class));
        mappers.register(BeanObjectMapper.getInstance(AclTableResourceVo.class));
        this.m_Mappers = mappers;
    }

    public ServiceInvoker getInvoker() {
        return this.m_Invoker;
    }

    @Override
    public AccessExt getAccess(String id) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("get_access");
        invokeObj.putParams(RequestInvokeParam.valueOf("id", id));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        AccessExtVo vo = result.getObject("content", AccessExtVo.class, this.m_Mappers);
        return AccessExtWrap.valueof(vo);
    }

    @Override
    public ResultPage<AccessExt> listAccess(String kind, String group) {
        return this.listAccess(kind, group, null);
    }

    @Override
    public ResultPage<AccessExt> listAccess(String kind, String group, String keyword) {
        String method = "list_access";
        RequestInvokeParam[] params = new RequestInvokeParam[]{RequestInvokeParam.valueOf("kind", kind), RequestInvokeParam.valueOf("group", group), RequestInvokeParam.valueOf("keyword", keyword)};
        RemoteResultPage<AccessExtVo> rp = new RemoteResultPage<AccessExtVo>(AccessExtVo.class, this.getInvoker(), method, params);
        return new TransResultPage<AccessExt, AccessExtVo>(rp){

            protected AccessExt trans(AccessExtVo src) {
                return AccessExtWrap.valueof(src);
            }
        };
    }

    @Override
    public List<String> listAccessGroup(String kind) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("list_access_group", RequestInvokeParam.valueOf("kind", kind));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        FriendlyList groups = result.getFriendlyList("content");
        if (groups == null) {
            return Collections.emptyList();
        }
        return groups.toStringList();
    }

    Response invoke(RequestInvokeObject invokeObj) {
        return this.getInvoker().invoke(invokeObj.toDtObject());
    }

    @Override
    public AccessExt createAccess(String kind, String group, String summary) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("create_access", RequestInvokeParam.valueOf("kind", kind), RequestInvokeParam.valueOf("group", group), RequestInvokeParam.valueOf("summary", summary));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        AccessExtVo access = result.getObject("content", AccessExtVo.class, this.m_Mappers);
        return new AccessExtWrap(access);
    }

    private FriendlyObject checkResponse(Response resp) {
        if (resp.getResponseCode() != 0) {
            throw new KeeperException(resp);
        }
        FriendlyObject result = FriendlyObject.valueOf(resp.getServiceResult());
        int code = result.getInt("code", 0);
        if (code != 0) {
            throw new KeeperException(code, result.getString("msg"));
        }
        return result;
    }

    @Override
    public AccessExt updateAccess(String accessId, String summary, Boolean valid) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("update_access");
        invokeObj.putParam("id", accessId);
        if (!StringUtil.isEmpty((String)summary)) {
            invokeObj.putParam("summary", summary);
        }
        if (valid != null) {
            invokeObj.putParam("valid", valid.toString());
        }
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        AccessExtVo access = result.getObject("content", AccessExtVo.class, this.m_Mappers);
        return new AccessExtWrap(access);
    }

    @Override
    public ResultPage<String> listServiceName(String keyword) {
        return this.listServiceName(keyword, null);
    }

    @Override
    public ResultPage<String> listServiceName(String keyword, String accessGroup) {
        String method = "list_service_name";
        RequestInvokeParam[] params = new RequestInvokeParam[]{RequestInvokeParam.valueOf("keyword", keyword), RequestInvokeParam.valueOf("access_group", accessGroup)};
        return new RemoteResultPage(this.getInvoker(), method, params);
    }

    @Override
    public ResultPage<ServiceExt> listService(String name) {
        return this.listService(name, null);
    }

    @Override
    public ResultPage<ServiceExt> listService(String name, String accessGroup) {
        String method = "list_service";
        RequestInvokeParam[] params = new RequestInvokeParam[]{RequestInvokeParam.valueOf("name", name), RequestInvokeParam.valueOf("access_group", accessGroup)};
        RemoteResultPage<ServiceExtVo> rp = new RemoteResultPage<ServiceExtVo>(ServiceExtVo.class, this.getInvoker(), method, params);
        return new TransResultPage<ServiceExt, ServiceExtVo>(rp){

            protected ServiceExt trans(ServiceExtVo src) {
                return new ServiceExtWrap(src);
            }
        };
    }

    @Override
    public ResultPage<ServiceExt> searchService(SearchServiceParams searchParams) {
        String method = "search_service";
        RequestInvokeParam[] params = new RequestInvokeParam[]{RequestInvokeParam.valueOf("keyword", searchParams.getKeyword()), RequestInvokeParam.valueOf("running_id", searchParams.getRunningId())};
        RemoteResultPage<ServiceExtVo> rp = new RemoteResultPage<ServiceExtVo>(ServiceExtVo.class, this.getInvoker(), method, params);
        return new TransResultPage<ServiceExt, ServiceExtVo>(rp){

            protected ServiceExt trans(ServiceExtVo src) {
                return new ServiceExtWrap(src);
            }
        };
    }

    @Override
    public RightTable getRightTable(String name) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("get_right_table", RequestInvokeParam.valueOf("name", name));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        RightTableVo vo = result.getObject("content", RightTableVo.class, this.m_Mappers);
        return this.openRightTable(vo);
    }

    RightTable openRightTable(RightTableVo vo) {
        if (vo == null) {
            return null;
        }
        return new RightTableWrap(vo, this);
    }

    @Override
    public RightTable appendRightRule(String name, RightTableItem item) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("append_right_rule", this.m_Mappers);
        invokeObj.putParam("name", name);
        invokeObj.putParam("item", RightTableItemVo.valueOf(item));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        RightTableVo vo = result.getObject("content", RightTableVo.class, this.m_Mappers);
        return this.openRightTable(vo);
    }

    @Override
    public RightTable insertRightRule(String name, RightTableItem item, int index) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("insert_right_rule", this.m_Mappers);
        invokeObj.putParam("name", name);
        invokeObj.putParam("item", RightTableItemVo.valueOf(item));
        invokeObj.putParam("index", index);
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        RightTableVo vo = result.getObject("content", RightTableVo.class, this.m_Mappers);
        return this.openRightTable(vo);
    }

    @Override
    public RightTable replaceRightRule(String name, RightTableItem item, int index, String replaceName) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("replace_right_rule", this.m_Mappers);
        invokeObj.putParams(RequestInvokeParam.valueOf("name", name), RequestInvokeParam.valueOf("index", index), RequestInvokeParam.valueOf("replace_name", replaceName));
        invokeObj.putParam("item", RightTableItemVo.valueOf(item));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        RightTableVo vo = result.getObject("content", RightTableVo.class, this.m_Mappers);
        return this.openRightTable(vo);
    }

    @Override
    public RightTable removeRightRule(String name, int index, String removeName) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("remove_right_rule");
        invokeObj.putParams(RequestInvokeParam.valueOf("name", name), RequestInvokeParam.valueOf("index", index), RequestInvokeParam.valueOf("remove_name", removeName));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        RightTableVo vo = result.getObject("content", RightTableVo.class, this.m_Mappers);
        return this.openRightTable(vo);
    }

    @Override
    public RightTable moveRightRule(String name, int from, int to) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("move_right_rule");
        invokeObj.putParams(RequestInvokeParam.valueOf("name", name), RequestInvokeParam.valueOf("from", from), RequestInvokeParam.valueOf("to", to));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        RightTableVo vo = result.getObject("content", RightTableVo.class, this.m_Mappers);
        return this.openRightTable(vo);
    }

    @Override
    public RightTable setRightRules(String name, List<RightTableItem> items) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("set_right_rules", this.m_Mappers);
        invokeObj.putParam("name", name);
        List<Object> vos = Collections.emptyList();
        if (!ListUtil.isEmpty(items)) {
            vos = new TransList<RightTableItemVo, RightTableItem>(items){

                protected RightTableItemVo trans(RightTableItem src) {
                    return RightTableItemVo.valueOf(src);
                }
            };
        }
        invokeObj.putParam("items", vos);
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        RightTableVo vo = result.getObject("content", RightTableVo.class, this.m_Mappers);
        return this.openRightTable(vo);
    }

    @Override
    public TrafficTable getTrafficTable(String name) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("get_traffic_table");
        invokeObj.putParams(RequestInvokeParam.valueOf("name", name));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        TrafficTableVo vo = result.getObject("content", TrafficTableVo.class, this.m_Mappers);
        return this.openTrafficTable(vo);
    }

    TrafficTable openTrafficTable(TrafficTableVo vo) {
        if (vo == null) {
            return null;
        }
        return new TrafficTableWrap(vo, this);
    }

    @Override
    public TrafficTable appendTrafficRule(String name, TrafficTableItem item) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("append_traffic_rule", this.m_Mappers);
        invokeObj.putParam("name", name);
        invokeObj.putParam("item", TrafficTableItemVo.valueOf(item));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        TrafficTableVo vo = result.getObject("content", TrafficTableVo.class, this.m_Mappers);
        return this.openTrafficTable(vo);
    }

    @Override
    public TrafficTable insertTrafficRule(String name, TrafficTableItem item, int index) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("insert_traffic_rule", this.m_Mappers);
        invokeObj.putParam("name", name);
        invokeObj.putParam("item", TrafficTableItemVo.valueOf(item));
        invokeObj.putParam("index", index);
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        TrafficTableVo vo = result.getObject("content", TrafficTableVo.class, this.m_Mappers);
        return this.openTrafficTable(vo);
    }

    @Override
    public TrafficTable replaceTrafficRule(String name, TrafficTableItem item, int index, String replaceName) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("replace_traffic_rule", this.m_Mappers);
        invokeObj.putParam("item", TrafficTableItemVo.valueOf(item));
        invokeObj.putParams(RequestInvokeParam.valueOf("name", name), RequestInvokeParam.valueOf("index", index), RequestInvokeParam.valueOf("replace_name", replaceName));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        TrafficTableVo vo = result.getObject("content", TrafficTableVo.class, this.m_Mappers);
        return this.openTrafficTable(vo);
    }

    @Override
    public TrafficTable removeTrafficRule(String name, int index, String removeName) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("remove_traffic_rule");
        invokeObj.putParams(RequestInvokeParam.valueOf("name", name), RequestInvokeParam.valueOf("index", index), RequestInvokeParam.valueOf("remove_name", removeName));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        TrafficTableVo vo = result.getObject("content", TrafficTableVo.class, this.m_Mappers);
        return this.openTrafficTable(vo);
    }

    @Override
    public TrafficTable moveTrafficRule(String name, int from, int to) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("move_traffic_rule");
        invokeObj.putParams(RequestInvokeParam.valueOf("name", name), RequestInvokeParam.valueOf("from", from), RequestInvokeParam.valueOf("to", to));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        TrafficTableVo vo = result.getObject("content", TrafficTableVo.class, this.m_Mappers);
        return this.openTrafficTable(vo);
    }

    @Override
    public TrafficTable setTrafficRules(String name, List<TrafficTableItem> items) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("set_traffic_rules", this.m_Mappers);
        invokeObj.putParam("name", name);
        List<Object> vos = Collections.emptyList();
        if (!ListUtil.isEmpty(items)) {
            vos = new TransList<TrafficTableItemVo, TrafficTableItem>(items){

                protected TrafficTableItemVo trans(TrafficTableItem src) {
                    return TrafficTableItemVo.valueOf(src);
                }
            };
        }
        invokeObj.putParam("items", vos);
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        TrafficTableVo vo = result.getObject("content", TrafficTableVo.class, this.m_Mappers);
        return this.openTrafficTable(vo);
    }

    @Override
    public AclTable getAclTable(String name) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("get_acl_table");
        invokeObj.putParams(RequestInvokeParam.valueOf("name", name));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        AclTableVo vo = result.getObject("content", AclTableVo.class, this.m_Mappers);
        return this.openAclTable(vo);
    }

    AclTable openAclTable(AclTableVo vo) {
        if (vo == null) {
            return null;
        }
        return new AclTableWrap(vo, this);
    }

    @Override
    public DtObject debugService(String serviceName, String serviceNo, String source, String name, String args) throws KeeperException {
        RequestInvokeObject invokeObj = new RequestInvokeObject("debug_service", RequestInvokeParam.valueOf("service_name", serviceName), RequestInvokeParam.valueOf("service_no", serviceNo), RequestInvokeParam.valueOf("script-source", source), RequestInvokeParam.valueOf("script-name", name), RequestInvokeParam.valueOf("script-args", args));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        return result.getObject("content");
    }

    @Override
    public ResultPage<ServiceSummary> listServiceSummary(String keyword) {
        return this.listServiceSummary(keyword, null);
    }

    @Override
    public ResultPage<ServiceSummary> listServiceSummary(String keyword, String accessGroup) {
        String method = "list_service_summary";
        RequestInvokeParam[] params = new RequestInvokeParam[]{RequestInvokeParam.valueOf("keyword", keyword), RequestInvokeParam.valueOf("access_group", accessGroup)};
        return new RemoteResultPage<ServiceSummary>(ServiceSummary.class, this.getInvoker(), method, params);
    }

    @Override
    public boolean isExistService(String name, String accessGroup) {
        RequestInvokeObject invokeObj = new RequestInvokeObject("is_exist_service");
        invokeObj.putParams(RequestInvokeParam.valueOf("name", name));
        invokeObj.putParams(RequestInvokeParam.valueOf("access_group", accessGroup));
        Response resp = this.invoke(invokeObj);
        FriendlyObject result = this.checkResponse(resp);
        return result.getBoolean("content", false);
    }

    @Override
    public AclTable appendAclRule(String name, AclTableItem item) {
        return null;
    }

    @Override
    public AclTable replaceAclRule(String name, AclTableItem item, int index, String replaceName) {
        return null;
    }

    @Override
    public AclTable removeAclRule(String name, int index, String removeName) {
        return null;
    }

    @Override
    public AclTable moveAclRule(String name, int from, int to) {
        return null;
    }
}

