/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.gateway.http;

import cn.weforward.common.ResultPage;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.Service;
import cn.weforward.protocol.ServiceName;
import cn.weforward.protocol.aio.ClientContext;
import cn.weforward.protocol.client.AioServiceInvoker;
import cn.weforward.protocol.client.ServiceInvoker;
import cn.weforward.protocol.client.ServiceInvokerFactory;
import cn.weforward.protocol.client.execption.ServiceInvokeException;
import cn.weforward.protocol.client.ext.RemoteResultPage;
import cn.weforward.protocol.client.ext.RequestInvokeParam;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.ext.ObjectMapperSet;
import cn.weforward.protocol.ext.ServiceRuntime;
import cn.weforward.protocol.gateway.ServiceRegister;
import cn.weforward.protocol.gateway.exception.ServiceRegisterException;
import cn.weforward.protocol.gateway.vo.ServiceVo;
import cn.weforward.protocol.support.BeanObjectMapper;
import cn.weforward.protocol.support.datatype.FriendlyObject;

public class HttpServiceRegister
implements ServiceRegister {
    protected ServiceInvoker m_Invoker;
    protected ObjectMapperSet m_Mappers;
    protected Listener m_Listener;

    public static String getServiceName() {
        return ServiceName.SERVICE_REGISTER.name;
    }

    public HttpServiceRegister(String preUrl, String accessId, String accessKey) {
        if (!StringUtil.isEmpty((String)accessId)) {
            accessId = accessId.trim();
        }
        if (!StringUtil.isEmpty((String)accessKey)) {
            accessKey = accessKey.trim();
        }
        this.m_Invoker = ServiceInvokerFactory.create(HttpServiceRegister.getServiceName(), preUrl, accessId, accessKey);
    }

    public HttpServiceRegister(ServiceInvoker invoker) {
        this.m_Invoker = invoker;
    }

    @Override
    public void registerService(Service service) {
        this.registerService(service, null);
    }

    @Override
    public void registerService(Service service, ServiceRuntime runtime) {
        if (service == null) {
            throw new NullPointerException();
        }
        ServiceVo vo = new ServiceVo(service);
        vo.setServiceRuntime(runtime);
        BeanObjectMapper<ServiceVo> mapper = BeanObjectMapper.getInstance(ServiceVo.class);
        DtObject params = mapper.toDtObject(vo);
        Request req = this.m_Invoker.createRequest("register", params);
        InvokeListener il = new InvokeListener(service, false);
        if (this.m_Invoker instanceof AioServiceInvoker) {
            ((AioServiceInvoker)this.m_Invoker).invoke(req, il);
            return;
        }
        try {
            try {
                Response resp = this.m_Invoker.invoke(req);
                il.success(req, resp);
            }
            catch (Exception e) {
                il.fail(req, e);
                il.complete(req);
            }
        }
        finally {
            il.complete(req);
        }
    }

    @Override
    public void unregisterService(Service service) {
        if (service == null) {
            throw new NullPointerException();
        }
        ServiceVo vo = new ServiceVo(service);
        BeanObjectMapper<ServiceVo> mapper = BeanObjectMapper.getInstance(ServiceVo.class);
        DtObject params = mapper.toDtObject(vo);
        Request req = this.m_Invoker.createRequest("unregister", params);
        InvokeListener il = new InvokeListener(service, true);
        try {
            try {
                Response resp = this.m_Invoker.invoke(req);
                il.success(req, resp);
            }
            catch (Exception e) {
                il.fail(req, e);
                il.complete(req);
            }
        }
        finally {
            il.complete(req);
        }
    }

    @Override
    public ResultPage<String> listServiceName(String keyword) {
        String method = "list_service_name";
        RequestInvokeParam[] params = new RequestInvokeParam[]{RequestInvokeParam.valueOf("keyword", keyword)};
        return new RemoteResultPage(this.m_Invoker, method, params);
    }

    private Listener getListener() {
        return this.m_Listener;
    }

    public void setListener(Listener listener) {
        this.m_Listener = listener;
    }

    class InvokeListener
    implements AioServiceInvoker.Listener {
        Service m_Service;
        boolean m_Offline;

        InvokeListener(Service service, boolean offline) {
            this.m_Service = service;
            this.m_Offline = offline;
        }

        @Override
        public void success(Request request, Response response) {
            Listener listener = HttpServiceRegister.this.getListener();
            if (listener == null) {
                return;
            }
            if (response.getResponseCode() != 0) {
                listener.fail(HttpServiceRegister.this, this.m_Service, new ServiceRegisterException(response));
                return;
            }
            FriendlyObject obj = FriendlyObject.valueOf(response.getServiceResult());
            int code = obj.getInt("code", 0);
            if (code != 0) {
                listener.fail(HttpServiceRegister.this, this.m_Service, new ServiceRegisterException(code, obj.getString("msg")));
                return;
            }
            if (this.m_Offline) {
                listener.offline(HttpServiceRegister.this, this.m_Service);
            } else {
                listener.success(HttpServiceRegister.this, this.m_Service);
            }
        }

        @Override
        public void fail(Request request, Throwable throwable) {
            ClientContext ctx;
            Listener listener = HttpServiceRegister.this.getListener();
            if (listener != null && !listener.fail(HttpServiceRegister.this, this.m_Service, throwable) && throwable instanceof ServiceInvokeException && (ctx = ((ServiceInvokeException)throwable).getContext()) != null) {
                ctx.disconnect();
            }
        }

        @Override
        public void complete(Request request) {
        }
    }

    public static interface Listener {
        public void success(ServiceRegister var1, Service var2);

        public void offline(ServiceRegister var1, Service var2);

        public boolean fail(ServiceRegister var1, Service var2, Throwable var3);
    }
}

