/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.gateway.vo;

import cn.weforward.protocol.gateway.Keeper;
import cn.weforward.protocol.gateway.vo.RightTableItemVo;
import cn.weforward.protocol.gateway.vo.RightTableItemWrap;
import cn.weforward.protocol.gateway.vo.RightTableVo;
import cn.weforward.protocol.ops.secure.RightTable;
import cn.weforward.protocol.ops.secure.RightTableItem;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;

public class RightTableWrap
implements RightTable {
    RightTableVo m_Vo;
    Keeper m_Keeper;

    public RightTableWrap(RightTableVo vo) {
        this(vo, null);
    }

    public RightTableWrap(RightTableVo vo, Keeper keeper) {
        this.m_Vo = vo;
        this.m_Keeper = keeper;
    }

    protected RightTableVo getVo() {
        return this.m_Vo;
    }

    public void setKeeper(Keeper keeper) {
        this.m_Keeper = keeper;
    }

    @Override
    public String getName() {
        return this.getVo().getName();
    }

    @Override
    public List<RightTableItem> getItems() {
        final List<RightTableItemVo> items = this.getVo().getItems();
        if (items == null || items.size() == 0) {
            return Collections.emptyList();
        }
        return new AbstractList<RightTableItem>(){

            @Override
            public RightTableItem get(int index) {
                return new RightTableItemWrap((RightTableItemVo)items.get(index));
            }

            @Override
            public int size() {
                return items.size();
            }
        };
    }

    @Override
    public void appendItem(RightTableItem item) {
        if (this.m_Keeper == null) {
            throw new IllegalStateException("\u5c1a\u672a\u6ce8\u5165Keeper");
        }
        RightTable table = this.m_Keeper.appendRightRule(this.getName(), item);
        this.m_Vo = RightTableVo.valueOf(table);
    }

    @Override
    public void insertItem(RightTableItem item, int index) {
        if (this.m_Keeper == null) {
            throw new IllegalStateException("\u5c1a\u672a\u6ce8\u5165Keeper");
        }
        RightTable table = this.m_Keeper.insertRightRule(this.getName(), item, index);
        this.m_Vo = RightTableVo.valueOf(table);
    }

    @Override
    public void replaceItem(RightTableItem item, int index, String name) {
        if (this.m_Keeper == null) {
            throw new IllegalStateException("\u5c1a\u672a\u6ce8\u5165Keeper");
        }
        RightTable table = this.m_Keeper.replaceRightRule(this.getName(), item, index, name);
        this.m_Vo = RightTableVo.valueOf(table);
    }

    @Override
    public void moveItem(int from, int to) {
        if (this.m_Keeper == null) {
            throw new IllegalStateException("\u5c1a\u672a\u6ce8\u5165Keeper");
        }
        RightTable table = this.m_Keeper.moveRightRule(this.getName(), from, to);
        this.m_Vo = RightTableVo.valueOf(table);
    }

    @Override
    public void removeItem(int index, String name) {
        if (this.m_Keeper == null) {
            throw new IllegalStateException("\u5c1a\u672a\u6ce8\u5165Keeper");
        }
        RightTable table = this.m_Keeper.removeRightRule(this.getName(), index, name);
        this.m_Vo = RightTableVo.valueOf(table);
    }

    @Override
    public void setItems(List<RightTableItem> items) {
        if (this.m_Keeper == null) {
            throw new IllegalStateException("\u5c1a\u672a\u6ce8\u5165Keeper");
        }
        RightTable table = this.m_Keeper.setRightRules(this.getName(), items);
        this.m_Vo = RightTableVo.valueOf(table);
    }
}

