/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.gateway.vo;

import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.gateway.vo.TrafficTableItemWrap;
import cn.weforward.protocol.ops.traffic.TrafficTableItem;

public class TrafficTableItemVo {
    public String name;
    public String serviceNo;
    public String serviceVersion;
    public int weight;
    public int maxFails;
    public int failTimeout;
    public int maxConcurrent;
    public int connectTimeout;
    public int readTimeout;

    public TrafficTableItemVo() {
    }

    public TrafficTableItemVo(TrafficTableItem item) {
        this.serviceNo = item.getServiceNo();
        this.serviceVersion = item.getServiceVersion();
        this.name = item.getName();
        this.weight = item.getWeight();
        this.maxFails = item.getMaxFails();
        this.failTimeout = item.getFailTimeout();
        this.maxConcurrent = item.getMaxConcurrent();
        this.connectTimeout = item.getConnectTimeout();
        this.readTimeout = item.getReadTimeout();
    }

    public TrafficTableItemVo(String no, String version) {
        this.serviceNo = no;
        this.serviceVersion = version;
        String name = !StringUtil.isEmpty((String)no) && !StringUtil.isEmpty((String)version) ? String.valueOf(no) + "_" + version : (!StringUtil.isEmpty((String)no) ? no : (!StringUtil.isEmpty((String)version) ? version : "_ALL_"));
        this.name = name;
        this.weight = 1;
        this.maxFails = 3;
        this.failTimeout = 180;
        this.maxConcurrent = 0;
        this.connectTimeout = 5;
        this.readTimeout = 50;
    }

    public static TrafficTableItemVo valueOf(TrafficTableItem item) {
        if (item == null) {
            return null;
        }
        if (item instanceof TrafficTableItemWrap) {
            return ((TrafficTableItemWrap)item).getVo();
        }
        return new TrafficTableItemVo(item);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServiceNo() {
        return this.serviceNo;
    }

    public void setServiceNo(String serviceNo) {
        this.serviceNo = serviceNo;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getMaxFails() {
        return this.maxFails;
    }

    public void setMaxFails(int maxFails) {
        this.maxFails = maxFails;
    }

    public int getFailTimeout() {
        return this.failTimeout;
    }

    public void setFailTimeout(int failTimeout) {
        this.failTimeout = failTimeout;
    }

    public int getMaxConcurrent() {
        return this.maxConcurrent;
    }

    public void setMaxConcurrent(int maxConcurrent) {
        this.maxConcurrent = maxConcurrent;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

