/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.gateway.vo;

import cn.weforward.protocol.gateway.Keeper;
import cn.weforward.protocol.gateway.vo.TrafficTableItemVo;
import cn.weforward.protocol.gateway.vo.TrafficTableItemWrap;
import cn.weforward.protocol.gateway.vo.TrafficTableVo;
import cn.weforward.protocol.ops.traffic.TrafficTable;
import cn.weforward.protocol.ops.traffic.TrafficTableItem;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;

public class TrafficTableWrap
implements TrafficTable {
    TrafficTableVo m_Vo;
    Keeper m_Keeper;

    public TrafficTableWrap(TrafficTableVo vo) {
        this(vo, null);
    }

    public TrafficTableWrap(TrafficTableVo vo, Keeper keeper) {
        this.m_Vo = vo;
        this.m_Keeper = keeper;
    }

    public TrafficTableVo getVo() {
        return this.m_Vo;
    }

    @Override
    public String getName() {
        return this.getVo().getName();
    }

    @Override
    public List<TrafficTableItem> getItems() {
        final List<TrafficTableItemVo> items = this.getVo().getItems();
        if (items == null || items.size() == 0) {
            return Collections.emptyList();
        }
        return new AbstractList<TrafficTableItem>(){

            @Override
            public TrafficTableItem get(int index) {
                return new TrafficTableItemWrap((TrafficTableItemVo)items.get(index));
            }

            @Override
            public int size() {
                return items.size();
            }
        };
    }

    @Override
    public void appendItem(TrafficTableItem item) {
        if (this.m_Keeper == null) {
            throw new IllegalStateException("\u5c1a\u672a\u6ce8\u5165Keeper");
        }
        TrafficTable table = this.m_Keeper.appendTrafficRule(this.getName(), item);
        this.m_Vo = TrafficTableVo.valueOf(table);
    }

    @Override
    public void insertItem(TrafficTableItem item, int index) {
        if (this.m_Keeper == null) {
            throw new IllegalStateException("\u5c1a\u672a\u6ce8\u5165Keeper");
        }
        TrafficTable table = this.m_Keeper.insertTrafficRule(this.getName(), item, index);
        this.m_Vo = TrafficTableVo.valueOf(table);
    }

    @Override
    public void replaceItem(TrafficTableItem item, int index, String name) {
        if (this.m_Keeper == null) {
            throw new IllegalStateException("\u5c1a\u672a\u6ce8\u5165Keeper");
        }
        TrafficTable table = this.m_Keeper.replaceTrafficRule(this.getName(), item, index, name);
        this.m_Vo = TrafficTableVo.valueOf(table);
    }

    @Override
    public void moveItem(int from, int to) {
        if (this.m_Keeper == null) {
            throw new IllegalStateException("\u5c1a\u672a\u6ce8\u5165Keeper");
        }
        TrafficTable table = this.m_Keeper.moveTrafficRule(this.getName(), from, to);
        this.m_Vo = TrafficTableVo.valueOf(table);
    }

    @Override
    public void removeItem(int index, String name) {
        if (this.m_Keeper == null) {
            throw new IllegalStateException("\u5c1a\u672a\u6ce8\u5165Keeper");
        }
        TrafficTable table = this.m_Keeper.removeTrafficRule(this.getName(), index, name);
        this.m_Vo = TrafficTableVo.valueOf(table);
    }

    @Override
    public void setItems(List<TrafficTableItem> items) {
        if (this.m_Keeper == null) {
            throw new IllegalStateException("\u5c1a\u672a\u6ce8\u5165Keeper");
        }
        TrafficTable table = this.m_Keeper.setTrafficRules(this.getName(), items);
        this.m_Vo = TrafficTableVo.valueOf(table);
    }
}

