/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.ops.trace;

import cn.weforward.common.crypto.Hex;
import cn.weforward.common.util.StringUtil;

public interface ServiceTraceToken {
    public static final char SPEARATOR = '-';
    public static final String SPEARATOR_STR = String.valueOf('-');
    public static final ThreadTraceToken TTT = new ThreadTraceToken();

    public String getToken();

    public String getTraceId();

    public String getSpanId();

    public String getParentId();

    public int getDepth();

    public static class Helper {
        public static String toTokenId(ServiceTraceToken token) {
            StringBuilder sb = new StringBuilder(100);
            sb.append(token.getTraceId()).append('-').append(token.getSpanId()).append('-');
            if (!StringUtil.isEmpty((String)token.getParentId())) {
                sb.append(token.getParentId()).append('-');
            }
            Hex.toHexFixed((byte)((byte)token.getDepth()), (StringBuilder)sb);
            return sb.toString();
        }

        public static String getTraceId(String token) {
            if (StringUtil.isEmpty((String)token)) {
                return null;
            }
            int idx = token.indexOf(45);
            if (-1 == idx) {
                return null;
            }
            return token.substring(0, idx);
        }

        public static String getSpanId(String token) {
            if (StringUtil.isEmpty((String)token)) {
                return null;
            }
            int bi = token.indexOf(45);
            if (-1 == bi) {
                return null;
            }
            int ei = token.indexOf(45, bi + 1);
            if (-1 == ei || ei - bi <= 1) {
                return null;
            }
            return token.substring(bi + 1, ei);
        }

        public static int getDepth(String token) {
            if (StringUtil.isEmpty((String)token)) {
                return 0;
            }
            int idx = token.lastIndexOf(45);
            if (-1 == idx || idx >= token.length() - 1) {
                return 0;
            }
            try {
                return Integer.parseInt(token.substring(idx + 1), 16);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
    }

    public static class ThreadTraceToken {
        ThreadLocal<String> m_TraceToken;

        ThreadTraceToken() {
        }

        public String put(String traceToken) {
            String old;
            if (StringUtil.isEmpty((String)traceToken) && this.m_TraceToken == null) {
                return null;
            }
            if (this.m_TraceToken == null) {
                this.m_TraceToken = new ThreadLocal();
                old = null;
            } else {
                old = this.m_TraceToken.get();
            }
            this.m_TraceToken.set(traceToken);
            return old;
        }

        public String get() {
            if (this.m_TraceToken == null) {
                return null;
            }
            return this.m_TraceToken.get();
        }
    }
}

