/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.serial;

import cn.weforward.common.execption.InvalidFormatException;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.serial.JsonParser;
import cn.weforward.protocol.support.datatype.AbstractDtList;
import java.io.IOException;
import java.util.List;

public class JsonDtList
extends AbstractDtList {
    protected String m_Json;
    protected int m_Offset;
    protected int m_Lenght;
    protected List<DtBase> m_Items;

    public JsonDtList(String json) {
        this(json, 0, json.length());
    }

    public JsonDtList(String json, int offset, int length) {
        this.m_Json = json;
        this.m_Offset = offset;
        this.m_Lenght = length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        if (this.m_Items != null) {
            return;
        }
        JsonDtList jsonDtList = this;
        synchronized (jsonDtList) {
            if (this.m_Items != null) {
                return;
            }
            try {
                this.m_Items = JsonParser.parseArray(this.m_Json, this.m_Offset, this.m_Lenght);
            }
            catch (IOException e) {
                throw new InvalidFormatException("Json\u4e32\u683c\u5f0f\u4e0d\u6b63\u786e", (Throwable)e);
            }
            this.m_Json = null;
        }
    }

    @Override
    public int size() {
        this.parse();
        return this.m_Items.size();
    }

    @Override
    protected DtBase getItemInner(int index) {
        this.parse();
        return this.m_Items.get(index);
    }

    public String getJsonString() {
        String json = this.m_Json;
        if (json == null) {
            return null;
        }
        if (this.m_Offset == 0 && this.m_Json.length() == this.m_Lenght) {
            return json;
        }
        return json.substring(this.m_Offset, this.m_Offset + this.m_Lenght);
    }

    public String toString() {
        List<DtBase> items;
        String str = this.getJsonString();
        if (str == null && (items = this.m_Items) != null) {
            str = items.toString();
        }
        return String.valueOf(this.type().toString()) + ' ' + str;
    }
}

