/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.serial;

import cn.weforward.common.KvPair;
import cn.weforward.common.execption.InvalidFormatException;
import cn.weforward.common.util.SimpleKvPair;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.serial.JsonParser;
import cn.weforward.protocol.support.datatype.AbstractDtObject;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JsonDtObject
extends AbstractDtObject {
    protected String m_Json;
    protected int m_Offset;
    protected int m_Lenght;
    protected Map<String, DtBase> m_Attributes;

    public JsonDtObject(String json) {
        this(json, 0, json.length());
    }

    public JsonDtObject(String json, int offset, int length) {
        this.m_Json = json;
        this.m_Offset = offset;
        this.m_Lenght = length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        if (this.m_Attributes != null) {
            return;
        }
        JsonDtObject jsonDtObject = this;
        synchronized (jsonDtObject) {
            if (this.m_Attributes != null) {
                return;
            }
            try {
                this.m_Attributes = JsonParser.parseObject(this.m_Json, this.m_Offset, this.m_Lenght);
            }
            catch (IOException e) {
                throw new InvalidFormatException("Json\u4e32\u683c\u5f0f\u4e0d\u6b63\u786e", (Throwable)e);
            }
            this.m_Json = null;
        }
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        this.parse();
        Set<String> keys = this.m_Attributes.keySet();
        return Collections.enumeration(keys);
    }

    @Override
    protected DtBase getAttributeInner(String name) {
        this.parse();
        return this.m_Attributes.get(name);
    }

    @Override
    public int getAttributeSize() {
        this.parse();
        return this.m_Attributes.size();
    }

    @Override
    public Enumeration<KvPair<String, DtBase>> getAttributes() {
        this.parse();
        if (this.m_Attributes.isEmpty()) {
            return Collections.emptyEnumeration();
        }
        final Iterator<Map.Entry<String, DtBase>> it = this.m_Attributes.entrySet().iterator();
        return new Enumeration<KvPair<String, DtBase>>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public KvPair<String, DtBase> nextElement() {
                Map.Entry entry = (Map.Entry)it.next();
                return SimpleKvPair.valueOf((Object)((String)entry.getKey()), (Object)((DtBase)entry.getValue()));
            }
        };
    }

    public String getJsonString() {
        String json = this.m_Json;
        if (json == null) {
            return null;
        }
        if (this.m_Offset == 0 && this.m_Json.length() == this.m_Lenght) {
            return json;
        }
        return json.substring(this.m_Offset, this.m_Offset + this.m_Lenght);
    }

    public String toString() {
        Map<String, DtBase> atts;
        String str = this.getJsonString();
        if (str == null && (atts = this.m_Attributes) != null) {
            str = atts.toString();
        }
        return String.valueOf(this.type().toString()) + ' ' + str;
    }
}

