/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.serial;

import cn.weforward.common.json.JsonObject;
import cn.weforward.common.json.JsonPair;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtDate;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.serial.JsonArrayAdapter;
import cn.weforward.protocol.support.datatype.SimpleDtBoolean;
import cn.weforward.protocol.support.datatype.SimpleDtDate;
import cn.weforward.protocol.support.datatype.SimpleDtNumber;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.datatype.SimpleDtString;
import java.text.ParseException;
import java.util.Date;

class JsonObjectAdapter
implements JsonObject.Appendable {
    SimpleDtObject m_Object;
    static final JsonObjectAdapter EMPTY = new JsonObjectAdapter(SimpleDtObject.empty());

    JsonObjectAdapter() {
        this(new SimpleDtObject(false));
    }

    JsonObjectAdapter(SimpleDtObject obj) {
        this.m_Object = obj;
    }

    public JsonPair property(String name) {
        JsonPair pair = new JsonPair(name, this.m_Object.getAttribute(name));
        return pair;
    }

    public int size() {
        return this.m_Object.getAttributeSize();
    }

    public Iterable<JsonPair> items() {
        throw new UnsupportedOperationException();
    }

    public void add(String name, Object value) {
        this.m_Object.put(name, JsonObjectAdapter.toDtBase(value));
    }

    static DtBase toDtBase(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return SimpleDtNumber.valueOf((Number)value);
        }
        if (value instanceof String) {
            try {
                Date date = DtDate.Formater.parse((String)value);
                if (date != null) {
                    return SimpleDtDate.valueOf(date);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return SimpleDtString.valueOf((String)value);
        }
        if (value instanceof Boolean) {
            return SimpleDtBoolean.valueOf((Boolean)value);
        }
        if (value instanceof JsonObjectAdapter) {
            return ((JsonObjectAdapter)value).getDtObject();
        }
        if (value instanceof JsonArrayAdapter) {
            return ((JsonArrayAdapter)value).getDtList();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\uff1a" + value);
    }

    DtObject getDtObject() {
        return this.m_Object;
    }
}

