/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.serial;

import cn.weforward.common.execption.InvalidFormatException;
import cn.weforward.common.json.JsonInput;
import cn.weforward.common.json.JsonUtil;
import cn.weforward.common.json.StringInput;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.protocol.RequestConstants;
import cn.weforward.protocol.ResponseConstants;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtBoolean;
import cn.weforward.protocol.serial.JsonDtList;
import cn.weforward.protocol.serial.JsonDtObject;
import cn.weforward.protocol.serial.JsonDtString;
import cn.weforward.protocol.support.datatype.SimpleDtBoolean;
import cn.weforward.protocol.support.datatype.SimpleDtNumber;
import cn.weforward.protocol.support.datatype.SimpleDtString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class JsonParser
extends JsonUtil {
    static final int SKIP_BLANK_LIMIT = 100;
    static final char INVALID_CHAR = '\uffff';

    JsonParser() {
    }

    /*
     * Unable to fully structure code
     */
    static Map<String, DtBase> parseObject(String str, int offset, int length) throws IOException {
        ctx = new Context(str, offset, length);
        ch = JsonUtil.skipBlank((JsonInput)ctx.in, (int)100);
        if ('{' != ch) {
            throw new InvalidFormatException("\u4e0d\u662f\u9884\u671f\u7684'" + ch + "' " + ctx.in);
        }
        ch = JsonUtil.skipBlank((JsonInput)ctx.in, (int)100);
        if ('}' == ch) {
            return Collections.emptyMap();
        }
        atts = new HashMap<String, DtBase>();
        while (ctx.in.available() >= 0) {
            nameBuilder = JsonUtil._NameBuilderPool.poll();
            try {
                nameQuot = ch;
                if ('\"' != nameQuot && '\'' != nameQuot) {
                    nameBuilder.append(nameQuot);
                    nameQuot = '\u0000';
                }
                while (true) {
                    if ('\\' == (ch = ctx.in.readChar())) {
                        JsonUtil.unescape((JsonInput)ctx.in, (Appendable)nameBuilder);
                        continue;
                    }
                    if (nameQuot == ch) break;
                    if (':' == ch && nameQuot == '\u0000') {
                        JsonUtil.rtrim((StringBuilder)nameBuilder);
                        break;
                    }
                    if (nameBuilder.length() == nameBuilder.capacity()) {
                        throw new InvalidFormatException("\u540d\u79f0\u8fc7\u957f(>128) " + ctx.in);
                    }
                    nameBuilder.append(ch);
                }
                name = JsonUtil._NamePool.intern((CharSequence)nameBuilder);
                if (true) ** GOTO lbl39
            }
            finally {
                JsonUtil._NameBuilderPool.offer(nameBuilder);
            }
            do {
                ch = ctx.in.readChar();
lbl39:
                // 2 sources

            } while (':' != ch);
            value = JsonParser.parseValue(ctx, name);
            if (!(RequestConstants.WF_REQ.equals(name) && atts.containsKey(name) || ResponseConstants.WF_RESP.equals(name) && atts.containsKey(name))) {
                atts.put(name, value);
            }
            if ('\uffff' != ctx.remainChar) {
                ch = ctx.remainChar;
                ctx.remainChar = (char)65535;
            } else {
                ch = JsonUtil.skipBlank((JsonInput)ctx.in, (int)100);
            }
            if (',' == ch) {
                ch = JsonUtil.skipBlank((JsonInput)ctx.in, (int)100);
                continue;
            }
            if ('}' == ch) break;
            if (']' != ch) continue;
            throw new InvalidFormatException("\u4e0d\u662f\u9884\u671f\u7684']' " + ctx.in);
        }
        return atts;
    }

    static List<DtBase> parseArray(String str, int offset, int length) throws IOException {
        Context ctx = new Context(str, offset, length);
        char ch = JsonUtil.skipBlank((JsonInput)ctx.in, (int)100);
        if ('[' != ch) {
            throw new InvalidFormatException("\u4e0d\u662f\u9884\u671f\u7684'" + ch + "' " + ctx.in);
        }
        ch = JsonUtil.skipBlank((JsonInput)ctx.in, (int)100);
        if (']' == ch) {
            return Collections.emptyList();
        }
        ctx.remainChar = ch;
        ArrayList<DtBase> ret = new ArrayList<DtBase>();
        while (ctx.in.available() >= 0) {
            DtBase value = JsonParser.parseValue(ctx, null);
            ret.add(value);
            if ('\uffff' != ctx.remainChar) {
                ch = ctx.remainChar;
                ctx.remainChar = (char)65535;
            } else {
                ch = JsonUtil.skipBlank((JsonInput)ctx.in, (int)100);
            }
            if (',' == ch) continue;
            if (']' == ch) break;
            if ('}' != ch) continue;
            throw new InvalidFormatException("\u4e0d\u662f\u9884\u671f\u7684'}' " + ctx.in);
        }
        return ret;
    }

    private static DtBase parseValue(Context ctx, String name) throws IOException {
        String v;
        char ch;
        char first;
        if ('\uffff' != ctx.remainChar) {
            ch = first = ctx.remainChar;
            ctx.remainChar = (char)65535;
        } else {
            ch = first = JsonUtil.skipBlank((JsonInput)ctx.in, (int)100);
        }
        int startIndex = ctx.in.position() - 1;
        StringBuilder valueBuilder = StringBuilderPool._8k.poll();
        try {
            if ('\"' == first || '\'' == first) {
                int si = -1;
                while (true) {
                    if ('\\' == (ch = ctx.in.readChar())) {
                        if (si >= 0) {
                            valueBuilder.append(ctx.in.getString(), si, ctx.in.position() - 1);
                        }
                        si = -2;
                        JsonUtil.unescape((JsonInput)ctx.in, (Appendable)valueBuilder);
                        continue;
                    }
                    if (first != '\u0000' && first == ch) break;
                    if (-1 == si) {
                        si = ctx.in.position() - 1;
                    }
                    if (si >= 0) continue;
                    valueBuilder.append(ch);
                }
                if (si < 0) {
                    String v2 = valueBuilder.toString();
                    SimpleDtString simpleDtString = SimpleDtString.valueOf(v2);
                    return simpleDtString;
                }
                JsonDtString jsonDtString = new JsonDtString(ctx.in.getString(), si, ctx.in.position() - 1);
                return jsonDtString;
            }
            if ('{' == first) {
                JsonDtObject ret;
                JsonParser.findEndChar(ctx.in, '{', '}');
                JsonDtObject jsonDtObject = ret = new JsonDtObject(ctx.in.getString(), startIndex, ctx.in.position() - startIndex);
                return jsonDtObject;
            }
            if ('[' == first) {
                JsonDtList ret;
                JsonParser.findEndChar(ctx.in, '[', ']');
                JsonDtList jsonDtList = ret = new JsonDtList(ctx.in.getString(), startIndex, ctx.in.position() - startIndex);
                return jsonDtList;
            }
            while (' ' != ch && '\r' != ch && '\n' != ch) {
                if (',' == ch || '}' == ch || ']' == ch) {
                    ctx.remainChar = ch;
                    break;
                }
                valueBuilder.append(Character.toLowerCase(ch));
                ch = ctx.in.readChar();
            }
            if (JsonUtil.equalsIgnoreCase((CharSequence)valueBuilder, (CharSequence)"true")) {
                DtBoolean dtBoolean = SimpleDtBoolean.TRUE;
                return dtBoolean;
            }
            if (JsonUtil.equalsIgnoreCase((CharSequence)valueBuilder, (CharSequence)"false")) {
                DtBoolean dtBoolean = SimpleDtBoolean.FALSE;
                return dtBoolean;
            }
            if (JsonUtil.equalsIgnoreCase((CharSequence)valueBuilder, (CharSequence)"null")) {
                return null;
            }
            v = valueBuilder.toString();
        }
        finally {
            StringBuilderPool._8k.offer(valueBuilder);
        }
        Number num = -1 != v.indexOf(46) ? (Number)Double.parseDouble(v) : (Number)Long.parseLong(v);
        return SimpleDtNumber.valueOf(num);
    }

    private static void findEndChar(StringInput in, char begin, char end) throws IOException {
        boolean escape = false;
        char quot = '\u0000';
        int flag = 0;
        while (true) {
            char ch = in.readChar();
            if (escape) {
                escape = false;
                continue;
            }
            if ('\\' == ch) {
                escape = true;
                continue;
            }
            if ('\"' == ch || '\'' == ch) {
                if (quot == '\u0000') {
                    quot = ch;
                    continue;
                }
                if (quot != ch) continue;
                quot = '\u0000';
                continue;
            }
            if (quot != '\u0000') continue;
            if (begin == ch) {
                ++flag;
                continue;
            }
            if (end != ch) continue;
            if (flag == 0) break;
            --flag;
        }
    }

    static class Context {
        StringInput in;
        char remainChar;

        Context(String str, int pos, int length) {
            this.in = new StringInput(str, pos, length);
            this.remainChar = (char)65535;
        }
    }
}

