/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.serial;

import cn.weforward.common.KvPair;
import cn.weforward.common.execption.InvalidFormatException;
import cn.weforward.common.io.BytesOutputStream;
import cn.weforward.common.json.JsonOutput;
import cn.weforward.common.json.JsonOutputStream;
import cn.weforward.common.json.JsonUtil;
import cn.weforward.common.util.Bytes;
import cn.weforward.protocol.datatype.DataType;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtBoolean;
import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.exception.SerialException;
import cn.weforward.protocol.serial.JsonDtList;
import cn.weforward.protocol.serial.JsonDtObject;
import cn.weforward.protocol.serial.SerialEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;

public class JsonSerialEngine
implements SerialEngine {
    @Override
    public String getType() {
        return "json";
    }

    @Override
    public void serial(DtObject object, String charset, OutputStream output) throws SerialException, IOException {
        if (!"utf-8".equalsIgnoreCase(charset)) {
            throw new SerialException("\u4e0d\u652f\u6301\u7684\u7f16\u7801\uff1a" + charset);
        }
        JsonOutputStream jos = new JsonOutputStream(output);
        JsonSerialEngine.formatObject(object, (JsonOutput)jos);
    }

    public static void formatObject(DtObject object, JsonOutput output) throws IOException {
        String json;
        if (object instanceof JsonDtObject && (json = ((JsonDtObject)object).getJsonString()) != null) {
            output.append((CharSequence)json);
            return;
        }
        output.append('{');
        boolean first = true;
        Enumeration<KvPair<String, DtBase>> atts = object.getAttributes();
        while (atts.hasMoreElements()) {
            KvPair<String, DtBase> att = atts.nextElement();
            if (first) {
                first = false;
            } else {
                output.append(',');
            }
            output.append('\"');
            JsonUtil.escape((CharSequence)((CharSequence)att.getKey()), (Appendable)output);
            output.append('\"');
            output.append(':');
            JsonSerialEngine.formatValue((DtBase)att.getValue(), output);
        }
        output.append('}');
    }

    public static void formatList(DtList list, JsonOutput output) throws IOException {
        String json;
        if (list instanceof JsonDtList && (json = ((JsonDtList)list).getJsonString()) != null) {
            output.append((CharSequence)json);
            return;
        }
        output.append('[');
        boolean first = true;
        Enumeration<DtBase> values = list.items();
        while (values.hasMoreElements()) {
            DtBase value = values.nextElement();
            if (first) {
                first = false;
            } else {
                output.append(',');
            }
            JsonSerialEngine.formatValue(value, output);
        }
        output.append(']');
    }

    public static void formatValue(DtBase value, JsonOutput output) throws IOException {
        if (value == null) {
            output.append((CharSequence)"null");
            return;
        }
        if (DataType.STRING == value.type() || DataType.DATE == value.type()) {
            DtString v = (DtString)value;
            output.append('\"');
            JsonUtil.escape((CharSequence)v.value(), (Appendable)output);
            output.append('\"');
            return;
        }
        if (DataType.NUMBER == value.type()) {
            DtNumber v = (DtNumber)value;
            output.append((CharSequence)v.valueNumber().toString());
            return;
        }
        if (DataType.BOOLEAN == value.type()) {
            DtBoolean v = (DtBoolean)value;
            if (v.value()) {
                output.append((CharSequence)"true");
            } else {
                output.append((CharSequence)"false");
            }
            return;
        }
        if (DataType.OBJECT == value.type()) {
            JsonSerialEngine.formatObject((DtObject)value, output);
            return;
        }
        if (DataType.LIST == value.type()) {
            JsonSerialEngine.formatList((DtList)value, output);
            return;
        }
        throw new InvalidFormatException("JSON\u503c\u7c7b\u578b\u4e0d\u652f\u6301" + value);
    }

    static void writeChar(OutputStream output, char ch, Charset charset) throws IOException {
        if (StandardCharsets.UTF_8 == charset) {
            output.write(ch);
        } else {
            output.write(String.valueOf(ch).getBytes(charset));
        }
    }

    @Override
    public DtObject unserial(InputStream in, String charset) throws SerialException, IOException {
        return JsonSerialEngine.parseObject(in, charset);
    }

    public static DtObject parseObject(InputStream in, String charset) throws SerialException, IOException {
        BytesOutputStream bos = null;
        try {
            bos = new BytesOutputStream(in);
            Bytes bytes = bos.getBytes();
            String json = new String(bytes.getBytes(), bytes.getOffset(), bytes.getSize(), charset);
            JsonDtObject jsonDtObject = new JsonDtObject(json);
            return jsonDtObject;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

