/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.serial;

import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.exception.SerialException;
import cn.weforward.protocol.serial.JsonSerialEngine;
import cn.weforward.protocol.serial.SerialEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Serializer {
    Map<String, SerialEngine> m_Engines = new ConcurrentHashMap<String, SerialEngine>();

    public void setEngines(List<SerialEngine> engines) {
        this.m_Engines.clear();
        if (engines == null || engines.isEmpty()) {
            return;
        }
        for (SerialEngine e : engines) {
            this.putEngine(e);
        }
    }

    public SerialEngine putEngine(SerialEngine engine) {
        return this.m_Engines.put(engine.getType().toLowerCase(), engine);
    }

    public SerialEngine getEngine(String type) {
        if (type == null || type.length() == 0) {
            return null;
        }
        SerialEngine e = this.m_Engines.get(type.toLowerCase());
        if (e == null) {
            if ("json".equals(type)) {
                e = new JsonSerialEngine();
            }
            if (e != null) {
                this.putEngine(e);
            }
        }
        return e;
    }

    public void serial(DtObject object, String contentType, String charset, OutputStream output) throws SerialException, IOException {
        SerialEngine engine = this.getEngine(contentType);
        if (engine == null) {
            throw new SerialException(1101, "\u4e0d\u652f\u6301\u7684\u683c\u5f0f:" + contentType);
        }
        engine.serial(object, charset, output);
    }

    public DtObject unserial(InputStream in, String contentType, String charset) throws SerialException, IOException {
        SerialEngine engine = this.getEngine(contentType);
        if (engine == null) {
            throw new SerialException(1101, "\u4e0d\u652f\u6301\u7684\u683c\u5f0f\uff1a" + contentType);
        }
        return engine.unserial(in, charset);
    }
}

