/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support;

import cn.weforward.protocol.datatype.DataType;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtBoolean;
import cn.weforward.protocol.datatype.DtDate;
import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.ext.ObjectMapperSet;
import cn.weforward.protocol.support.datatype.DataTypeConverter;
import cn.weforward.protocol.support.datatype.SimpleDtBoolean;
import cn.weforward.protocol.support.datatype.SimpleDtDate;
import cn.weforward.protocol.support.datatype.SimpleDtList;
import cn.weforward.protocol.support.datatype.SimpleDtNumber;
import cn.weforward.protocol.support.datatype.SimpleDtString;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;

public abstract class AbstractObjectMapper<E>
implements ObjectMapper<E> {
    protected ObjectMapperSet m_Mappers;

    protected AbstractObjectMapper() {
    }

    protected ObjectMapperSet getMappers() {
        return this.m_Mappers;
    }

    protected void setMappers(ObjectMapperSet mappers) {
        this.m_Mappers = mappers;
    }

    protected ObjectMapper<?> getObjectMapper(Class<?> clazz) {
        ObjectMapperSet mappers = this.getMappers();
        if (mappers == null) {
            return null;
        }
        return mappers.getObjectMapper(clazz);
    }

    protected ObjectMapper<?> getObjectMapper(String name) {
        ObjectMapperSet mappers = this.getMappers();
        if (mappers == null) {
            return null;
        }
        return mappers.getObjectMapper(name);
    }

    protected DtList toDtList(Iterable<?> items) {
        return (DtList)this.toDtBase(items);
    }

    protected DtBase toDtBase(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof DtBase) {
            return (DtBase)obj;
        }
        if (obj instanceof Byte || obj instanceof Short || obj instanceof Integer) {
            return SimpleDtNumber.valueOf(((Number)obj).intValue());
        }
        if (obj instanceof Long) {
            return SimpleDtNumber.valueOf(((Number)obj).longValue());
        }
        if (obj instanceof Float || obj instanceof Double) {
            return SimpleDtNumber.valueOf(((Number)obj).doubleValue());
        }
        if (obj instanceof String) {
            return SimpleDtString.valueOf((String)obj);
        }
        if (obj instanceof Date) {
            return SimpleDtDate.valueOf((Date)obj);
        }
        if (obj instanceof Boolean) {
            return SimpleDtBoolean.valueOf((Boolean)obj);
        }
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            if (coll.isEmpty()) {
                return DtList.EMPTY;
            }
            SimpleDtList list = new SimpleDtList(coll.size());
            for (Object o : coll) {
                list.addItem(this.toDtBase(o));
            }
            return list;
        }
        if (obj instanceof Iterable) {
            Iterable it = (Iterable)obj;
            SimpleDtList list = new SimpleDtList();
            for (Object o : it) {
                list.addItem(this.toDtBase(o));
            }
            return list;
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            if (len == 0) {
                return DtList.EMPTY;
            }
            SimpleDtList list = new SimpleDtList(len);
            int i = 0;
            while (i < len) {
                list.addItem(this.toDtBase(Array.get(obj, i)));
                ++i;
            }
            return list;
        }
        ObjectMapper<?> mapper = this.getObjectMapper(obj.getClass());
        if (mapper == null) {
            throw new ObjectMappingException("\u7f3a\u5c11[" + obj.getClass().getName() + "]\u7684Mapper");
        }
        return mapper.toDtObject(obj);
    }

    protected List<?> fromDtList(DtList list, Class<?> itemClazz) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return Collections.emptyList();
        }
        return this.fromDtList(list, (Type)itemClazz);
    }

    protected Object fromDtArray(DtList list, Class<?> arrayType) {
        if (list == null) {
            return null;
        }
        Class<?> componentType = arrayType.getComponentType();
        Object array = Array.newInstance(componentType, list.size());
        if (list.size() == 0) {
            return array;
        }
        int i = 0;
        while (i < list.size()) {
            DtBase b = list.getItem(i);
            Array.set(array, i, this.fromDtBase(b, (Type)componentType));
            ++i;
        }
        return array;
    }

    protected Object fromDtBase(DtBase value, Type type) throws ObjectMappingException {
        if (value == null) {
            return null;
        }
        if (type == null) {
            return this.fromDtBase(value);
        }
        if (DataType.LIST == value.type()) {
            DtList list = (DtList)value;
            if (type instanceof ParameterizedType) {
                Class cls;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type raw = parameterizedType.getRawType();
                if (raw instanceof Class && List.class.isAssignableFrom(cls = (Class)raw)) {
                    Type[] subs = parameterizedType.getActualTypeArguments();
                    if (subs.length == 0) {
                        return this.fromDtList(list, null);
                    }
                    return this.fromDtList(list, subs[0]);
                }
            } else if (type instanceof Class) {
                if (List.class.isAssignableFrom((Class)type)) {
                    return this.fromDtList(list, null);
                }
                if (((Class)type).isArray()) {
                    return this.fromDtArray(list, (Class)type);
                }
            }
        } else {
            ParameterizedType parameterizedType;
            Type raw;
            if (type instanceof Class) {
                return this.fromDtBase(value, (Class)type);
            }
            if (type instanceof ParameterizedType && (raw = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
                return this.fromDtBase(value, (Class)raw);
            }
        }
        throw new ObjectMappingException("\u4e0d\u652f\u6301\u6620\u5c04\u6b64\u7c7b\u578b\uff1a" + (Object)((Object)value.type()) + " -> " + type);
    }

    private List<?> fromDtList(DtList list, Type itemType) {
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        Enumeration<DtBase> items = list.items();
        while (items.hasMoreElements()) {
            DtBase e = items.nextElement();
            result.add(this.fromDtBase(e, itemType));
        }
        return result;
    }

    private Object fromDtBase(DtBase value) {
        DataType type = value.type();
        if (DataType.NUMBER == type) {
            DtNumber number = (DtNumber)value;
            if (number.isInt()) {
                return number.valueInt();
            }
            if (number.isLong()) {
                return number.valueLong();
            }
            return number.valueDouble();
        }
        if (DataType.STRING == type) {
            String str = ((DtString)value).value();
            if (str == null) {
                return null;
            }
            if (DtDate.Formater.check(str)) {
                try {
                    return DtDate.Formater.parse(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return str;
        }
        if (DataType.DATE == type) {
            return ((DtDate)value).valueDate();
        }
        if (DataType.BOOLEAN == type) {
            return ((DtBoolean)value).value();
        }
        if (DataType.LIST == type) {
            DtList list = (DtList)value;
            if (list.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> result = new ArrayList<Object>();
            Enumeration<DtBase> items = list.items();
            while (items.hasMoreElements()) {
                Object obj = this.fromDtBase(items.nextElement());
                result.add(obj);
            }
            return result;
        }
        throw new ObjectMappingException("\u672a\u77e5\u5bf9\u8c61\u7c7b\u578b\u65e0\u6cd5\u6620\u5c04");
    }

    private Object fromDtBase(DtBase value, Class<?> cls) throws ObjectMappingException {
        try {
            if (Byte.class.isAssignableFrom(cls) || Byte.TYPE.isAssignableFrom(cls)) {
                int i = ((DtNumber)value).valueInt();
                return (byte)i;
            }
            if (Short.class.isAssignableFrom(cls) || Short.TYPE.isAssignableFrom(cls)) {
                int i = ((DtNumber)value).valueInt();
                return (short)i;
            }
            if (Integer.class.isAssignableFrom(cls) || Integer.TYPE.isAssignableFrom(cls)) {
                return ((DtNumber)value).valueInt();
            }
            if (Long.class.isAssignableFrom(cls) || Long.TYPE.isAssignableFrom(cls)) {
                return ((DtNumber)value).valueLong();
            }
            if (Double.class.isAssignableFrom(cls) || Double.TYPE.isAssignableFrom(cls)) {
                return ((DtNumber)value).valueDouble();
            }
            if (Float.class.isAssignableFrom(cls) || Float.TYPE.isAssignableFrom(cls)) {
                double d = ((DtNumber)value).valueDouble();
                return Float.valueOf((float)d);
            }
            if (Number.class.isAssignableFrom(cls)) {
                return ((DtNumber)value).valueNumber();
            }
            if (String.class.isAssignableFrom(cls)) {
                return ((DtString)value).value();
            }
            if (Date.class.isAssignableFrom(cls)) {
                DtDate date = DataType.STRING == value.type() ? (DtDate)DataTypeConverter.convert(value, DataType.DATE) : (DtDate)value;
                return date.valueDate();
            }
            if (Boolean.class.isAssignableFrom(cls) || Boolean.TYPE.isAssignableFrom(cls)) {
                return ((DtBoolean)value).value();
            }
            DtObject obj = (DtObject)value;
            ObjectMapper<?> mapper = this.getObjectMapper(cls);
            if (mapper == null) {
                throw new ObjectMappingException("\u7f3a\u5c11[" + cls.getName() + "]\u7684Mapper");
            }
            return mapper.fromDtObject(obj);
        }
        catch (ClassCastException e) {
            throw new ObjectMappingException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362\uff1a" + (Object)((Object)value.type()) + " -> " + cls.getName());
        }
    }
}

