/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support;

import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapperSet;
import cn.weforward.protocol.support.AbstractObjectMapper;
import cn.weforward.protocol.support.BeanObjectMapperSet;
import cn.weforward.protocol.support.NamingConverter;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanObjectMapper<T>
extends AbstractObjectMapper<T>
implements Cloneable {
    static final Logger _Logger = LoggerFactory.getLogger(BeanObjectMapper.class);
    protected final Class<T> m_Clazz;
    protected final Constructor<T> m_Constructor;
    protected final Map<String, Method> m_GetMethods;
    protected final Map<String, Method> m_SetMethods;

    public static <T> BeanObjectMapper<T> getInstance(Class<T> clazz) {
        return BeanObjectMapperSet.INSTANCE.getObjectMapper(clazz);
    }

    private static <T> Constructor<T> getConstructor(Class<T> clazz) {
        try {
            Constructor<T> c = clazz.getDeclaredConstructor(new Class[0]);
            if (!c.isAccessible()) {
                c.setAccessible(true);
            }
            return c;
        }
        catch (NoSuchMethodException | SecurityException e) {
            _Logger.warn("[" + clazz.getName() + "]\u7f3a\u5c11\u65e0\u53c2\u6570\u6784\u9020\u65b9\u6cd5", (Throwable)e);
            return null;
        }
    }

    protected BeanObjectMapper(Class<T> clazz) {
        this.m_Clazz = clazz;
        this.m_Constructor = BeanObjectMapper.getConstructor(clazz);
        this.m_GetMethods = new HashMap<String, Method>();
        this.m_SetMethods = new HashMap<String, Method>();
        BeanObjectMapper.findMethods(clazz, this.m_SetMethods, this.m_GetMethods);
    }

    protected static void findMethods(Class<?> clazz, Map<String, Method> sets, Map<String, Method> gets) {
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String name = method.getName();
            if (name.startsWith("set")) {
                if (name.length() > 3 && Character.isUpperCase(name.charAt(3)) && 1 == method.getParameterTypes().length) {
                    name = NamingConverter.camelToWf(name, "set");
                    sets.put(name, method);
                }
            } else if (name.startsWith("get") && Character.isUpperCase(name.charAt(3)) && !"getClass".equals(name)) {
                if (name.length() > 3 && method.getParameterTypes().length == 0) {
                    name = NamingConverter.camelToWf(name, "get");
                    gets.put(name, method);
                }
            } else if (name.startsWith("is") && name.length() > 2 && method.getParameterTypes().length == 0) {
                name = NamingConverter.camelToWf(name, "is");
                gets.put(name, method);
            }
            ++n2;
        }
    }

    public BeanObjectMapper<T> clone(ObjectMapperSet mappers) {
        BeanObjectMapper copy;
        try {
            copy = (BeanObjectMapper)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        copy.setMappers(mappers);
        return copy;
    }

    @Override
    public String getName() {
        return this.m_Clazz.getName();
    }

    @Override
    public DtObject toDtObject(T object) throws ObjectMappingException {
        SimpleDtObject result = new SimpleDtObject(false);
        for (Map.Entry<String, Method> entry : this.m_GetMethods.entrySet()) {
            Object ret;
            Method method = entry.getValue();
            try {
                ret = method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new ObjectMappingException("\u65b9\u6cd5[" + method.getName() + "]\u8c03\u7528\u51fa\u9519", e);
            }
            DtBase att = this.toDtBase(ret);
            result.put(entry.getKey(), att);
        }
        return result;
    }

    @Override
    public T fromDtObject(DtObject obj) throws ObjectMappingException {
        T result;
        if (this.m_Constructor == null) {
            throw new ObjectMappingException("[" + this.m_Clazz.getName() + "]\u7f3a\u5c11\u65e0\u53c2\u6570\u6784\u9020\u65b9\u6cd5");
        }
        try {
            result = this.m_Constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new ObjectMappingException("\u521b\u5efa[" + this.m_Clazz.getName() + "]\u5bf9\u8c61\u5931\u8d25", e);
        }
        for (Map.Entry<String, Method> entry : this.m_SetMethods.entrySet()) {
            Object att = obj.getAttribute(entry.getKey());
            if (att == null) continue;
            Method method = entry.getValue();
            Class<?> cls = method.getParameterTypes()[0];
            Object arg = Collection.class.isAssignableFrom(cls) ? this.fromDtBase((DtBase)att, method.getGenericParameterTypes()[0]) : this.fromDtBase((DtBase)att, cls);
            try {
                method.invoke(result, arg);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new ObjectMappingException("\u65b9\u6cd5[" + method.getName() + "]\u8c03\u7528\u51fa\u9519", e);
            }
        }
        return result;
    }

    public String toString() {
        return "{" + this.m_Clazz + ":" + this.m_Constructor + ",gets:" + this.m_GetMethods.size() + ",sets:" + this.m_SetMethods.size() + "}";
    }
}

