/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support;

import cn.weforward.common.ResultPage;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class PageData
implements Closeable {
    static final PageData EMPTY = new PageData();
    protected int m_Count;
    protected int m_Page;
    protected int m_PageSize;
    protected int m_PageCount;
    protected Iterable<?> m_IterableItems;
    protected List<?> m_ListItems;
    protected int m_Pos = -1;

    PageData() {
        this.m_Count = 0;
        this.m_IterableItems = Collections.emptyList();
    }

    public PageData(ResultPage<?> rp) {
        this.m_Count = rp.getCount();
        this.m_Page = rp.getPage();
        this.m_PageSize = rp.getPageSize();
        this.m_PageCount = rp.getPageCount();
        this.m_IterableItems = rp;
    }

    public static PageData valueOf(ResultPage<?> rp) {
        if (rp.getCount() == 0) {
            return EMPTY;
        }
        return new PageData(rp);
    }

    public static PageData valueOf(int count, int page, int pageSize, int pageCount, List<?> items) {
        PageData data = new PageData();
        data.m_Count = count;
        data.m_Page = page;
        data.m_PageSize = pageSize;
        data.m_PageCount = pageCount;
        data.m_ListItems = items;
        return data;
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    public int getCount() {
        return this.m_Count;
    }

    public int getPage() {
        return this.m_Page;
    }

    public int getPageSize() {
        return this.m_PageSize;
    }

    public int getPageCount() {
        return this.m_PageCount;
    }

    public <E> Iterable<E> getItems() {
        if (this.m_ListItems != null) {
            return this.m_ListItems;
        }
        return this.m_IterableItems;
    }

    public int getItemSize() {
        if (this.m_ListItems == null) {
            throw new IllegalStateException();
        }
        return this.m_ListItems.size();
    }

    public int getPos() {
        if (-1 == this.m_Pos) {
            this.m_Pos = (this.m_Page - 1) * this.m_PageSize;
        }
        return this.m_Pos;
    }

    public <E> E getItem(int idx) {
        if (this.m_ListItems == null) {
            throw new IllegalStateException();
        }
        return (E)this.m_ListItems.get(idx);
    }

    @Override
    public void close() throws IOException {
        if (this.m_IterableItems instanceof Closeable) {
            ((Closeable)((Object)this.m_IterableItems)).close();
        }
    }
}

