/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support;

import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.ext.ObjectMapperSet;
import cn.weforward.protocol.support.AbstractObjectMapper;
import cn.weforward.protocol.support.BeanObjectMapperSet;
import cn.weforward.protocol.support.PageData;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import cn.weforward.protocol.support.datatype.SimpleDtObject;

public class PageDataMapper
extends AbstractObjectMapper<PageData> {
    protected Class<?> m_ElementClazz;
    protected ObjectMapper<?> m_ElementMapper;

    public PageDataMapper() {
    }

    public PageDataMapper(Class<?> elementClazz) {
        if (String.class == elementClazz) {
            return;
        }
        this.m_ElementClazz = elementClazz;
        this.setMappers(BeanObjectMapperSet.INSTANCE);
    }

    public PageDataMapper(ObjectMapperSet mappers) {
        this(null, mappers);
    }

    public PageDataMapper(Class<?> elementClazz, ObjectMapperSet mappers) {
        this.m_ElementClazz = elementClazz;
        this.setMappers(mappers);
    }

    public PageDataMapper(Class<?> elementClazz, ObjectMapper<?> mapper) {
        this.m_ElementClazz = elementClazz;
        this.m_ElementMapper = mapper;
    }

    @Override
    protected ObjectMapper<?> getObjectMapper(Class<?> clazz) {
        if (this.m_ElementMapper != null && clazz == this.m_ElementClazz) {
            return this.m_ElementMapper;
        }
        return super.getObjectMapper(clazz);
    }

    @Override
    public String getName() {
        return PageData.class.getSimpleName();
    }

    @Override
    public DtObject toDtObject(PageData data) throws ObjectMappingException {
        SimpleDtObject result = new SimpleDtObject(false);
        result.put("count", data.getCount());
        result.put("page", data.getPage());
        result.put("page_size", data.getPageSize());
        result.put("page_count", data.getPageCount());
        DtList items = this.toDtList(data.getItems());
        result.put("items", items);
        return result;
    }

    @Override
    public PageData fromDtObject(DtObject _obj) throws ObjectMappingException {
        FriendlyObject obj = FriendlyObject.valueOf(_obj);
        PageData data = new PageData();
        data.m_Count = obj.getInt("count", 0);
        data.m_Page = obj.getInt("page", 0);
        data.m_PageSize = obj.getInt("page_size", 0);
        data.m_PageCount = obj.getInt("page_count", 0);
        data.m_ListItems = this.fromDtList(obj.getList("items"), this.m_ElementClazz);
        return data;
    }
}

