/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support;

import cn.weforward.common.util.ClassUtil;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.ext.ObjectMapperSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleObjectMapperSet
implements ObjectMapperSet {
    Map<String, ObjectMapper<?>> m_ObjectMappers = new ConcurrentHashMap();

    public SimpleObjectMapperSet() {
        this.onInit();
    }

    protected void onInit() {
    }

    public void register(ObjectMapper<?> mapper) {
        this.register(mapper, mapper.getName());
    }

    @Override
    public void register(ObjectMapper<?> mapper, String name) {
        this.m_ObjectMappers.put(name, mapper);
    }

    @Override
    public <E> void register(ObjectMapper<? extends E> mapper, Class<E> clazz) {
        this.register(mapper, clazz.getName());
        String sn = ClassUtil.getSimpleName(clazz);
        if (this.getObjectMapper(sn) == null) {
            this.register(mapper, sn);
        }
    }

    public <E> void regsiter(ObjectMapper<? extends E> mapper, Class<E> clazz) {
        this.register(mapper, clazz.getName());
        String sn = ClassUtil.getSimpleName(clazz);
        if (this.getObjectMapper(sn) == null) {
            this.register(mapper, sn);
        }
    }

    @Override
    public ObjectMapper<?> getObjectMapper(String name) {
        return this.m_ObjectMappers.get(name);
    }

    @Override
    public <E> ObjectMapper<E> getObjectMapper(Class<E> clazz) {
        ObjectMapper<?> mapper = this.m_ObjectMappers.get(clazz.getName());
        if (mapper == null) {
            mapper = this.m_ObjectMappers.get(ClassUtil.getSimpleName(clazz));
        }
        return mapper;
    }

    @Override
    public Enumeration<ObjectMapper<?>> getMappers() {
        Collection<ObjectMapper<?>> mappers = this.m_ObjectMappers.values();
        return Collections.enumeration(mappers);
    }

    @Override
    public void registerAll(ObjectMapperSet set) {
        if (set == null) {
            return;
        }
        Enumeration<ObjectMapper<?>> mappers = set.getMappers();
        while (mappers.hasMoreElements()) {
            ObjectMapper<?> mapper = mappers.nextElement();
            this.register(mapper);
        }
    }

    @Override
    public ObjectMapper<?> unregister(String name) {
        return this.m_ObjectMappers.remove(name);
    }
}

