/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support;

import cn.weforward.common.Dictionary;
import cn.weforward.common.io.BytesOutputStream;
import cn.weforward.common.util.Bytes;
import cn.weforward.common.util.ListUtil;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.Access;
import cn.weforward.protocol.AccessLoader;
import cn.weforward.protocol.Header;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.RequestConstants;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.ResponseConstants;
import cn.weforward.protocol.aio.ClientContext;
import cn.weforward.protocol.aio.http.HttpContext;
import cn.weforward.protocol.aio.http.HttpHeaderHelper;
import cn.weforward.protocol.aio.http.HttpHeaderOutput;
import cn.weforward.protocol.auth.AuthEngine;
import cn.weforward.protocol.auth.AuthExceptionWrap;
import cn.weforward.protocol.auth.Auther;
import cn.weforward.protocol.auth.AutherOutputStream;
import cn.weforward.protocol.datatype.DataType;
import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.exception.AuthException;
import cn.weforward.protocol.exception.SerialException;
import cn.weforward.protocol.ext.Producer;
import cn.weforward.protocol.serial.SerialEngine;
import cn.weforward.protocol.serial.Serializer;
import cn.weforward.protocol.support.SimpleAccess;
import cn.weforward.protocol.support.SimpleRequest;
import cn.weforward.protocol.support.SimpleResponse;
import cn.weforward.protocol.support.datatype.SimpleDtList;
import cn.weforward.protocol.support.datatype.SimpleDtNumber;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.datatype.SimpleDtString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class SimpleProducer
implements Producer {
    protected AccessLoader m_AccessLoader;
    protected Auther m_Auther;
    protected Serializer m_Serializer;
    static final Comparator<String> COMP_REQ = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (RequestConstants.WF_REQ.equals(o1)) {
                return -1;
            }
            if (RequestConstants.WF_REQ.equals(o2)) {
                return 1;
            }
            return 0;
        }
    };
    protected static final Comparator<String> COMP_RESP = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (ResponseConstants.WF_RESP.equals(o1)) {
                return -1;
            }
            if (ResponseConstants.WF_RESP.equals(o2)) {
                return 1;
            }
            return 0;
        }
    };

    public SimpleProducer(AccessLoader loader) {
        this.m_AccessLoader = loader;
        this.m_Auther = new Auther(loader);
        this.m_Serializer = new Serializer();
    }

    public void setAuthEngines(List<AuthEngine> authEngines) {
        this.m_Auther.setEngines(authEngines);
    }

    public void setSerialEngines(List<SerialEngine> serialEngines) {
        this.m_Serializer.setEngines(serialEngines);
    }

    public Auther getAuther() {
        return this.m_Auther;
    }

    public Serializer getSerializer() {
        return this.m_Serializer;
    }

    protected DtObject toDtObject(Request request) {
        int marks;
        int waitTimeout;
        String traceToken;
        int resRight;
        String resId;
        String version;
        String addr;
        SimpleDtObject contentObj = new SimpleDtObject(false);
        contentObj.setAttributeComparator(COMP_REQ);
        SimpleDtObject reqObj = new SimpleDtObject(false);
        Access clientAccess = request.getAccess();
        if (clientAccess != null) {
            String openid;
            reqObj.put("client_access", SimpleDtString.valueOf(clientAccess.getAccessId()));
            String tenant = clientAccess.getTenant();
            if (!StringUtil.isEmpty((String)tenant)) {
                reqObj.put("tenant", tenant);
            }
            if (!StringUtil.isEmpty((String)(openid = clientAccess.getOpenid()))) {
                reqObj.put("openid", openid);
            }
        }
        if (!StringUtil.isEmpty((String)(addr = request.getAddr()))) {
            reqObj.put("client_addr", SimpleDtString.valueOf(addr));
        }
        if (!StringUtil.isEmpty((String)(version = request.getVersion()))) {
            reqObj.put("ver", SimpleDtString.valueOf(version));
        }
        if (!StringUtil.isEmpty((String)(resId = request.getResourceId()))) {
            reqObj.put("res_id", SimpleDtString.valueOf(resId));
        }
        if ((resRight = request.getResourceRight()) != 0) {
            reqObj.put("res_right", SimpleDtNumber.valueOf(resRight));
        }
        if (!StringUtil.isEmpty((String)(traceToken = request.getTraceToken()))) {
            reqObj.put("trace_token", traceToken);
        }
        if ((waitTimeout = request.getWaitTimeout()) != 0) {
            reqObj.put("wait_timeout", waitTimeout);
        }
        if ((marks = request.getMarks()) != 0) {
            reqObj.put("marks", marks);
        }
        contentObj.put(RequestConstants.WF_REQ, reqObj);
        contentObj.put("invoke", request.getServiceInvoke());
        return contentObj;
    }

    protected DtObject toDtObject(Response response) {
        int marks;
        List<String> notifyReceives;
        String forwardTo;
        String resUrl;
        SimpleDtObject contentObj = new SimpleDtObject(false);
        contentObj.setAttributeComparator(COMP_RESP);
        SimpleDtObject respObj = new SimpleDtObject(false);
        respObj.put(ResponseConstants.WF_CODE, SimpleDtNumber.valueOf(response.getResponseCode()));
        respObj.put(ResponseConstants.WF_MSG, SimpleDtString.valueOf(response.getResponseMsg()));
        String resId = response.getResourceId();
        if (!StringUtil.isEmpty((String)resId)) {
            String resServiceNo;
            respObj.put("res_id", SimpleDtString.valueOf(resId));
            respObj.put("res_expire", SimpleDtNumber.valueOf(response.getResourceExpire()));
            String resService = response.getResourceService();
            if (!StringUtil.isEmpty((String)resService)) {
                respObj.put("res_service", resService);
            }
            if (!StringUtil.isEmpty((String)(resServiceNo = response.getResourceServiceNo()))) {
                respObj.put("res_service_no", resServiceNo);
            }
        }
        if (!StringUtil.isEmpty((String)(resUrl = response.getResourceUrl()))) {
            respObj.put("res_url", SimpleDtString.valueOf(resUrl));
        }
        if (!StringUtil.isEmpty((String)(forwardTo = response.getForwardTo()))) {
            respObj.put("forward_to", forwardTo);
        }
        if (!ListUtil.isEmpty(notifyReceives = response.getNotifyReceives())) {
            SimpleDtList list = new SimpleDtList();
            for (String r : notifyReceives) {
                list.add(r);
            }
            respObj.put("notify_receives", list);
        }
        if ((marks = response.getMarks()) != 0) {
            respObj.put("marks", SimpleDtNumber.valueOf(marks));
        }
        contentObj.put(ResponseConstants.WF_RESP, respObj);
        contentObj.put("result", response.getServiceResult());
        return contentObj;
    }

    protected Response toResponse(Header header, DtObject contentObj) throws SerialException {
        try {
            DtNumber marks;
            DtList notifyReceives;
            DtString forwardTo;
            DtString resServiceNo;
            DtString resService;
            DtString resUrl;
            DtNumber resExpire;
            SimpleResponse response = new SimpleResponse(header);
            DtObject respObj = contentObj.getObject(ResponseConstants.WF_RESP);
            DtNumber hyCode = respObj.getNumber(ResponseConstants.WF_CODE);
            response.setResponseCode(hyCode.valueInt());
            DtString hyMsg = respObj.getString(ResponseConstants.WF_MSG);
            response.setResponseMsg(hyMsg.value());
            DtString resId = respObj.getString("res_id");
            if (resId != null) {
                response.setResourceId(resId.value());
            }
            if ((resExpire = respObj.getNumber("res_expire")) != null) {
                response.setResourceExpire(resExpire.valueLong());
            }
            if ((resUrl = respObj.getString("res_url")) != null) {
                response.setResourceUrl(resUrl.value());
            }
            if ((resService = respObj.getString("res_service")) != null) {
                response.setResourceService(resService.value());
            }
            if ((resServiceNo = respObj.getString("res_service_no")) != null) {
                response.setResourceServiceNo(resServiceNo.value());
            }
            if ((forwardTo = respObj.getString("forward_to")) != null) {
                response.setForwardTo(forwardTo.value());
            }
            if ((notifyReceives = respObj.getList("notify_receives")) != null) {
                ArrayList<String> list = new ArrayList<String>(notifyReceives.size());
                int i = 0;
                while (i < notifyReceives.size()) {
                    DtString str = (DtString)notifyReceives.getItem(i, DataType.STRING);
                    list.add(str.value());
                    ++i;
                }
                response.setNotifyReceives(list);
            }
            if ((marks = respObj.getNumber("marks")) != null) {
                response.setMarks(marks.valueInt());
            }
            DtObject serviceResult = contentObj.getObject("result");
            response.setServiceResult(serviceResult);
            return response;
        }
        catch (Exception e) {
            throw new SerialException(1101, "\u4e0d\u7b26\u5408Response\u6807\u51c6\u683c\u5f0f", e);
        }
    }

    protected Request toRequest(Header header, DtObject contentObj) throws SerialException {
        try {
            SimpleRequest request = new SimpleRequest(header);
            DtObject reqObj = contentObj.getObject(RequestConstants.WF_REQ);
            if (reqObj != null) {
                DtNumber marks;
                DtNumber waitTimeout;
                DtString traceToken;
                DtNumber resRight;
                DtString resId;
                DtString version;
                DtString addr;
                DtString clientAccess = reqObj.getString("client_access");
                if (clientAccess != null) {
                    DtString openid;
                    SimpleAccess acc = new SimpleAccess();
                    acc.setAccessId(clientAccess.value());
                    acc.setValid(true);
                    DtString tenant = reqObj.getString("tenant");
                    if (tenant != null) {
                        acc.setTenant(tenant.value());
                    }
                    if ((openid = reqObj.getString("openid")) != null) {
                        acc.setOpenid(openid.value());
                    }
                    request.setAccess(acc);
                }
                if ((addr = reqObj.getString("client_addr")) != null) {
                    request.setAddr(addr.value());
                }
                if ((version = reqObj.getString("ver")) != null) {
                    request.setVersion(version.value());
                }
                if ((resId = reqObj.getString("res_id")) != null) {
                    request.setResourceId(resId.value());
                }
                if ((resRight = reqObj.getNumber("res_right")) != null) {
                    request.setResourceRight(resRight.valueInt());
                }
                if ((traceToken = reqObj.getString("trace_token")) != null) {
                    request.setTraceToken(traceToken.value());
                }
                if ((waitTimeout = reqObj.getNumber("wait_timeout")) != null) {
                    request.setWaitTimeout(waitTimeout.valueInt());
                }
                if ((marks = reqObj.getNumber("marks")) != null) {
                    request.setMarks(marks.valueInt());
                }
            }
            DtObject serviceInvoke = contentObj.getObject("invoke");
            request.setServiceInvoke(serviceInvoke);
            return request;
        }
        catch (Exception e) {
            throw new SerialException(1101, "\u4e0d\u7b26\u5408Request\u6807\u51c6\u683c\u5f0f", e);
        }
    }

    @Override
    public void make(Request request, Producer.Output out) throws IOException, SerialException, AuthException {
        Header header = request.getHeader();
        AutherOutputStream auther = AutherOutputStream.getInstance(header.getAuthType());
        if (auther == null) {
            throw new AuthException(1003, "\u9a8c\u8bc1\u7c7b\u578b\u65e0\u6548\uff1a" + header.getAuthType());
        }
        auther.init(1, this.m_AccessLoader, false);
        auther.auth(header);
        auther.setTransferTo(out, out.getOutputStream());
        DtObject contentObj = this.toDtObject(request);
        try {
            this.m_Serializer.serial(contentObj, header.getContentType(), header.getCharset(), auther);
            auther.finish();
        }
        catch (AuthExceptionWrap e) {
            throw e.getCause();
        }
    }

    @Override
    public void make(Response response, Producer.Output out) throws IOException, SerialException, AuthException {
        Header header = response.getHeader();
        AutherOutputStream auther = AutherOutputStream.getInstance(header.getAuthType());
        if (auther == null) {
            throw new AuthException(1003, "\u9a8c\u8bc1\u7c7b\u578b\u65e0\u6548\uff1a" + header.getAuthType());
        }
        auther.init(1, this.m_AccessLoader, false);
        auther.auth(header);
        auther.setTransferTo(out, out.getOutputStream());
        DtObject contentObj = this.toDtObject(response);
        try {
            this.m_Serializer.serial(contentObj, header.getContentType(), header.getCharset(), auther);
            auther.finish();
        }
        catch (AuthExceptionWrap e) {
            throw e.getCause();
        }
    }

    @Override
    public Request fetchRequest(Producer.Input in) throws IOException, SerialException, AuthException {
        Header header = in.readHeader();
        DtObject obj = this.fetch(header, in);
        return this.toRequest(header, obj);
    }

    @Override
    public Response fetchResponse(Producer.Input in) throws IOException, SerialException, AuthException {
        Header header = in.readHeader();
        DtObject obj = this.fetch(header, in);
        return this.toResponse(header, obj);
    }

    DtObject fetch(Header header, Producer.Input in) throws IOException, SerialException, AuthException {
        AutherOutputStream auther = AutherOutputStream.getInstance(header.getAuthType());
        if (auther == null) {
            throw new AuthException(1003, "\u9a8c\u8bc1\u7c7b\u578b\u65e0\u6548\uff1a" + header.getAuthType());
        }
        auther.init(2, this.m_AccessLoader, false);
        auther.auth(header);
        BytesOutputStream bos = null;
        ByteArrayInputStream bis = null;
        try {
            bos = new BytesOutputStream();
            auther.setTransferTo(null, (OutputStream)bos);
            auther.write(in.getInputStream(), -1);
            auther.finish();
            Bytes bytes = bos.getBytes();
            bis = new ByteArrayInputStream(bytes.getBytes(), bytes.getOffset(), bytes.getSize());
            DtObject dtObject = this.m_Serializer.unserial(bis, header.getContentType(), header.getCharset());
            return dtObject;
        }
        catch (AuthExceptionWrap e) {
            throw e.getCause();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class HttpContextInput
    implements Producer.Input {
        HttpContext m_Context;
        String m_ServiceName;
        Header m_Header;

        public HttpContextInput(HttpContext ctx) {
            this.m_Context = ctx;
            this.m_ServiceName = HttpHeaderHelper.getServiceName(ctx.getUri());
        }

        public HttpContextInput(HttpContext ctx, String serviceName) {
            this.m_Context = ctx;
            this.m_ServiceName = serviceName;
        }

        @Override
        public Header readHeader() throws IOException {
            if (this.m_Header == null) {
                Header header = new Header(this.m_ServiceName);
                HttpHeaderHelper.fromHttpHeaders((Dictionary<String, String>)this.m_Context.getRequestHeaders(), header);
                this.m_Header = header;
            }
            return this.m_Header;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.m_Context.getRequestStream();
        }
    }

    public static class HttpContextOutput
    implements Producer.Output {
        HttpContext m_Context;
        OutputStream m_Output;

        public HttpContextOutput(HttpContext ctx, OutputStream output) {
            this.m_Context = ctx;
            this.m_Output = output;
        }

        @Override
        public void writeHeader(Header header) throws IOException {
            HttpHeaderHelper.responseHeaders(header, this.m_Context);
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.m_Output;
        }
    }

    public static class SimpleProducerInput
    implements Producer.Input {
        Dictionary<String, String> m_HttpHeaders;
        InputStream m_Input;
        String m_ServiceName;
        Header m_Header;

        public SimpleProducerInput(Dictionary<String, String> httpHeaders, InputStream input, String serviceName) {
            this.m_HttpHeaders = httpHeaders;
            this.m_Input = input;
            this.m_ServiceName = serviceName;
        }

        @Override
        public Header readHeader() throws IOException {
            if (this.m_Header == null) {
                Header header = new Header(this.m_ServiceName);
                HttpHeaderHelper.fromHttpHeaders(this.m_HttpHeaders, header);
                this.m_Header = header;
            }
            return this.m_Header;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.m_Input;
        }
    }

    public static class SimpleProducerOutput
    implements Producer.Output {
        HttpHeaderOutput m_HeaderOutput;
        OutputStream m_Output;

        public SimpleProducerOutput(ClientContext client, OutputStream output) {
            this.m_HeaderOutput = new HttpHeaderOutput.HttpClientOutput(client);
            this.m_Output = output;
        }

        public SimpleProducerOutput(HttpURLConnection client, OutputStream output) {
            this.m_HeaderOutput = new HttpHeaderOutput.HttpURLConnectionOutput(client);
            this.m_Output = output;
        }

        @Override
        public void writeHeader(Header header) throws IOException {
            HttpHeaderHelper.outHeaders(header, this.m_HeaderOutput);
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.m_Output;
        }
    }
}

