/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.datatype;

import cn.weforward.common.KvPair;
import cn.weforward.protocol.datatype.DataType;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtBoolean;
import cn.weforward.protocol.datatype.DtDate;
import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.support.datatype.DataTypeConverter;
import java.util.Collections;
import java.util.Enumeration;

public abstract class AbstractDtObject
implements DtObject {
    protected AbstractDtObject() {
    }

    @Override
    public DataType type() {
        return DataType.OBJECT;
    }

    @Override
    public <E extends DtBase> E getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public <E extends DtBase> E getAttribute(String name, DataType refType) {
        DtBase att = this.getAttributeInner(name);
        if (refType == null) {
            return (E)att;
        }
        return DataTypeConverter.convert(att, refType);
    }

    protected abstract DtBase getAttributeInner(String var1);

    @Override
    public Enumeration<KvPair<String, DtBase>> getAttributes() {
        final Enumeration<String> names = this.getAttributeNames();
        if (!names.hasMoreElements()) {
            return Collections.emptyEnumeration();
        }
        return new Enumeration<KvPair<String, DtBase>>(){

            @Override
            public KvPair<String, DtBase> nextElement() {
                final String name = (String)names.nextElement();
                return new KvPair<String, DtBase>(){

                    public String getKey() {
                        return name;
                    }

                    public DtBase getValue() {
                        return AbstractDtObject.this.getAttributeInner(name);
                    }
                };
            }

            @Override
            public boolean hasMoreElements() {
                return names.hasMoreElements();
            }
        };
    }

    @Override
    public DtString getString(String name) {
        return (DtString)this.getAttribute(name, DataType.STRING);
    }

    @Override
    public DtBoolean getBoolean(String name) {
        return (DtBoolean)this.getAttribute(name, DataType.BOOLEAN);
    }

    @Override
    public DtDate getDate(String name) {
        return (DtDate)this.getAttribute(name, DataType.DATE);
    }

    @Override
    public DtList getList(String name) {
        return (DtList)this.getAttribute(name, DataType.LIST);
    }

    @Override
    public DtObject getObject(String name) {
        return (DtObject)this.getAttribute(name, DataType.OBJECT);
    }

    @Override
    public DtNumber getNumber(String name) {
        return (DtNumber)this.getAttribute(name, DataType.NUMBER);
    }
}

