/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.datatype;

import cn.weforward.protocol.datatype.DataType;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtBoolean;
import cn.weforward.protocol.datatype.DtDate;
import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.exception.DataTypeCastExecption;
import cn.weforward.protocol.support.datatype.SimpleDtBoolean;
import cn.weforward.protocol.support.datatype.SimpleDtDate;
import cn.weforward.protocol.support.datatype.SimpleDtNumber;
import cn.weforward.protocol.support.datatype.SimpleDtString;

public class DataTypeConverter {
    public static <E extends DtBase> E convert(DtBase src, DataType type) {
        Object str;
        if (src == null) {
            return null;
        }
        if (type == null) {
            return (E)src;
        }
        if (src.type() == type) {
            return (E)src;
        }
        if (DataType.STRING == src.type()) {
            str = (DtString)src;
            if (DataType.DATE == type) {
                return (E)SimpleDtDate.valueOf(str.value());
            }
            if (DataType.NUMBER == type) {
                return (E)SimpleDtNumber.valueOf(str.value());
            }
            if (DataType.BOOLEAN == type) {
                return (E)SimpleDtBoolean.valueOf(str.value());
            }
        }
        if (DataType.STRING == type) {
            str = null;
            if (DataType.DATE == src.type()) {
                DtDate date = (DtDate)src;
                str = date.value();
            }
            if (DataType.BOOLEAN == src.type()) {
                DtBoolean bool = (DtBoolean)src;
                str = Boolean.toString(bool.value());
            }
            if (DataType.NUMBER == src.type()) {
                DtNumber num = (DtNumber)src;
                str = num.valueNumber().toString();
            }
            if (str != null) {
                return (E)SimpleDtString.valueOf((String)str);
            }
        }
        throw new DataTypeCastExecption("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362\uff1a" + (Object)((Object)src.type()) + " -> " + (Object)((Object)type));
    }
}

