/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.support.datatype;

import cn.weforward.protocol.datatype.DataType;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtBoolean;
import cn.weforward.protocol.datatype.DtDate;
import cn.weforward.protocol.datatype.DtList;
import cn.weforward.protocol.datatype.DtNumber;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.exception.DataTypeCastExecption;
import cn.weforward.protocol.exception.ObjectMappingException;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.ext.ObjectMapperSet;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class FriendlyList {
    static final FriendlyList NIL = new FriendlyList(null);
    static final int[] EMPTY_INT_ARRAY = new int[0];
    static final long[] EMPTY_LONG_ARRAY = new long[0];
    static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    protected final DtList m_List;
    protected final int m_Size;
    protected final boolean m_Suppress;

    public FriendlyList(DtList list) {
        this(list, false);
    }

    public FriendlyList(DtList list, boolean suppress) {
        this.m_List = list;
        this.m_Size = FriendlyList.sizeOf(list);
        this.m_Suppress = suppress;
    }

    public static FriendlyList valueOf(DtList list) {
        return FriendlyList.valueOf(list, false);
    }

    public static FriendlyList valueOf(DtList list, boolean suppress) {
        if (list == null || list.size() == 0) {
            return NIL;
        }
        return new FriendlyList(list, suppress);
    }

    public int size() {
        return this.m_Size;
    }

    public FriendlyObject getFriendlyObject(int index) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getFriendlyObject(this.m_List, index, this.m_Suppress);
    }

    public static FriendlyObject getFriendlyObject(DtList list, int index, boolean suppress) throws DataTypeCastExecption, IndexOutOfBoundsException {
        DtObject obj = FriendlyList.getObject(list, index, suppress);
        return FriendlyObject.valueOf(obj, suppress);
    }

    public DtObject getObject(int index) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return (DtObject)FriendlyList.getItem(this.m_List, index, DataType.OBJECT, this.m_Suppress);
    }

    public static DtObject getObject(DtList list, int index, boolean suppress) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return (DtObject)FriendlyList.getItem(list, index, DataType.OBJECT, suppress);
    }

    public <E> E getObject(int index, Class<E> clazz, ObjectMapperSet mappers) throws DataTypeCastExecption, ObjectMappingException, IndexOutOfBoundsException {
        DtObject obj = this.getObject(index);
        if (obj == null) {
            return null;
        }
        ObjectMapper<E> mapper = mappers.getObjectMapper(clazz);
        if (mapper == null) {
            throw new ObjectMappingException("\u4e0d\u652f\u6301\u6620\u5c04\u6b64\u7c7b\u578b\uff1a" + clazz);
        }
        return mapper.fromDtObject(obj);
    }

    public static <E> E getObject(DtList list, int index, ObjectMapper<E> mapper, boolean suppress) throws DataTypeCastExecption, IndexOutOfBoundsException {
        DtObject obj = FriendlyList.getObject(list, index, suppress);
        if (obj == null) {
            return null;
        }
        return mapper.fromDtObject(obj);
    }

    public FriendlyList getFriendlyList(int index) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getFriendlyList(this.m_List, index, this.m_Suppress);
    }

    public static FriendlyList getFriendlyList(DtList list, int index) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getFriendlyList(list, index, false);
    }

    public static FriendlyList getFriendlyList(DtList list, int index, boolean suppress) throws DataTypeCastExecption, IndexOutOfBoundsException {
        DtList sub = (DtList)FriendlyList.getItem(list, index, DataType.LIST, suppress);
        return FriendlyList.valueOf(sub, suppress);
    }

    public DtList getList(int index) throws DataTypeCastExecption {
        return (DtList)FriendlyList.getItem(this.m_List, index, DataType.LIST, this.m_Suppress);
    }

    public static DtList getList(DtList list, int index, boolean suppress) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return (DtList)FriendlyList.getItem(list, index, DataType.LIST, suppress);
    }

    public <E> List<E> getList(int index, Class<E> clazz, ObjectMapperSet mappers) throws ClassCastException, IndexOutOfBoundsException {
        final DtList list = this.getList(index);
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return Collections.emptyList();
        }
        final ObjectMapper<E> mapper = mappers.getObjectMapper(clazz);
        if (mapper == null) {
            throw new ObjectMappingException("\u4e0d\u652f\u6301\u6620\u5c04\u6b64\u7c7b\u578b\uff1a" + clazz);
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                DtObject obj = (DtObject)list.getItem(index);
                return mapper.fromDtObject(obj);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public <E> List<E> getList(int index, ObjectMapper<E> mapper) {
        return FriendlyList.getList(this.m_List, index, mapper, this.m_Suppress);
    }

    public static <E> List<E> getList(DtList list, int index, ObjectMapper<E> mapper) {
        return FriendlyList.getList(list, index, mapper, false);
    }

    public static <E> List<E> getList(DtList list, int index, final ObjectMapper<E> mapper, boolean suppress) throws DataTypeCastExecption, IndexOutOfBoundsException {
        final DtList sub = FriendlyList.getList(list, index, suppress);
        if (sub == null) {
            return null;
        }
        if (sub.size() == 0) {
            return Collections.emptyList();
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                DtObject obj = (DtObject)sub.getItem(index);
                return mapper.fromDtObject(obj);
            }

            @Override
            public int size() {
                return sub.size();
            }
        };
    }

    public <E> List<E> toList(Class<E> clazz, ObjectMapperSet mappers) {
        return FriendlyList.toList(this.m_List, clazz, mappers);
    }

    public static <E> List<E> toList(DtList list, Class<E> clazz, ObjectMapperSet mappers) {
        int size = FriendlyList.sizeOf(list);
        if (size == 0) {
            return Collections.emptyList();
        }
        ObjectMapper<E> mapper = mappers.getObjectMapper(clazz);
        if (mapper == null) {
            throw new ObjectMappingException("\u4e0d\u652f\u6301\u6620\u5c04\u6b64\u7c7b\u578b\uff1a" + clazz);
        }
        return FriendlyList.toList(list, mapper);
    }

    public <E> List<E> toList(ObjectMapper<E> mapper) {
        return FriendlyList.toList(this.m_List, mapper);
    }

    public static <E> List<E> toList(final DtList list, final ObjectMapper<E> mapper) {
        final int size = FriendlyList.sizeOf(list);
        if (size == 0) {
            return Collections.emptyList();
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                DtObject obj = (DtObject)list.getItem(index, DataType.OBJECT);
                return mapper.fromDtObject(obj);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public List<String> toStringList() {
        return FriendlyList.toStringList(this.m_List, this.m_Suppress);
    }

    public static List<String> toStringList(DtList list) {
        return FriendlyList.toStringList(list, false);
    }

    public static List<String> toStringList(final DtList list, final boolean suppress) {
        final int size = FriendlyList.sizeOf(list);
        if (size == 0) {
            return Collections.emptyList();
        }
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return FriendlyList.getString(list, index, suppress);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public List<Date> toDateList() {
        return FriendlyList.toDateList(this.m_List, this.m_Suppress);
    }

    public static List<Date> toDateList(DtList list) {
        return FriendlyList.toDateList(list, false);
    }

    public static List<Date> toDateList(final DtList list, final boolean suppress) {
        final int size = FriendlyList.sizeOf(list);
        if (size == 0) {
            return Collections.emptyList();
        }
        return new AbstractList<Date>(){

            @Override
            public Date get(int index) {
                return FriendlyList.getDate(list, index, suppress);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public List<Integer> toIntList() {
        return FriendlyList.toIntList(this.m_List, this.m_Suppress);
    }

    public static List<Integer> toIntList(DtList list) {
        return FriendlyList.toIntList(list, false);
    }

    public static List<Integer> toIntList(final DtList list, final boolean suppress) {
        final int size = FriendlyList.sizeOf(list);
        if (size == 0) {
            return Collections.emptyList();
        }
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return FriendlyList.getInt(list, index, 0, suppress);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public List<Number> toNumberList() {
        return FriendlyList.toNumberList(this.m_List, this.m_Suppress);
    }

    public static List<Number> toNumberList(DtList list) {
        return FriendlyList.toNumberList(list, false);
    }

    public static List<Number> toNumberList(final DtList list, final boolean suppress) {
        final int size = FriendlyList.sizeOf(list);
        if (size == 0) {
            return Collections.emptyList();
        }
        return new AbstractList<Number>(){

            @Override
            public Number get(int index) {
                return FriendlyList.getNumber(list, index, suppress).valueNumber();
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public int[] toIntArray() {
        return FriendlyList.toIntArray(this.m_List, this.m_Suppress);
    }

    public static int[] toIntArray(DtList list) {
        return FriendlyList.toIntArray(list, false);
    }

    public static int[] toIntArray(DtList list, boolean suppress) {
        int size = FriendlyList.sizeOf(list);
        if (size == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] arr = new int[size];
        int i = 0;
        while (i < size) {
            arr[i] = FriendlyList.getInt(list, i, 0, suppress);
            ++i;
        }
        return arr;
    }

    public long[] toLongArray() {
        return FriendlyList.toLongArray(this.m_List, this.m_Suppress);
    }

    public static long[] toLongArray(DtList list) {
        return FriendlyList.toLongArray(list, false);
    }

    public static long[] toLongArray(DtList list, boolean suppress) {
        int size = FriendlyList.sizeOf(list);
        if (size == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] arr = new long[size];
        int i = 0;
        while (i < size) {
            arr[i] = FriendlyList.getLong(list, i, 0L, suppress);
            ++i;
        }
        return arr;
    }

    public double[] toDoubleArray() {
        return FriendlyList.toDoubleArray(this.m_List, this.m_Suppress);
    }

    public static double[] toDoubleArray(DtList list) {
        return FriendlyList.toDoubleArray(list, false);
    }

    public static double[] toDoubleArray(DtList list, boolean suppress) {
        int size = FriendlyList.sizeOf(list);
        if (size == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] arr = new double[size];
        int i = 0;
        while (i < size) {
            arr[i] = FriendlyList.getDouble(list, i, 0.0, suppress);
            ++i;
        }
        return arr;
    }

    public boolean[] toBooleanArray() {
        return FriendlyList.toBooleanArray(this.m_List, this.m_Suppress);
    }

    public static boolean[] toBooleanArray(DtList list) {
        return FriendlyList.toBooleanArray(list, false);
    }

    public static boolean[] toBooleanArray(DtList list, boolean suppress) {
        int size = FriendlyList.sizeOf(list);
        if (size == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] arr = new boolean[size];
        int i = 0;
        while (i < size) {
            arr[i] = FriendlyList.getBoolean(list, i, false, suppress);
            ++i;
        }
        return arr;
    }

    protected <E extends DtBase> E getItem(int index, DataType type) {
        return FriendlyList.getItem(this.m_List, index, type, this.m_Suppress);
    }

    protected static int sizeOf(DtList list) {
        return list == null ? 0 : list.size();
    }

    protected static <E extends DtBase> E getItem(DtList list, int index, DataType type, boolean suppress) {
        int size = FriendlyList.sizeOf(list);
        if (index < 0 || index >= size) {
            if (suppress) {
                return null;
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
        try {
            Object item = list.getItem(index, type);
            return item;
        }
        catch (DataTypeCastExecption e) {
            if (suppress) {
                return null;
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (suppress) {
                return null;
            }
            throw new DataTypeCastExecption(e);
        }
    }

    public int getInt(int index) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getInt(this.m_List, index, 0, this.m_Suppress);
    }

    public int getInt(int index, int defalutValue) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getInt(this.m_List, index, defalutValue, this.m_Suppress);
    }

    public static int getInt(DtList list, int index, int defalutValue) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getInt(list, index, defalutValue, false);
    }

    public static int getInt(DtList list, int index, int defalutValue, boolean suppress) throws DataTypeCastExecption, IndexOutOfBoundsException {
        DtNumber num = FriendlyList.getNumber(list, index, suppress);
        if (num == null) {
            return defalutValue;
        }
        return num.valueInt();
    }

    public long getLong(int index) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getLong(this.m_List, index, 0L, this.m_Suppress);
    }

    public long getLong(int index, long defalutValue) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getLong(this.m_List, index, defalutValue, this.m_Suppress);
    }

    public static long getLong(DtList list, int index, long defalutValue) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getLong(list, index, defalutValue, false);
    }

    public static long getLong(DtList list, int index, long defalutValue, boolean suppress) throws DataTypeCastExecption, IndexOutOfBoundsException {
        DtNumber num = FriendlyList.getNumber(list, index, suppress);
        if (num == null) {
            return defalutValue;
        }
        return num.valueLong();
    }

    public double getDouble(int index) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getDouble(this.m_List, index, 0.0, this.m_Suppress);
    }

    public double getDouble(int index, double defalutValue) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getDouble(this.m_List, index, defalutValue, this.m_Suppress);
    }

    public static double getDouble(DtList list, int index, double defalutValue) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getDouble(list, index, defalutValue, false);
    }

    public static double getDouble(DtList list, int index, double defalutValue, boolean suppress) throws DataTypeCastExecption, IndexOutOfBoundsException {
        DtNumber num = FriendlyList.getNumber(list, index, suppress);
        if (num == null) {
            return defalutValue;
        }
        return num.valueDouble();
    }

    public DtNumber getNumber(int index) {
        return (DtNumber)FriendlyList.getItem(this.m_List, index, DataType.NUMBER, this.m_Suppress);
    }

    public static DtNumber getNumber(DtList list, int index) {
        return (DtNumber)FriendlyList.getItem(list, index, DataType.NUMBER, false);
    }

    public static DtNumber getNumber(DtList list, int index, boolean suppress) {
        return (DtNumber)FriendlyList.getItem(list, index, DataType.NUMBER, suppress);
    }

    public String getString(int index) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getString(this.m_List, index, this.m_Suppress);
    }

    public static String getString(DtList list, int index) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getString(list, index, false);
    }

    public static String getString(DtList list, int index, boolean suppress) throws DataTypeCastExecption, IndexOutOfBoundsException {
        DtString str = (DtString)FriendlyList.getItem(list, index, DataType.STRING, suppress);
        if (str == null) {
            return null;
        }
        return str.value();
    }

    public Date getDate(int index) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getDate(this.m_List, index, this.m_Suppress);
    }

    public static Date getDate(DtList list, int index) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getDate(list, index, false);
    }

    public static Date getDate(DtList list, int index, boolean suppress) throws DataTypeCastExecption, IndexOutOfBoundsException {
        DtDate date = (DtDate)FriendlyList.getItem(list, index, DataType.DATE, suppress);
        if (date == null) {
            return null;
        }
        return date.valueDate();
    }

    public boolean getBoolean(int index) throws NullPointerException, DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getBoolean(this.m_List, index, false, this.m_Suppress);
    }

    public boolean getBoolean(int index, boolean defalutValue) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getBoolean(this.m_List, index, defalutValue, this.m_Suppress);
    }

    public static boolean getBoolean(DtList list, int index, boolean defalutValue) throws DataTypeCastExecption, IndexOutOfBoundsException {
        return FriendlyList.getBoolean(list, index, defalutValue, false);
    }

    public static boolean getBoolean(DtList list, int index, boolean defalutValue, boolean suppress) throws DataTypeCastExecption, IndexOutOfBoundsException {
        DtBoolean bool = (DtBoolean)FriendlyList.getItem(list, index, DataType.BOOLEAN, suppress);
        if (bool == null) {
            return defalutValue;
        }
        return bool.value();
    }
}

